/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.arrow;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanel;
import net.sf.jaxodraw.gui.panel.edit.JaxoEditPanelListener;
import net.sf.jaxodraw.gui.swing.spinner.JaxoFixedJSpinner;
import net.sf.jaxodraw.object.arrow.JaxoDefaultArrow;
import net.sf.jaxodraw.util.JaxoLanguage;

public class JaxoDefaultArrowEditPanel
extends JaxoEditPanel {
    private static final long serialVersionUID = 7526471155622776147L;
    private transient JSpinner splength;
    private transient JSpinner spwidth;
    private transient JSpinner spinset;
    private transient JCheckBox lockcb;
    private transient float lwRatio;
    private transient boolean adjusting;
    private final transient GridLayout layout = new GridLayout(0, 2);
    private final transient JaxoDefaultArrow theArrow;

    public JaxoDefaultArrowEditPanel(JaxoDefaultArrow arrow, boolean lockar) {
        this.theArrow = arrow;
        this.init(lockar);
    }

    private void init(boolean lockar) {
        float length = this.theArrow.getArrowLength();
        float width = this.theArrow.getArrowWidth();
        float inset = this.theArrow.getArrowInset();
        this.lwRatio = length / width;
        Dimension size = new Dimension(120, 20);
        JPanel plength = this.getLengthPanel(length);
        JPanel pwidth = this.getWidthPanel(width);
        JPanel pinset = this.getInsetPanel(inset);
        JPanel plockar = this.getLockArrowPanel(lockar);
        JPanel arrEPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints sc = new GridBagConstraints();
        arrEPanel.setLayout(gb);
        sc.gridx = 0;
        sc.gridy = 0;
        plength.setPreferredSize(size);
        arrEPanel.add((Component)plength, sc);
        sc.gridx = 0;
        sc.gridy = 1;
        sc.insets = new Insets(5, 0, 5, 0);
        pwidth.setPreferredSize(size);
        arrEPanel.add((Component)pwidth, sc);
        sc.gridx = 0;
        sc.gridy = 2;
        sc.insets = new Insets(0, 0, 5, 0);
        pinset.setPreferredSize(size);
        arrEPanel.add((Component)pinset, sc);
        sc.gridx = 1;
        sc.gridy = 0;
        sc.gridheight = 2;
        sc.insets = new Insets(0, 10, 5, 0);
        arrEPanel.add((Component)plockar, sc);
        this.setLineBoxLayout();
        TitledBorder arrETitle = this.createI18NBorder("JaxoArrowOptionsEditPanel.title");
        this.setBorder(arrETitle);
        this.add(arrEPanel);
    }

    public void addEditPanelListener(JaxoEditPanelListener listener) {
        if (listener != null) {
            this.splength.addChangeListener(listener);
            this.spwidth.addChangeListener(listener);
            this.spinset.addChangeListener(listener);
        }
    }

    private JPanel getLengthPanel(float length) {
        JPanel plength = new JPanel();
        plength.setLayout(this.layout);
        JLabel jlength = this.createI18NLabel("JaxoArrowOptionsEditPanel.length");
        plength.add(jlength);
        SpinnerNumberModel modelLength = new SpinnerNumberModel(Float.valueOf(length), Float.valueOf(0.0f), null, Float.valueOf(1.0f));
        this.splength = new JaxoFixedJSpinner(modelLength);
        this.splength.setName("splen");
        this.splength.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                if (JaxoDefaultArrowEditPanel.this.adjusting) {
                    return;
                }
                if (JaxoDefaultArrowEditPanel.this.lockcb.isSelected()) {
                    JaxoDefaultArrowEditPanel.this.adjusting = true;
                    try {
                        float len = ((Number)JaxoDefaultArrowEditPanel.this.splength.getValue()).floatValue();
                        float wid = len / JaxoDefaultArrowEditPanel.this.lwRatio;
                        JaxoDefaultArrowEditPanel.this.spwidth.setValue(wid);
                        JaxoDefaultArrowEditPanel.this.theArrow.setArrowLength(len);
                        JaxoDefaultArrowEditPanel.this.theArrow.setArrowWidth(wid);
                    }
                    finally {
                        JaxoDefaultArrowEditPanel.this.adjusting = false;
                    }
                } else {
                    float len = ((Number)JaxoDefaultArrowEditPanel.this.splength.getValue()).floatValue();
                    JaxoDefaultArrowEditPanel.this.theArrow.setArrowLength(len);
                }
            }
        });
        plength.add(this.splength);
        return plength;
    }

    private JPanel getWidthPanel(float width) {
        JPanel pwidth = new JPanel();
        pwidth.setLayout(this.layout);
        JLabel jwidth = this.createI18NLabel("JaxoArrowOptionsEditPanel.width");
        pwidth.add(jwidth);
        SpinnerNumberModel modelWidth = new SpinnerNumberModel(Float.valueOf(width), Float.valueOf(0.0f), null, Float.valueOf(1.0f));
        this.spwidth = new JaxoFixedJSpinner(modelWidth);
        this.spwidth.setName("spwid");
        this.spwidth.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(ChangeEvent e) {
                if (JaxoDefaultArrowEditPanel.this.adjusting) {
                    return;
                }
                if (JaxoDefaultArrowEditPanel.this.lockcb.isSelected()) {
                    JaxoDefaultArrowEditPanel.this.adjusting = true;
                    try {
                        float wid = ((Number)JaxoDefaultArrowEditPanel.this.spwidth.getValue()).floatValue();
                        float len = JaxoDefaultArrowEditPanel.this.lwRatio * wid;
                        JaxoDefaultArrowEditPanel.this.splength.setValue(len);
                        JaxoDefaultArrowEditPanel.this.theArrow.setArrowLength(len);
                        JaxoDefaultArrowEditPanel.this.theArrow.setArrowWidth(wid);
                    }
                    finally {
                        JaxoDefaultArrowEditPanel.this.adjusting = false;
                    }
                } else {
                    float wid = ((Number)JaxoDefaultArrowEditPanel.this.spwidth.getValue()).floatValue();
                    JaxoDefaultArrowEditPanel.this.theArrow.setArrowWidth(wid);
                }
            }
        });
        pwidth.add(this.spwidth);
        return pwidth;
    }

    private JPanel getInsetPanel(float inset) {
        JPanel pinset = new JPanel();
        pinset.setLayout(this.layout);
        JLabel jinset = this.createI18NLabel("JaxoArrowOptionsEditPanel.inset");
        pinset.add(jinset);
        SpinnerNumberModel modelinset = new SpinnerNumberModel(Float.valueOf(inset), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.05f));
        this.spinset = new JaxoFixedJSpinner(modelinset);
        this.spinset.setName("spinset");
        this.spinset.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                float ins = ((Number)JaxoDefaultArrowEditPanel.this.spinset.getValue()).floatValue();
                JaxoDefaultArrowEditPanel.this.theArrow.setArrowInset(ins);
            }
        });
        pinset.add(this.spinset);
        return pinset;
    }

    private JPanel getLockArrowPanel(boolean lockar) {
        JPanel plockar = new JPanel();
        plockar.setLayout(this.layout);
        this.lockcb = new JCheckBox(JaxoLanguage.translate("JaxoArrowOptionsEditPanel.lockar"));
        this.lockcb.setName("lockar");
        this.lockcb.setEnabled(true);
        this.lockcb.setSelected(lockar);
        this.lockcb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (JaxoDefaultArrowEditPanel.this.lockcb.isSelected()) {
                    float len = ((Number)JaxoDefaultArrowEditPanel.this.splength.getValue()).floatValue();
                    float wid = ((Number)JaxoDefaultArrowEditPanel.this.spwidth.getValue()).floatValue();
                    JaxoDefaultArrowEditPanel.this.lwRatio = len / wid;
                }
            }
        });
        plockar.add(this.lockcb);
        return plockar;
    }
}

