/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io;

import java.awt.Component;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.graph.JaxoSaveGraph;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.gui.panel.JaxoChooseFile;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLog;
import net.sf.jaxodraw.util.JaxoPrefs;

public final class JaxoIO {
    private final Component parent;

    public JaxoIO(Component parentc) {
        this.parent = parentc;
    }

    public static URL toURL(File f) throws IOException {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IOException("File " + f + " cannot be converted to URL", e);
        }
    }

    public static String absoluteName(String fileName) {
        return new File(fileName).getAbsolutePath();
    }

    public static String currentDirectoryString() {
        return JaxoPrefs.getStringPref("prefUSERDIR").concat(File.separator);
    }

    public static String directoryString(String fileName) {
        return new File(fileName).getParent().concat(File.separator);
    }

    public static String shortName(String fileName) {
        return new File(fileName).getName();
    }

    public static String extension(String fileName) {
        int lp = fileName.lastIndexOf(46);
        return lp < 1 ? "" : fileName.substring(lp + 1);
    }

    public static String baseName(String fileName) {
        int lp = fileName.lastIndexOf(46);
        return lp < 1 ? fileName : fileName.substring(0, lp);
    }

    public static String withExtension(String name, String extension) {
        StringBuffer fileName = new StringBuffer(name);
        if (name.length() > 0 && !name.endsWith("." + extension)) {
            fileName.append('.').append(extension);
        }
        return fileName.toString();
    }

    public void save(JaxoGraph graph, String title, String fileName) {
        if (graph.getSaveFileName().length() == 0) {
            String saveFileName = this.getSaveFileName(title, fileName);
            if (saveFileName.length() != 0) {
                this.doSave(graph, title, saveFileName);
                graph.setSaved(true);
            }
        } else {
            this.doSave(graph, title, graph.getSaveFileName());
            graph.setSaved(true);
        }
    }

    public void saveAs(JaxoGraph graph, String title, String fileName) {
        String saveFileName = this.getSaveFileName(title, fileName);
        if (saveFileName.length() != 0) {
            this.doSave(graph, title, saveFileName);
            graph.setSaved(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave(JaxoGraph graph, String title, String fileName) {
        String trimName = JaxoIO.withExtension(fileName.trim(), "xml");
        File f = new File(trimName);
        graph.setSaveFileName(trimName);
        graph.getSaveGraph().setJaxoDrawVersion(JaxoInfo.VERSION_NUMBER);
        Listener l = new Listener();
        BufferedOutputStream out = null;
        XMLEncoder encoder = null;
        try {
            try {
                out = new BufferedOutputStream(new FileOutputStream(trimName));
            }
            catch (FileNotFoundException e) {
                JaxoLog.debug(e);
                this.showSaveError(f, title, "JaxoIO.write%0OpenFailed%1");
                if (encoder == null) {
                    if (out != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException e2) {
                            l.exceptionThrown(e2);
                        }
                    }
                } else {
                    encoder.close();
                }
                return;
            }
            encoder = new XMLEncoder(out);
            encoder.setExceptionListener(l);
            encoder.writeObject(graph.getSaveGraph());
        }
        finally {
            if (encoder == null) {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {
                        l.exceptionThrown(e);
                    }
                }
            } else {
                encoder.close();
            }
        }
        if (l.hasFailed()) {
            if (l.ioFailure() == null) {
                this.showSaveError(f, title, "JaxoIO.save%0SavingFailed%1");
            } else {
                this.showSaveError(f, title, "JaxoIO.write%0WriteFailed%1");
            }
        }
    }

    public static boolean shouldOverwrite(Component parent, File f) {
        return JaxoIO.shouldOverwrite(parent, f, null);
    }

    public static boolean shouldOverwrite(Component parent, File f, String dTitle) {
        if (!f.exists()) {
            return true;
        }
        String title = dTitle;
        if (title == null) {
            title = JaxoLanguage.message("JaxoIO.overwrite.defaultTitle%0", f);
        }
        String s1 = JaxoLanguage.translate("JaxoIO.overwrite.Overwrite");
        String s2 = JaxoLanguage.translate("JaxoIO.overwrite.Cancel");
        Object[] options = new Object[]{s1, s2};
        return JOptionPane.showOptionDialog(parent, JaxoLanguage.message("JaxoIO.overwrite.message%0", f), JaxoDialogs.translatedWindowTitle(title), 0, 3, null, options, s1) == 0;
    }

    private String getSaveFileName(String title, String fileName) {
        JaxoChooseFile c = new JaxoChooseFile(this.parent);
        c.setApproveText(JaxoLanguage.translate("JaxoIO.saveApproveText"));
        if (title.length() == 0) {
            c.setDialogTitle(JaxoLanguage.translate("JaxoIO.saveDialogTitle"));
        } else {
            c.setDialogTitle(JaxoLanguage.message("JaxoIO.saveNamed%0DialogTitle", title));
        }
        String saveFileName = c.chooseFile(new String[]{"xml"}, JaxoLanguage.translate("JaxoIO.JaxoDrawFileDescription"), fileName);
        saveFileName = JaxoIO.withExtension(saveFileName.trim(), "xml");
        if (saveFileName.length() > 0 && !JaxoIO.shouldOverwrite(this.parent, new File(saveFileName))) {
            saveFileName = "";
        }
        return saveFileName;
    }

    private void showVersionMismatch(String message, String titleKey) {
        JOptionPane.showMessageDialog(this.parent, message, JaxoDialogs.translatedWindowTitle(titleKey), 0);
    }

    private void showError(File f, String key, String title) {
        JOptionPane.showMessageDialog(this.parent, JaxoLanguage.message(key, f), JaxoDialogs.translatedWindowTitle(title), 0);
    }

    private void showOpenError(File f, String key) {
        this.showError(f, key, JaxoLanguage.message("JaxoIO.open%0ErrorTitle", new Object[]{f}));
    }

    private void showSaveError(File f, String title, String key) {
        this.showError(f, key, JaxoLanguage.message("JaxoIO.save%0ErrorTitle", new Object[]{f, title}));
    }

    public JaxoGraph open() {
        String openFileName = this.getOpenFileName();
        if (openFileName.length() != 0) {
            return this.open(openFileName);
        }
        return null;
    }

    public JaxoGraph open(String name) {
        return this.open(new File(name));
    }

    public JaxoGraph open(File f) {
        return this.open(f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxoGraph open(File f, boolean guiWarnings) {
        String fileName = f.getAbsolutePath();
        JaxoSaveGraph newSaveGraph = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e) {
            JaxoLog.debug(e);
            if (guiWarnings) {
                if (f.exists()) {
                    this.showOpenError(f, "JaxoIO.read%0OpenFailed");
                } else {
                    this.showOpenError(f, "JaxoIO.read%0NotFound");
                }
            }
            return null;
        }
        Listener l = new Listener();
        XMLDecoder decoder = new XMLDecoder(in, null, l);
        try {
            newSaveGraph = (JaxoSaveGraph)decoder.readObject();
        }
        finally {
            decoder.close();
        }
        if (l.hasFailed()) {
            if (guiWarnings) {
                if (l.ioFailure() == null) {
                    this.showOpenError(f, "JaxoIO.open%0ParsingFailed");
                } else {
                    this.showOpenError(f, "JaxoIO.read%0ReadFailed");
                }
            }
            return null;
        }
        JaxoGraph openedGraph = new JaxoGraph();
        if (newSaveGraph != null) {
            openedGraph.setSaveGraph(newSaveGraph);
            String fileVersion = newSaveGraph.getJaxoDrawVersion();
            if (JaxoInfo.compareVersion(fileVersion) != 0 && guiWarnings) {
                this.showVersionMismatch(JaxoLanguage.message("JaxoIO.versionMismatch%0%1%2", new Object[]{f, fileVersion, JaxoInfo.VERSION_NUMBER}), JaxoLanguage.message("JaxoIO.open%0versionMismatchTitle", new Object[]{f}));
            }
        }
        openedGraph.setSaved(true);
        openedGraph.setSaveFileName(fileName);
        return openedGraph;
    }

    private String getOpenFileName() {
        String openFileName = "";
        JaxoChooseFile c = new JaxoChooseFile(this.parent);
        c.setApproveText(JaxoLanguage.translate("JaxoIO.openApproveText"));
        c.setDialogTitle(JaxoLanguage.translate("JaxoIO.openDialogTitle"));
        openFileName = c.chooseFile(new String[]{"xml"}, JaxoLanguage.translate("JaxoIO.JaxoDrawFileDescription"), "");
        return openFileName;
    }

    private static class Listener
    implements ExceptionListener {
        private IOException ioFailure;
        private Exception lastException;

        private Listener() {
        }

        public void exceptionThrown(Exception e) {
            JaxoLog.debug(e);
            if (e instanceof IOException) {
                this.ioFailure = (IOException)e;
            }
            this.lastException = e;
        }

        public final Exception ioFailure() {
            return this.ioFailure;
        }

        public final Exception lastException() {
            return this.lastException;
        }

        public boolean hasFailed() {
            return this.lastException != null;
        }
    }
}

