/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import net.sf.jaxodraw.gui.swing.TabClosingEvent;
import net.sf.jaxodraw.gui.swing.TabClosingListener;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoClosableTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final Insets TAB_INSETS = new Insets(3, 0, 3, 0);
    private final IndexButtonModel button;
    private final IndexButtonModel tabRollover;
    private final CloseButtonListener closeButtonListener;
    private final Icon defaultIcon = JaxoUtils.newImageIcon("closabletab_notselected.png");
    private final Icon selectedIcon = JaxoUtils.newImageIcon("closabletab_selected.png");
    private final Icon rolloverIcon = JaxoUtils.newImageIcon("closabletab_close.png");
    private final Icon pressedIcon = JaxoUtils.newImageIcon("closabletab_selected.png");
    private final Icon pressedArmedIcon = JaxoUtils.newImageIcon("closabletab_close.png");

    public JaxoClosableTabbedPane() {
        this.tabRollover = new IndexButtonModel();
        this.button = new IndexButtonModel();
        this.closeButtonListener = new CloseButtonListener();
        this.addMouseListener(this.closeButtonListener);
        this.addMouseMotionListener(this.closeButtonListener);
    }

    public void addNotify() {
        super.addNotify();
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w != null) {
            w.addWindowFocusListener(this.closeButtonListener);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w != null) {
            w.removeWindowFocusListener(this.closeButtonListener);
        }
        this.closeButtonListener.reset();
    }

    public void updateUI() {
        super.updateUI();
        this.updateAllCombinedIcons();
    }

    public void setFont(Font font) {
        boolean changed = font != this.getFont();
        super.setFont(font);
        if (changed) {
            this.updateAllCombinedIcons();
        }
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        this.tabAdded(index);
    }

    public void removeTabAt(int index) {
        super.removeTabAt(index);
        this.tabRemoved(index);
    }

    private void updateAllCombinedIcons() {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            CombinedIcon old = this.getCombinedIconAt(i);
            this.setIconAt(i, (Icon)old.copy());
        }
    }

    private CombinedIcon getCombinedIconAt(int index) {
        return (CombinedIcon)this.getIconAt(index);
    }

    public boolean isClosableAt(int index) {
        return this.getCombinedIconAt(index).isClosable();
    }

    public void setClosableAt(int index, boolean value) {
        if (value != this.isClosableAt(index)) {
            this.setIconAt(index, this.getCombinedIconAt(index).cloneWithClosable(value));
        }
    }

    public int getFontStyleAt(int index) {
        return this.getCombinedIconAt(index).getFontStyle();
    }

    public void setFontStyleAt(int index, int value) {
        if (value != this.getFontStyleAt(index)) {
            this.setIconAt(index, this.getCombinedIconAt(index).cloneWithFontStyle(value));
        }
    }

    public void addClosableTab(String title, Component c) {
        this.addClosableTab(this.getTabCount(), title, null, c);
    }

    public void addClosableTab(String title, Icon n, Component c) {
        this.addClosableTab(this.getTabCount(), title, n, c);
    }

    public void addClosableTab(int index, String title, Component c) {
        this.addClosableTab(index, title, null, c);
    }

    public void addClosableTab(int index, String title, Icon n, Component c) {
        this.insertTab(null, new CombinedIcon(index, title, n), c, null, index);
    }

    public void setClosableTitleAt(int index, String value) {
        String old = this.getClosableTitleAt(index);
        if (value == null ? old != null : !value.equals(old)) {
            this.setIconAt(index, this.getCombinedIconAt(index).cloneWithTitle(value));
        }
    }

    public String getClosableTitleAt(int index) {
        return this.getCombinedIconAt(index).getTitle();
    }

    public void setClosableIconAt(int index, Icon value) {
        if (value != this.getClosableIconAt(index)) {
            this.setIconAt(index, this.getCombinedIconAt(index).cloneWithIcon(value));
        }
    }

    public Icon getClosableIconAt(int index) {
        return this.getCombinedIconAt(index).getIcon();
    }

    public void addClosingListener(TabClosingListener l) {
        this.listenerList.add(TabClosingListener.class, l);
    }

    public void removeClosingListener(TabClosingListener l) {
        this.listenerList.remove(TabClosingListener.class, l);
    }

    protected void fireClosing(int index) {
        Object[] pairs = this.listenerList.getListenerList();
        TabClosingEvent e = null;
        for (int i = pairs.length - 2; i >= 0; i -= 2) {
            if (pairs[i] != TabClosingListener.class) continue;
            if (e == null) {
                e = new TabClosingEvent(this, index);
            }
            ((TabClosingListener)pairs[i + 1]).closing(e);
        }
    }

    public void closingTab(int index) {
        if (!this.isClosableAt(index)) {
            throw new IllegalArgumentException("Not closable " + index);
        }
        this.fireClosing(index);
    }

    private void tabRemoved(int index) {
        this.closeButtonListener.tabRemoved(index);
        for (int i = index; i < this.getTabCount(); ++i) {
            --this.getCombinedIconAt(i).index;
        }
    }

    private void tabAdded(int index) {
        this.closeButtonListener.tabAdded(index);
        for (int i = index + 1; i < this.getTabCount(); ++i) {
            this.getCombinedIconAt(i).index++;
        }
    }

    private class CombinedIcon
    implements Icon,
    Cloneable {
        private int index;
        private String title;
        private Icon icon;
        private boolean closable = true;
        private int fontStyle;
        private int gap;
        private Rectangle lastButtonBounds;

        CombinedIcon(int ind, String text, Icon ico) {
            this.index = ind;
            this.icon = ico;
            this.fontStyle = 0;
            this.title = text;
            this.gap = -1;
        }

        public final int getFontStyle() {
            return this.fontStyle;
        }

        public final String getTitle() {
            return this.title;
        }

        public final Icon getIcon() {
            return this.icon;
        }

        public final boolean isClosable() {
            return this.closable;
        }

        public Object clone() throws CloneNotSupportedException {
            CombinedIcon clone = (CombinedIcon)super.clone();
            clone.gap = -1;
            clone.lastButtonBounds = null;
            return clone;
        }

        public Object copy() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new Error(ex);
            }
        }

        public Icon cloneWithFontStyle(int value) {
            CombinedIcon clone = (CombinedIcon)this.copy();
            clone.fontStyle = value;
            return clone;
        }

        public Icon cloneWithIcon(Icon value) {
            CombinedIcon clone = (CombinedIcon)this.copy();
            clone.icon = value;
            return clone;
        }

        public Icon cloneWithTitle(String value) {
            CombinedIcon clone = (CombinedIcon)this.copy();
            clone.title = value;
            return clone;
        }

        public Icon cloneWithClosable(boolean value) {
            CombinedIcon clone = (CombinedIcon)this.copy();
            clone.closable = value;
            return clone;
        }

        public boolean isContainedInButton(Point p) {
            if (!this.closable) {
                return false;
            }
            if (this.lastButtonBounds == null) {
                return false;
            }
            return this.lastButtonBounds.contains(p);
        }

        protected Font getTabFont() {
            Font f = JaxoClosableTabbedPane.this.getFont();
            if (f.getStyle() != this.fontStyle) {
                f = f.deriveFont(this.fontStyle);
            }
            return f;
        }

        public void paintIcon(Component c, Graphics gg, int xx, int yy) {
            Graphics g = gg.create();
            int x = xx;
            int y = yy;
            g.setColor(JaxoClosableTabbedPane.this.getForegroundAt(this.index));
            g.setFont(this.getTabFont());
            x += TAB_INSETS.left;
            y += TAB_INSETS.top;
            int height = this.getIconHeight() - TAB_INSETS.top - TAB_INSETS.bottom;
            FontMetrics m = g.getFontMetrics();
            if (this.gap == -1) {
                this.gap = m.charWidth(' ');
            }
            int titleWidth = this.title == null ? 0 : m.stringWidth(this.title);
            int iconTitleGap = this.icon == null || this.title == null ? 0 : this.gap;
            int titleButtonGap = iconTitleGap != 0 && this.closable ? 2 * this.gap : 0;
            int titleHeight = m.getHeight();
            int iconHeight = this.icon == null ? 0 : this.icon.getIconHeight();
            int shift = (titleHeight - iconHeight) / 2;
            int textDY = shift < 0 ? shift : 0;
            int iconDY = shift > 0 ? shift : 0;
            int textIconDY = Math.max(0, height - Math.max(titleHeight, iconHeight)) / 2;
            if (this.icon != null) {
                this.icon.paintIcon(c, g, x, y + iconDY + textIconDY);
                x += this.icon.getIconWidth();
            }
            if (this.title != null) {
                g.setColor(JaxoClosableTabbedPane.this.getForegroundAt(this.index));
                g.setFont(this.getTabFont());
                g.drawString(this.title, x += iconTitleGap, y + m.getAscent() + textDY + textIconDY);
                x += titleWidth;
            }
            if (this.closable) {
                x += titleButtonGap;
                Dimension d = new Dimension(JaxoClosableTabbedPane.this.defaultIcon.getIconWidth(), JaxoClosableTabbedPane.this.defaultIcon.getIconHeight());
                Icon paintedButtonIcon = this.index == JaxoClosableTabbedPane.this.button.getIndex() ? (JaxoClosableTabbedPane.this.button.isPressed() ? (JaxoClosableTabbedPane.this.button.isArmed() ? JaxoClosableTabbedPane.this.pressedArmedIcon : JaxoClosableTabbedPane.this.pressedIcon) : JaxoClosableTabbedPane.this.rolloverIcon) : (this.index == JaxoClosableTabbedPane.this.getSelectedIndex() ? JaxoClosableTabbedPane.this.selectedIcon : JaxoClosableTabbedPane.this.defaultIcon);
                if (this.lastButtonBounds == null) {
                    this.lastButtonBounds = new Rectangle();
                }
                this.lastButtonBounds.setBounds(x, y + (height - d.height) / 2, d.width, d.height);
                paintedButtonIcon.paintIcon(c, g, x, y + (height - d.height) / 2);
            }
            g.dispose();
        }

        public int getIconWidth() {
            FontMetrics m = JaxoClosableTabbedPane.this.getFontMetrics(this.getTabFont());
            if (this.gap == -1) {
                this.gap = m.charWidth(' ');
            }
            int titleWidth = this.title == null ? 0 : m.stringWidth(this.title);
            int iconWidth = this.icon == null ? 0 : this.icon.getIconWidth();
            int iconTitleGap = this.icon == null || this.title == null ? 0 : this.gap;
            int buttonWidth = this.closable ? JaxoClosableTabbedPane.this.defaultIcon.getIconWidth() : 0;
            int titleButtonGap = iconTitleGap != 0 && this.closable ? 2 * this.gap : 0;
            return TAB_INSETS.left + TAB_INSETS.right + iconWidth + iconTitleGap + titleWidth + titleButtonGap + buttonWidth;
        }

        public int getIconHeight() {
            FontMetrics m = JaxoClosableTabbedPane.this.getFontMetrics(this.getTabFont());
            int titleHeight = m.getHeight();
            int iconHeight = this.icon == null ? 0 : this.icon.getIconHeight();
            return TAB_INSETS.top + TAB_INSETS.bottom + Math.max(JaxoClosableTabbedPane.this.defaultIcon.getIconHeight(), Math.max(titleHeight, iconHeight));
        }
    }

    private class CloseButtonListener
    extends MouseInputAdapter
    implements WindowFocusListener {
        private int pressedCount;

        private CloseButtonListener() {
        }

        public void windowGainedFocus(WindowEvent e) {
        }

        public void windowLostFocus(WindowEvent e) {
            this.reset();
        }

        public void reset() {
            this.setRollover(-1, false);
            this.pressedCount = 0;
        }

        public void tabRemoved(int index) {
            JaxoClosableTabbedPane.this.tabRollover.removeIndex(index);
            JaxoClosableTabbedPane.this.button.removeIndex(index);
        }

        public void tabAdded(int index) {
            JaxoClosableTabbedPane.this.tabRollover.insertIndex(index);
            JaxoClosableTabbedPane.this.button.insertIndex(index);
        }

        private void repaintAt(IndexButtonModel m) {
            if (m.getIndex() != -1) {
                JaxoClosableTabbedPane.this.repaint(JaxoClosableTabbedPane.this.getBoundsAt(m.getIndex()));
            }
        }

        private boolean isContainedInButton(int index, Point p) {
            return index != -1 && JaxoClosableTabbedPane.this.getCombinedIconAt(index).isContainedInButton(p);
        }

        private void setRollover(int index, boolean inButton) {
            if (index == -1) {
                this.repaintAt(JaxoClosableTabbedPane.this.tabRollover);
                JaxoClosableTabbedPane.this.tabRollover.reset();
                JaxoClosableTabbedPane.this.button.reset();
            } else {
                boolean noChange;
                boolean bl = noChange = JaxoClosableTabbedPane.this.tabRollover.isRollover() && JaxoClosableTabbedPane.this.tabRollover.getIndex() == index && inButton == JaxoClosableTabbedPane.this.button.isRollover();
                if (!noChange) {
                    JaxoClosableTabbedPane.this.tabRollover.setRollover(true);
                    JaxoClosableTabbedPane.this.tabRollover.setIndex(index);
                    JaxoClosableTabbedPane.this.button.setIndex(inButton ? index : -1);
                    JaxoClosableTabbedPane.this.button.setRollover(inButton);
                    this.repaintAt(JaxoClosableTabbedPane.this.tabRollover);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (this.pressedCount == 0) {
                int index = JaxoClosableTabbedPane.this.indexAtLocation(e.getX(), e.getY());
                boolean inButton = this.isContainedInButton(index, e.getPoint());
                this.setRollover(index, inButton);
            } else {
                this.setRollover(-1, false);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (this.pressedCount == 0) {
                this.mouseMoved(e);
            } else {
                this.mouseDragged(e);
            }
            ++this.pressedCount;
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (JaxoClosableTabbedPane.this.button.getIndex() != -1) {
                JaxoClosableTabbedPane.this.button.setPressed(true);
                JaxoClosableTabbedPane.this.button.setArmed(true);
                this.repaintAt(JaxoClosableTabbedPane.this.button);
            }
        }

        public void mouseDragged(MouseEvent e) {
            boolean armed;
            if (!JaxoClosableTabbedPane.this.button.isPressed()) {
                this.mouseMoved(e);
                return;
            }
            int index = JaxoClosableTabbedPane.this.indexAtLocation(e.getX(), e.getY());
            boolean bl = armed = index == JaxoClosableTabbedPane.this.button.getIndex() && this.isContainedInButton(index, e.getPoint());
            if (armed != JaxoClosableTabbedPane.this.button.isArmed()) {
                JaxoClosableTabbedPane.this.button.setArmed(armed);
                this.repaintAt(JaxoClosableTabbedPane.this.button);
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.mouseDragged(e);
            --this.pressedCount;
            if (SwingUtilities.isLeftMouseButton(e) && JaxoClosableTabbedPane.this.button.isPressed()) {
                if (JaxoClosableTabbedPane.this.button.isArmed()) {
                    JaxoClosableTabbedPane.this.fireClosing(JaxoClosableTabbedPane.this.button.getIndex());
                }
                this.repaintAt(JaxoClosableTabbedPane.this.button);
                JaxoClosableTabbedPane.this.button.reset();
            }
            if (this.isNoButtonDown(e)) {
                this.mouseMoved(e);
            }
        }

        private boolean isNoButtonDown(MouseEvent e) {
            return (e.getModifiersEx() & 0x1C00) == 0;
        }

        public void mouseEntered(MouseEvent e) {
            if (this.pressedCount > 0) {
                this.mouseDragged(e);
            } else if (this.isNoButtonDown(e)) {
                this.mouseMoved(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.pressedCount > 0) {
                this.mouseDragged(e);
            } else if (this.isNoButtonDown(e)) {
                this.mouseMoved(e);
            }
        }
    }

    private static class IndexButtonModel
    extends DefaultButtonModel {
        private static final long serialVersionUID = 7526471155622776147L;
        private int index = -1;

        IndexButtonModel() {
        }

        public void setIndex(int value) {
            this.index = value;
        }

        public void shiftIndex(int value) {
            this.index += value;
        }

        public void insertIndex(int value) {
            if (this.index >= value) {
                ++this.index;
            }
        }

        public void removeIndex(int value) {
            if (this.index == value) {
                this.index = -1;
            } else if (this.index > value) {
                --this.index;
            }
        }

        public int getIndex() {
            return this.index;
        }

        public void reset() {
            this.setIndex(-1);
        }
    }
}

