/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.button;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import net.sf.jaxodraw.gui.panel.button.JaxoButtonPanel;
import net.sf.jaxodraw.gui.panel.button.JaxoPanelButton;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoParticleButtons
extends JPanel
implements JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final String[] PARTICLE_BUTTON_ICONS = new String[]{"fline.png", "floop.png", "farc.png", "bezierf.png", "sline.png", "sloop.png", "sarc.png", "beziers.png", "gline.png", "gloop.png", "garc.png", "bezierg.png", "photon.png", "photonloop.png", "photonarc.png", "bezierph.png", "gluon.png", "gluonloop.png", "gluonarc.png", "beziergl.png"};
    private static final int[] PARTICLE_MODES = new int[]{3, 4, 5, 18, 6, 7, 8, 21, 9, 10, 11, 22, 12, 13, 14, 19, 15, 16, 17, 20};
    private static final int NOF_BUTTONS = PARTICLE_MODES.length;
    private static final String[] TOOLTIP_KEYS = new String[]{"Draw_a_fermion_line", "Draw_a_fermion_loop", "Draw_a_fermion_arc", "Draw_a_fermion_bezier", "Draw_a_scalar_line", "Draw_a_scalar_loop", "Draw_a_scalar_arc", "Draw_a_scalar_bezier", "Draw_a_ghost_line", "Draw_a_ghost_loop", "Draw_a_ghost_arc", "Draw_a_ghost_bezier", "Draw_a_photon_line", "Draw_a_photon_loop", "Draw_a_photon_arc", "Draw_a_photon_bezier", "Draw_a_gluon_line", "Draw_a_gluon_loop", "Draw_a_gluon_arc", "Draw_a_gluon_bezier"};
    private final JaxoPanelButton[] particleButtons = new JaxoPanelButton[NOF_BUTTONS];

    public JaxoParticleButtons() {
        super(new GridBagLayout());
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.particleButtons[i] = new JaxoPanelButton();
            this.particleButtons[i].setIcon(JaxoUtils.newImageIcon(PARTICLE_BUTTON_ICONS[i]));
            this.particleButtons[i].setToolTipText(JaxoLanguage.translate(TOOLTIP_KEYS[i]));
            this.particleButtons[i].setId(JaxoConstants.getModeAsString(PARTICLE_MODES[i]));
        }
        GridBagConstraints c = (GridBagConstraints)JaxoButtonPanel.BUTTON_CONSTRAINTS.clone();
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 4; ++x) {
                c.gridx = x;
                c.gridy = y;
                this.add((Component)this.particleButtons[x + 4 * y], c);
            }
        }
    }

    public final void addActionListener(ActionListener l) {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.particleButtons[i].addActionListener(l);
        }
    }

    private void unsetButtons() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.particleButtons[i].setSelected(false);
        }
    }

    private int getIndex(int i) {
        int j = NOF_BUTTONS + 1;
        for (int jj = 0; jj < NOF_BUTTONS; ++jj) {
            if (i != PARTICLE_MODES[jj]) continue;
            j = jj;
        }
        return j;
    }

    public final void setDefault(int mode) {
        this.resetDefault();
        if (JaxoConstants.isParticleMode(mode)) {
            int j = this.getIndex(mode);
            this.particleButtons[j].setDefault(true);
        }
    }

    private void resetDefault() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.particleButtons[i].setDefault(false);
        }
    }

    public final void pressButton(int mode) {
        this.unsetButtons();
        if (JaxoConstants.isParticleMode(mode)) {
            int j = this.getIndex(mode);
            this.particleButtons[j].setSelected(true);
        }
    }

    public final void updateLanguage() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.particleButtons[i].setToolTipText(JaxoLanguage.translate(TOOLTIP_KEYS[i]));
        }
    }
}

