/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import net.sf.jaxodraw.gui.menu.JaxoMenu;
import net.sf.jaxodraw.gui.menu.JaxoMenuUtils;
import net.sf.jaxodraw.io.JaxoIO;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoPrefs;

public class OpenRecentMenu
extends JaxoMenu {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final int MAX_SIZE = 100;
    private final List<JMenuItem> recentFiles = new ArrayList<JMenuItem>(100);

    public OpenRecentMenu() {
        this.readRecentFiles();
        this.addSeparator();
        this.add(this.clearRFMenuItem());
        if (this.getItemCount() == 2) {
            this.getItem(1).setEnabled(false);
        }
        JaxoMenuUtils.setLanguageKey(this, "OpenRecentMenu.title");
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if ("Jaxo.recentFile".equals(name)) {
            if (e.getNewValue() == null) {
                this.removeRecentFile((String)e.getOldValue());
            } else if (e.getOldValue() == null) {
                this.addRecentFile((String)e.getNewValue());
            }
        }
    }

    public final void addRecentFile(String saveFileName) {
        if (saveFileName.length() > 0) {
            this.doAddRecentFile(saveFileName);
            this.pushRecentFiles();
        }
    }

    public final void removeRecentFile(String saveFileName) {
        Iterator<JMenuItem> i = this.recentFiles.iterator();
        while (i.hasNext()) {
            JMenuItem m = i.next();
            if (!m.getName().equals(saveFileName)) continue;
            i.remove();
            this.pushRecentFiles();
            return;
        }
    }

    public final void updateLanguage() {
        super.updateLanguage();
        this.pushRecentFiles();
    }

    private void readRecentFiles() {
        String[] rf = JaxoPrefs.getRecentFiles();
        for (int i = rf.length - 1; i >= 0; --i) {
            String fileName = rf[i];
            if (fileName.length() <= 0) continue;
            this.doAddRecentFile(fileName);
        }
        this.pushRecentFiles();
    }

    private JMenuItem newRecentFileMenuItem(String fileName) {
        JMenuItem result = new JMenuItem();
        result.setName(fileName);
        result.setToolTipText(fileName);
        result.putClientProperty("Jaxo.text", JaxoIO.shortName(fileName));
        JaxoMenuUtils.setActionCommand(result, 685);
        ActionListener[] l = this.getActionListeners();
        for (int i = 0; i < l.length; ++i) {
            result.addActionListener(l[i]);
        }
        return result;
    }

    private void doAddRecentFile(String saveFileName) {
        Iterator<JMenuItem> i = this.recentFiles.iterator();
        while (i.hasNext()) {
            JMenuItem m = i.next();
            if (!m.getName().equals(saveFileName)) continue;
            i.remove();
            break;
        }
        this.recentFiles.add(0, this.newRecentFileMenuItem(saveFileName));
        if (this.recentFiles.size() > 100) {
            this.recentFiles.subList(100, this.recentFiles.size()).clear();
        }
    }

    private void pushRecentFiles() {
        int index = 0;
        while (this.getMenuComponent(index) instanceof JMenuItem) {
            this.remove(index);
        }
        JaxoPrefs.clearRecentFiles();
        Iterator<JMenuItem> i = this.recentFiles.iterator();
        for (int number = 0; i.hasNext() && number < 10; ++number) {
            JMenuItem m = i.next();
            m.setText(JaxoLanguage.message("OpenRecentMenu.fileNo%0Named%1", number + 1, m.getClientProperty("Jaxo.text")));
            this.insert(m, index);
            JaxoPrefs.addRecentFile(m.getName());
            ++index;
        }
        if (this.getItemCount() == 3) {
            this.getItem(2).setEnabled(true);
        }
    }

    private JMenuItem clearRFMenuItem() {
        JMenuItem clearRFMI = new JMenuItem();
        clearRFMI.setActionCommand("ClearRFMenu");
        JaxoMenuUtils.setLanguageKey(clearRFMI, "OpenRecentMenu.clear");
        clearRFMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ClearRFMenu")) {
                    OpenRecentMenu.this.clearRFMenu();
                }
            }
        });
        return clearRFMI;
    }

    private void clearRFMenu() {
        this.recentFiles.clear();
        this.revalidateMenu();
        this.pushRecentFiles();
    }

    private void revalidateMenu() {
        int entries = this.getItemCount();
        for (int i = entries - 3; i >= 0; --i) {
            this.remove(i);
        }
        this.getItem(1).setEnabled(false);
    }
}

