/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.launch;

import java.awt.EventQueue;
import net.sf.jaxodraw.gui.launch.JaxoShutDown;
import net.sf.jaxodraw.gui.launch.JaxoSplashWindow;
import net.sf.jaxodraw.gui.panel.JaxoMainPanel;
import net.sf.jaxodraw.util.JaxoInfo;

public class JaxoLauncher {
    private String[] fileNames = null;
    private static JaxoShutDown shutdownHook = null;

    public void setFilesToOpen(String[] files) {
        this.fileNames = (String[])files.clone();
    }

    public void setShutDownHook(JaxoShutDown shutdown) {
        shutdownHook = shutdown;
    }

    public void launch(boolean showSplashWindow) {
        if (showSplashWindow) {
            final JaxoSplashWindow sw = new JaxoSplashWindow(JaxoInfo.VERSION + " ");
            sw.start();
            try {
                sw.waitUntilPainted(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JaxoMainPanel main = new JaxoMainPanel(JaxoLauncher.this.fileNames);
                    main.pack();
                    main.setVisible(true);
                    sw.dispose(2000);
                }
            });
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JaxoMainPanel main = new JaxoMainPanel(JaxoLauncher.this.fileNames);
                    main.pack();
                    main.setVisible(true);
                }
            });
        }
    }

    public static void shutdown(int status) {
        if (shutdownHook != null) {
            shutdownHook.shutdown(status);
        }
    }
}

