/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jaxodraw.gui.swing.JaxoTitledBorder;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoLanguage;

public final class JaxoDialogs {
    private JaxoDialogs() {
    }

    public static String translatedWindowTitle(String text) {
        return JaxoLanguage.message("JaxoDraw.windowTitle%0", text);
    }

    public static String windowTitle(String key) {
        return JaxoDialogs.translatedWindowTitle(JaxoLanguage.translate(key));
    }

    public static String windowTitle(String key, Object[] arguments) {
        return JaxoDialogs.translatedWindowTitle(JaxoLanguage.message(key, arguments));
    }

    public static String windowTitle(JaxoDictionary d, String key) {
        return JaxoDialogs.translatedWindowTitle(d.value(key));
    }

    public String windowTitle(JaxoDictionary d, String key, Object[] arguments) {
        return JaxoDialogs.translatedWindowTitle(d.message(key, arguments));
    }

    public static JDialog newDialog(Component aparent, String title, boolean modal) {
        Component parent;
        for (parent = aparent; parent != null && !(parent instanceof Dialog) && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        return parent instanceof Dialog ? new JDialog((Dialog)parent, title, modal) : new JDialog((Frame)parent, title, modal);
    }

    public static void showMiniDialog(Component parent, String title, Object contents, ActionListener l) {
        if (l == null) {
            return;
        }
        Object[] optionButtonNames = new String[]{JaxoLanguage.translate("OK"), JaxoLanguage.translate("Cancel")};
        if (JOptionPane.showOptionDialog(parent, contents, JaxoDialogs.translatedWindowTitle(title), -1, -1, null, optionButtonNames, optionButtonNames[0]) == 0) {
            l.actionPerformed(new ActionEvent(JaxoDialogs.class, 1001, null));
        }
    }

    public static void showErrorDialog(Component parent, String message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 0);
    }

    public static void showErrorDialog(Component parent, String message) {
        JaxoDialogs.showErrorDialog(parent, message, JaxoLanguage.translate("Error"));
    }

    public static void showInfoDialog(Component parent, String message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 1);
    }

    public static void showI18NErrorDialog(Component parent, String messageKey) {
        JaxoDialogs.showErrorDialog(parent, JaxoLanguage.translate(messageKey));
    }

    public static String getNewTabName(Component parent, String oldName) {
        final String[] text = new String[]{""};
        String msg1 = JaxoLanguage.translate("JaxoDialogs.tabName.explanation");
        final JTextField textField = new JTextField(oldName, 20);
        textField.select(0, oldName.length());
        Object[] array = new Object[]{msg1, textField};
        JaxoDialogs.showMiniDialog(parent, JaxoLanguage.translate("JaxoDialogs.tabName.title"), array, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                text[0] = textField.getText();
            }
        });
        return text[0];
    }

    public static String getDescription(Component parent, String old) {
        final String[] result = new String[1];
        String msg1 = JaxoLanguage.translate("JaxoDialogs.graphDescription.explanation1");
        String msg2 = JaxoLanguage.translate("JaxoDialogs.graphDescription.explanation2");
        final JTextField textField = new JTextField(old, 70);
        Object[] array = new Object[]{msg1, msg2, textField};
        JaxoDialogs.showMiniDialog(parent, JaxoLanguage.translate("JaxoDialogs.graphDescription.title"), array, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                result[0] = textField.getText();
            }
        });
        return result[0];
    }

    public static String getText(Component parent) {
        String text = JOptionPane.showInputDialog(parent, JaxoLanguage.translate("JaxoDialogs.text.explanation"), JaxoDialogs.windowTitle("JaxoDialogs.text.title"), -1);
        if (text == null) {
            return "";
        }
        return text;
    }

    public static JPanel newLineBoxLayoutPanel() {
        JPanel result = new JPanel(null, false);
        result.setLayout(new BoxLayout(result, 2));
        return result;
    }

    public static JPanel newPageBoxLayoutPanel() {
        JPanel result = new JPanel(null, false);
        result.setLayout(new BoxLayout(result, 3));
        return result;
    }

    public static JPanel newTitledLineBoxLayoutPanel(String key) {
        JPanel result = new JPanel(null, false);
        result.setLayout(new BoxLayout(result, 2));
        result.setBorder(new JaxoTitledBorder(JaxoLanguage.translate(key)));
        return result;
    }

    public static JPanel newTitledPageBoxLayoutPanel(String key) {
        JPanel result = new JPanel(null, false);
        result.setLayout(new BoxLayout(result, 3));
        result.setBorder(new JaxoTitledBorder(JaxoLanguage.translate(key)));
        return result;
    }

    public static JPanel newTitledFlowLayoutPanel(String key) {
        JPanel result = new JPanel(false);
        result.setBorder(new JaxoTitledBorder(JaxoLanguage.translate(key)));
        return result;
    }

    public static JPanel newTitledBorderLayoutPanel(String key) {
        JPanel result = new JPanel(new BorderLayout(), false);
        result.setBorder(new JaxoTitledBorder(JaxoLanguage.translate(key)));
        return result;
    }

    public static JPanel newTitledLayoutPanel(String key, LayoutManager l) {
        JPanel result = new JPanel(l, false);
        result.setBorder(new JaxoTitledBorder(JaxoLanguage.translate(key)));
        return result;
    }
}

