/*
 * JavaCC.CMD
 * OS/2 and eComStation command file for running JavaCC 3.2
 *
 * Jarda KACER, jkacer@kiv.zcu.cz
 */

/*
 * First locate JavaCC JAR file
 */
JavaCCJar = GetScriptPath() || "\lib\JavaCC.jar"

/*
 * Then grab all arguments and pass them to JavaCC
 */
JavaCCArguments = ARG(1)
"java -classpath " || JavaCCJar || " javacc " || JavaCCArguments

EXIT
/* End of program */




/*
 * Procedures and functions
 */


/*
 * Returns the current script name.
 */
GetScriptName: PROCEDURE
PARSE SOURCE Result
RETURN WORD(Result, 3)


/*
 * Returns the current script path, without "\" at the end.
 */
GetScriptPath: PROCEDURE
Name = GetScriptName()
RETURN SUBSTR(Name, 1, LASTPOS("\", Name)-1)
