/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) @(#) IntegerConverter.java 1.9 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

/**
 * Converts Integers to strings and back again.
 *
 * @version 	1.9, 07/18/96
 */
public class IntegerConverter extends Converter {
  public String convertToString(Object obj) {
    if (obj != null)
      return(((Integer) obj).toString());
    else
      return("0");
  }

  /**
   * Converts a string to a new instance of Integer.
   *
   * @exception ParseException when the string is badly formatted
   */
  public Object convertFromString(String s) {
    Integer retval = null;
    try {
      retval = new Integer(s);
    } catch (NumberFormatException e) {
      throw new ParseException("Badly formatted integer: " + s);
    }
    return(retval);
  }

  public String convertToCode(Object obj) {
    if (obj != null)
      return("new Integer(" + ((Integer) obj).toString() + ")");
    else
      return("new Integer(0)");
  }
}
