/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) AnchorEnum.java 1.5 - last change made 07/18/96
 */

package sunsoft.jws.visual.rt.type;

import sunsoft.jws.visual.rt.awt.GBConstraints;

/**
 * A class that knows all the possible anchor attribute choices.  In an
 * instantiation, can store a single alignment selection.
 *
 * @see GBConstraints
 * @version 	1.5, 07/18/96
 */
public class AnchorEnum extends BaseEnum {
  private static BaseEnumHelper helper = new BaseEnumHelper();

  static {
    helper = new BaseEnumHelper();
    helper.add(GBConstraints.CENTER, "center");
    helper.add(GBConstraints.NORTH, "north");
    helper.add(GBConstraints.SOUTH, "south");
    helper.add(GBConstraints.EAST, "east");
    helper.add(GBConstraints.WEST, "west");
    helper.add(GBConstraints.NORTHWEST, "northwest");
    helper.add(GBConstraints.SOUTHWEST, "southwest");
    helper.add(GBConstraints.NORTHEAST, "northeast");
    helper.add(GBConstraints.SOUTHEAST, "southeast");
    helper.setDefaultChoice(GBConstraints.CENTER);
  }

  /**
   * Constructs an instance with choice set to GBConstraints.CENTER.
   */
  public AnchorEnum() {
    super();
  }

  /**
   * Constructs an instance from an int value.
   *
   * @param choice GBConstraints.CENTER, GBConstraints.NORTH, GBConstraints.SOUTH, GBConstraints.EAST, GBConstraints.WEST, GBConstraints.NORTHWEST, GBConstraints.SOUTHWEST, GBConstraints.NORTHEAST, or GBConstraints.SOUTHEAST
   */
  public AnchorEnum(int choice) {
    super(choice);
  }

  /**
   * Constructs an instance from a string value.
   *
   * @param choice "center", "north", "south", "east", "west", "northwest", "southwest", "northeast", or "southeast"
   */
  public AnchorEnum(String choice) {
    super(choice);
  }

  protected BaseEnumHelper getHelper() {
    return(helper);
  }
}
