/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) PanelShadow.java 1.12 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow.java.awt;

import sunsoft.jws.visual.rt.awt.GBConstraints;
import java.awt.Panel;
import java.awt.FlowLayout;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    none
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see Panel
 * @see sunsoft.jws.visual.rt.shadow.VJPanelShadow
 * @version 	1.12, 07/19/96
 */
public class PanelShadow extends ContainerShadow {
  public PanelShadow() {
    GBConstraints c = (GBConstraints)get("GBConstraints");
    c.fill = GBConstraints.BOTH;
    attributes.add("GBConstraints",
		   "sunsoft.jws.visual.rt.awt.GBConstraints", c);
  }

  public void createBody() {
    Panel panel = new Panel();
    panel.setLayout(new FlowLayout());
    body = panel;
  }

  protected Object getOnBody(String key) {
    return super.getOnBody(key);
  }

  protected void setOnBody(String key, Object value) {
    super.setOnBody(key, value);
  }
}
