/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) VJCanvasShadow.java 1.5 - last change made 07/19/96
 */

package sunsoft.jws.visual.rt.shadow;

import sunsoft.jws.visual.rt.shadow.java.awt.CanvasShadow;
import sunsoft.jws.visual.rt.awt.VJCanvas;

/**
 * Wraps an AWT widget.  The attributes available for this
 * class are listed below.  In the type column, type names beginning
 * with "sunsoft.jws.visual.rt" have been abbreviated to begin with "rt".
 *
 * <pre>
    name            type                      default value
    -----------------------------------------------------------------------
    minHeight       java.lang.Integer         100 
    minWidth        java.lang.Integer         100 
 * </pre>
 *
 * Check the super class for additional attributes.
 *
 * @see VJCanvas
 * @version 	1.5, 07/19/96
 */
public class VJCanvasShadow extends CanvasShadow {

  public VJCanvasShadow() {
    attributes.add("minWidth", "java.lang.Integer", new Integer(100), 0);
    attributes.add("minHeight", "java.lang.Integer", new Integer(100), 0);
  }

  protected Object getOnBody(String key) {
    if (key.equals("minWidth"))
      return(new Integer(((VJCanvas) body).getMinWidth()));
    else if (key.equals("minHeight"))
      return(new Integer(((VJCanvas) body).getMinHeight()));
    else
      return(super.getOnBody(key));
  }

  protected void setOnBody(String key, Object value) {
    VJCanvas canvas = (VJCanvas)body;

    if (key.equals("minWidth")) {
      canvas.setMinWidth(((Integer)value).intValue());
    }
    else if (key.equals("minHeight")) {
      canvas.setMinHeight(((Integer)value).intValue());      
    }
    else {
      super.setOnBody(key, value);
    }
  }

  public void createBody() {
    body = new VJCanvas();
  }
}
