/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) ExternalCallOut.java 1.3 - last change made 04/29/96
 */

package sunsoft.jws.visual.rt.base;

/**
 * An interface for an external call-out classes that know how to do
 * something with a Group object once its been created and initialized
 * in the main.
 *
 * @version 	1.3, 04/29/96
 */
public interface ExternalCallOut {
  /**
   * Set the Group that the main class has loaded and initialized.
   */
  public void initExternal(Group group);

  /**
   * Start the operations of the external class.
   */
  public void startExternal();


  /**
   * Stop the operations of the external class.
   */
  public void stopExternal();
}
