/*
 *        Copyright (C) 1996  Active Software, Inc.
 *                  All rights reserved.
 *
 * @(#) CheckboxList.java 1.3 - last change made 04/25/96
 */

package sunsoft.jws.visual.rt.awt;

import sunsoft.jws.visual.rt.awt.*;
import java.awt.*;
import java.util.Vector;

public class CheckboxList extends ScrollPanel {
  private CheckboxView view;

  public CheckboxList() {
    view = new CheckboxView();
    add(view);

    Vector items = view.items;
    for (int i=0; i<100; i++)
      items.addElement("item" + i);

    view.updateCheckboxes();
  }
}

class CheckboxView extends Panel implements Scrollable {
  Vector items;

  private int curx, cury;
  private GBLayout gridbag;
  private Panel panel;

  public CheckboxView() {
    items = new Vector();

    setLayout(null);
    gridbag = new GBLayout();

    panel = new Panel();
    panel.setLayout(gridbag);

    add(panel);
  }

  public void updateCheckboxes() {
    panel.removeAll();
    GBConstraints c = new GBConstraints();

    c.gridx = 0;
    c.gridy = 0;
    c.fill = GBConstraints.BOTH;

    int size = items.size();
    for (int i=0; i<items.size(); i++) {
      Checkbox box = new Checkbox((String)items.elementAt(i));
      gridbag.setConstraints(panel.add(box), c);

      c.gridx++;
      if (c.gridx == 3) {
	c.gridx = 0;
	c.gridy++;
      }
    }

    if (panel.getPeer() != null) {
      Dimension d = panel.minimumSize();
      panel.reshape(0, 0, d.width, d.height);
    }
  }

  public void addNotify() {
    super.addNotify();
    Dimension d = panel.minimumSize();
    panel.reshape(0, 0, d.width, d.height);
  }

  public Dimension minimumSize() {
    return new Dimension(150, 300);
  }

  public Dimension preferredSize() {
    return minimumSize();
  }

  public void scrollX(int x) {
    curx = -x;
    panel.move(curx, cury);
  }

  public void scrollY(int y) {
    cury = -y;
    panel.move(curx, cury);
  }

  public Dimension scrollSize() {
    return panel.minimumSize();
  }

  public Dimension viewSize() {
    return panel.size();
  }

  public int lineHeight() {
    if (panel.countComponents() == 0)
      return 1;

    Component comp = panel.getComponent(0);
    Dimension min = comp.minimumSize();
    return min.height;
  }
}
