/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.resid_builder.resid;

import de.quippy.sidplay.resid_builder.resid.EnvelopeGenerator;
import de.quippy.sidplay.resid_builder.resid.ExternalFilter;
import de.quippy.sidplay.resid_builder.resid.Filter;
import de.quippy.sidplay.resid_builder.resid.ISIDDefs;
import de.quippy.sidplay.resid_builder.resid.PointPlotter;
import de.quippy.sidplay.resid_builder.resid.Potentiometer;
import de.quippy.sidplay.resid_builder.resid.Voice;
import de.quippy.sidplay.resid_builder.resid.WaveformGenerator;

public class SID {
    public static boolean ANTTI_LANKILA_PATCH = true;
    protected Voice[] voice = new Voice[]{new Voice(), new Voice(), new Voice()};
    public Filter filter = new Filter();
    protected ExternalFilter extfilt = new ExternalFilter();
    protected Potentiometer potx = new Potentiometer();
    protected Potentiometer poty = new Potentiometer();
    protected int bus_value;
    protected int bus_value_ttl;
    protected double clock_frequency;
    protected int ext_in;
    protected static final int FIR_N = 125;
    protected static final int FIR_RES_INTERPOLATE = 285;
    protected static final int FIR_RES_FAST = 51473;
    protected static final int FIR_SHIFT = 15;
    protected static final int RINGSIZE = 16384;
    protected static final int FIXP_SHIFT = 16;
    protected static final int FIXP_MASK = 65535;
    protected ISIDDefs.sampling_method sampling;
    protected int cycles_per_sample;
    protected int sample_offset;
    protected int sample_index;
    protected short sample_prev;
    protected int fir_N;
    protected int fir_RES;
    protected short[] sample = null;
    protected short[] fir = null;

    public SID() {
        this.voice[0].set_sync_source(this.voice[2]);
        this.voice[1].set_sync_source(this.voice[0]);
        this.voice[2].set_sync_source(this.voice[1]);
        this.set_sampling_parameters(985248.0, ISIDDefs.sampling_method.SAMPLE_FAST, 44100.0, -1.0, 0.97);
        this.bus_value = 0;
        this.bus_value_ttl = 0;
        this.ext_in = 0;
    }

    public void set_chip_model(ISIDDefs.chip_model chip_model2) {
        int n = 0;
        while (n < 3) {
            this.voice[n].set_chip_model(chip_model2);
            ++n;
        }
        this.filter.set_chip_model(chip_model2);
        this.extfilt.set_chip_model(chip_model2);
    }

    public void set_distortion_properties(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.filter.set_distortion_properties(n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public void reset() {
        int n = 0;
        while (n < 3) {
            this.voice[n].reset();
            ++n;
        }
        this.filter.reset();
        this.extfilt.reset();
        this.bus_value = 0;
        this.bus_value_ttl = 0;
    }

    public void input(int n) {
        this.ext_in = (n << 4) * 3;
    }

    public int output() {
        int n = this.extfilt.output() / 11;
        if (n >= 32768) {
            return Short.MAX_VALUE;
        }
        if (n < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return n;
    }

    public int output(int n) {
        int n2 = 1 << n;
        int n3 = n2 >> 1;
        int n4 = this.extfilt.output() / (734220 / n2);
        if (n4 >= n3) {
            return n3 - 1;
        }
        if (n4 < -n3) {
            return -n3;
        }
        return n4;
    }

    public int read(int n) {
        switch (n) {
            case 25: {
                return this.potx.readPOT();
            }
            case 26: {
                return this.poty.readPOT();
            }
            case 27: {
                return this.voice[2].wave.readOSC();
            }
            case 28: {
                return this.voice[2].envelope.readENV();
            }
        }
        return this.bus_value;
    }

    public void write(int n, int n2) {
        this.bus_value = n2;
        this.bus_value_ttl = 8192;
        switch (n) {
            case 0: {
                this.voice[0].wave.writeFREQ_LO(n2);
                break;
            }
            case 1: {
                this.voice[0].wave.writeFREQ_HI(n2);
                break;
            }
            case 2: {
                this.voice[0].wave.writePW_LO(n2);
                break;
            }
            case 3: {
                this.voice[0].wave.writePW_HI(n2);
                break;
            }
            case 4: {
                this.voice[0].writeCONTROL_REG(n2);
                break;
            }
            case 5: {
                this.voice[0].envelope.writeATTACK_DECAY(n2);
                break;
            }
            case 6: {
                this.voice[0].envelope.writeSUSTAIN_RELEASE(n2);
                break;
            }
            case 7: {
                this.voice[1].wave.writeFREQ_LO(n2);
                break;
            }
            case 8: {
                this.voice[1].wave.writeFREQ_HI(n2);
                break;
            }
            case 9: {
                this.voice[1].wave.writePW_LO(n2);
                break;
            }
            case 10: {
                this.voice[1].wave.writePW_HI(n2);
                break;
            }
            case 11: {
                this.voice[1].writeCONTROL_REG(n2);
                break;
            }
            case 12: {
                this.voice[1].envelope.writeATTACK_DECAY(n2);
                break;
            }
            case 13: {
                this.voice[1].envelope.writeSUSTAIN_RELEASE(n2);
                break;
            }
            case 14: {
                this.voice[2].wave.writeFREQ_LO(n2);
                break;
            }
            case 15: {
                this.voice[2].wave.writeFREQ_HI(n2);
                break;
            }
            case 16: {
                this.voice[2].wave.writePW_LO(n2);
                break;
            }
            case 17: {
                this.voice[2].wave.writePW_HI(n2);
                break;
            }
            case 18: {
                this.voice[2].writeCONTROL_REG(n2);
                break;
            }
            case 19: {
                this.voice[2].envelope.writeATTACK_DECAY(n2);
                break;
            }
            case 20: {
                this.voice[2].envelope.writeSUSTAIN_RELEASE(n2);
                break;
            }
            case 21: {
                this.filter.writeFC_LO(n2);
                break;
            }
            case 22: {
                this.filter.writeFC_HI(n2);
                break;
            }
            case 23: {
                this.filter.writeRES_FILT(n2);
                break;
            }
            case 24: {
                this.filter.writeMODE_VOL(n2);
                break;
            }
        }
    }

    public void mute(int n, boolean bl) {
        if (n >= 3) {
            return;
        }
        this.voice[n].mute(bl);
    }

    public State read_state() {
        State state = new State();
        int n = 0;
        int n2 = 0;
        while (n < 3) {
            WaveformGenerator waveformGenerator = this.voice[n].wave;
            EnvelopeGenerator envelopeGenerator = this.voice[n].envelope;
            state.sid_register[n2 + 0] = (char)(waveformGenerator.freq & 0xFF);
            state.sid_register[n2 + 1] = (char)(waveformGenerator.freq >> 8);
            state.sid_register[n2 + 2] = (char)(waveformGenerator.pw & 0xFF);
            state.sid_register[n2 + 3] = (char)(waveformGenerator.pw >> 8);
            state.sid_register[n2 + 4] = (char)(waveformGenerator.waveform << 4 | (waveformGenerator.test != 0 ? 8 : 0) | (waveformGenerator.ring_mod != 0 ? 4 : 0) | (waveformGenerator.sync != 0 ? 2 : 0) | (envelopeGenerator.gate != 0 ? 1 : 0));
            state.sid_register[n2 + 5] = (char)(envelopeGenerator.attack << 4 | envelopeGenerator.decay);
            state.sid_register[n2 + 6] = (char)(envelopeGenerator.sustain << 4 | envelopeGenerator.release);
            ++n;
            n2 += 7;
        }
        state.sid_register[n2++] = (char)(this.filter.fc & 7);
        state.sid_register[n2++] = (char)(this.filter.fc >> 3);
        state.sid_register[n2++] = (char)(this.filter.res << 4 | this.filter.filt);
        state.sid_register[n2++] = (char)((this.filter.voice3off != 0 ? 128 : 0) | this.filter.hp_bp_lp << 4 | this.filter.vol);
        while (n2 < 29) {
            state.sid_register[n2] = (char)this.read(n2);
            ++n2;
        }
        while (n2 < 32) {
            state.sid_register[n2] = '\u0000';
            ++n2;
        }
        state.bus_value = this.bus_value;
        state.bus_value_ttl = this.bus_value_ttl;
        n = 0;
        while (n < 3) {
            state.accumulator[n] = this.voice[n].wave.accumulator;
            state.shift_register[n] = this.voice[n].wave.shift_register;
            state.rate_counter[n] = this.voice[n].envelope.rate_counter;
            state.rate_counter_period[n] = this.voice[n].envelope.rate_period;
            state.exponential_counter[n] = this.voice[n].envelope.exponential_counter;
            state.exponential_counter_period[n] = this.voice[n].envelope.exponential_counter_period;
            state.envelope_counter[n] = this.voice[n].envelope.envelope_counter;
            state.envelope_state[n] = this.voice[n].envelope.state;
            state.hold_zero[n] = this.voice[n].envelope.hold_zero;
            ++n;
        }
        return state;
    }

    public void write_state(State state) {
        int n = 0;
        while (n <= 24) {
            this.write(n, state.sid_register[n]);
            ++n;
        }
        this.bus_value = state.bus_value;
        this.bus_value_ttl = state.bus_value_ttl;
        n = 0;
        while (n < 3) {
            this.voice[n].wave.accumulator = state.accumulator[n];
            this.voice[n].wave.shift_register = state.shift_register[n];
            this.voice[n].envelope.rate_counter = state.rate_counter[n];
            this.voice[n].envelope.rate_period = state.rate_counter_period[n];
            this.voice[n].envelope.exponential_counter = state.exponential_counter[n];
            this.voice[n].envelope.exponential_counter_period = state.exponential_counter_period[n];
            this.voice[n].envelope.envelope_counter = state.envelope_counter[n];
            this.voice[n].envelope.state = state.envelope_state[n];
            this.voice[n].envelope.hold_zero = state.hold_zero[n];
            ++n;
        }
    }

    public void enable_filter(boolean bl) {
        this.filter.enable_filter(bl);
    }

    public void enable_external_filter(boolean bl) {
        this.extfilt.enable_filter(bl);
    }

    protected double I0(double d) {
        double d2;
        double d3;
        int n = 1;
        double d4 = d3 = (double)1;
        double d5 = d / 2.0;
        while ((d3 *= (d2 = d5 / (double)n++) * d2) >= 1.0E-6 * (d4 += d3)) {
        }
        return d4;
    }

    public boolean set_sampling_parameters(double d, ISIDDefs.sampling_method sampling_method2, double d2, double d3, double d4) {
        if ((sampling_method2 == ISIDDefs.sampling_method.SAMPLE_RESAMPLE_INTERPOLATE || sampling_method2 == ISIDDefs.sampling_method.SAMPLE_RESAMPLE_FAST) && 125.0 * d / d2 >= 16384.0) {
            return false;
        }
        if (d3 < 0.0) {
            d3 = 20000.0;
            if (2.0 * d3 / d2 >= 0.9) {
                d3 = 0.9 * d2 / 2.0;
            }
        } else if (d3 > 0.9 * d2 / 2.0) {
            return false;
        }
        if (d4 < 0.9 || d4 > 1.0) {
            return false;
        }
        this.extfilt.set_sampling_parameter(d3);
        this.clock_frequency = d;
        this.sampling = sampling_method2;
        this.cycles_per_sample = (int)(d / d2 * 65536.0 + 0.5);
        this.sample_offset = 0;
        this.sample_prev = 0;
        if (sampling_method2 != ISIDDefs.sampling_method.SAMPLE_RESAMPLE_INTERPOLATE && sampling_method2 != ISIDDefs.sampling_method.SAMPLE_RESAMPLE_FAST) {
            this.sample = null;
            this.fir = null;
            return true;
        }
        double d5 = -20.0 * Math.log10(1.52587890625E-5);
        double d6 = (1.0 - 2.0 * d3 / d2) * Math.PI;
        double d7 = (2.0 * d3 / d2 + 1.0) * Math.PI / 2.0;
        double d8 = 0.1102 * (d5 - 8.7);
        double d9 = this.I0(d8);
        int n = (int)((d5 - 7.95) / (2.285 * d6) + 0.5);
        n += n & 1;
        double d10 = d2 / d;
        double d11 = d / d2;
        this.fir_N = (int)((double)n * d11) + 1;
        this.fir_N |= 1;
        int n2 = sampling_method2 == ISIDDefs.sampling_method.SAMPLE_RESAMPLE_INTERPOLATE ? 285 : 51473;
        int n3 = (int)Math.ceil(Math.log((double)n2 / d11) / Math.log(2.0));
        this.fir_RES = 1 << n3;
        this.fir = null;
        this.fir = new short[this.fir_N * this.fir_RES];
        int n4 = 0;
        while (n4 < this.fir_RES) {
            int n5 = n4 * this.fir_N + this.fir_N / 2;
            double d12 = (double)n4 / (double)this.fir_RES;
            int n6 = -this.fir_N / 2;
            while (n6 <= this.fir_N / 2) {
                double d13 = (double)n6 - d12;
                double d14 = d7 * d13 / d11;
                double d15 = d13 / ((double)this.fir_N / 2.0);
                double d16 = Math.abs(d15) <= 1.0 ? this.I0(d8 * Math.sqrt(1.0 - d15 * d15)) / d9 : 0.0;
                double d17 = Math.abs(d14) >= 1.0E-6 ? Math.sin(d14) / d14 : 1.0;
                double d18 = 32768.0 * d4 * d10 * d7 / Math.PI * d17 * d16;
                this.fir[n5 + n6] = (short)(d18 + 0.5);
                ++n6;
            }
            ++n4;
        }
        if (this.sample == null) {
            this.sample = new short[32768];
        }
        n4 = 0;
        while (n4 < 32768) {
            this.sample[n4] = 0;
            ++n4;
        }
        this.sample_index = 0;
        return true;
    }

    public void adjust_sampling_frequency(double d) {
        this.cycles_per_sample = (int)(this.clock_frequency / d * 65536.0 + 0.5);
    }

    public void fc_default(FCPoints fCPoints) {
        this.filter.fc_default(fCPoints);
    }

    public PointPlotter fc_plotter() {
        return this.filter.fc_plotter();
    }

    public void clock() {
        if (--this.bus_value_ttl <= 0) {
            this.bus_value = 0;
            this.bus_value_ttl = 0;
        }
        int n = 0;
        while (n < 3) {
            this.voice[n].envelope.clock();
            ++n;
        }
        n = 0;
        while (n < 3) {
            this.voice[n].wave.clock();
            ++n;
        }
        n = 0;
        while (n < 3) {
            this.voice[n].wave.synchronize();
            ++n;
        }
        this.filter.clock(this.voice[0].output(), this.voice[1].output(), this.voice[2].output(), this.ext_in);
        this.extfilt.clock(this.filter.output());
    }

    public void clock(int n) {
        if (n <= 0) {
            return;
        }
        this.bus_value_ttl -= n;
        if (this.bus_value_ttl <= 0) {
            this.bus_value = 0;
            this.bus_value_ttl = 0;
        }
        int n2 = 0;
        while (n2 < 3) {
            this.voice[n2].envelope.clock(n);
            ++n2;
        }
        int n3 = n;
        while (n3 != 0) {
            int n4 = n3;
            n2 = 0;
            while (n2 < 3) {
                WaveformGenerator waveformGenerator = this.voice[n2].wave;
                if (waveformGenerator.sync_dest.sync != 0 && waveformGenerator.freq != 0) {
                    int n5 = waveformGenerator.freq;
                    int n6 = waveformGenerator.accumulator;
                    int n7 = ((n6 & 0x800000) != 0 ? 0x1000000 : 0x800000) - n6;
                    int n8 = n7 / n5;
                    if (n7 % n5 != 0) {
                        ++n8;
                    }
                    if (n8 < n4) {
                        n4 = n8;
                    }
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < 3) {
                this.voice[n2].wave.clock(n4);
                ++n2;
            }
            n2 = 0;
            while (n2 < 3) {
                this.voice[n2].wave.synchronize();
                ++n2;
            }
            n3 -= n4;
        }
        this.filter.clock(n, this.voice[0].output(), this.voice[1].output(), this.voice[2].output(), this.ext_in);
        this.extfilt.clock(n, this.filter.output());
    }

    public int clock(CycleCount cycleCount, short[] sArray, int n, int n2) {
        switch (this.sampling) {
            default: {
                return this.clock_fast(cycleCount, sArray, n, n2);
            }
            case SAMPLE_INTERPOLATE: {
                return this.clock_interpolate(cycleCount, sArray, n, n2);
            }
            case SAMPLE_RESAMPLE_INTERPOLATE: {
                return this.clock_resample_interpolate(cycleCount, sArray, n, n2);
            }
            case SAMPLE_RESAMPLE_FAST: 
        }
        return this.clock_resample_fast(cycleCount, sArray, n, n2);
    }

    protected int clock_fast(CycleCount cycleCount, short[] sArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        while ((n4 = (n3 = this.sample_offset + this.cycles_per_sample + 32768) >> 16) <= cycleCount.delta_t) {
            if (n5 >= n) {
                return n5;
            }
            this.clock(n4);
            cycleCount.delta_t -= n4;
            this.sample_offset = (n3 & 0xFFFF) - 32768;
            sArray[n5++ * n2] = (short)this.output();
        }
        this.clock(cycleCount.delta_t);
        this.sample_offset -= cycleCount.delta_t << 16;
        cycleCount.delta_t = 0;
        return n5;
    }

    protected int clock_interpolate(CycleCount cycleCount, short[] sArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        while ((n5 = (n4 = this.sample_offset + this.cycles_per_sample) >> 16) <= cycleCount.delta_t) {
            if (n6 >= n) {
                return n6;
            }
            n3 = 0;
            while (n3 < n5 - 1) {
                this.clock();
                ++n3;
            }
            if (n3 < n5) {
                this.sample_prev = (short)this.output();
                this.clock();
            }
            cycleCount.delta_t -= n5;
            this.sample_offset = n4 & 0xFFFF;
            short s = (short)this.output();
            sArray[n6++ * n2] = (short)(this.sample_prev + (this.sample_offset * (s - this.sample_prev) >> 16));
            this.sample_prev = s;
        }
        n3 = 0;
        while (n3 < cycleCount.delta_t - 1) {
            this.clock();
            ++n3;
        }
        if (n3 < cycleCount.delta_t) {
            this.sample_prev = (short)this.output();
            this.clock();
        }
        this.sample_offset -= cycleCount.delta_t << 16;
        cycleCount.delta_t = 0;
        return n6;
    }

    protected int clock_resample_interpolate(CycleCount cycleCount, short[] sArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        while ((n4 = (n3 = this.sample_offset + this.cycles_per_sample) >> 16) <= cycleCount.delta_t) {
            if (n5 >= n) {
                return n5;
            }
            int n6 = 0;
            while (n6 < n4) {
                this.clock();
                short s = (short)this.output();
                this.sample[this.sample_index + 16384] = s;
                this.sample[this.sample_index] = s;
                ++this.sample_index;
                this.sample_index &= 0x3FFF;
                ++n6;
            }
            cycleCount.delta_t -= n4;
            this.sample_offset = n3 & 0xFFFF;
            n6 = this.sample_offset * this.fir_RES >> 16;
            int n7 = this.sample_offset * this.fir_RES & 0xFFFF;
            int n8 = n6 * this.fir_N;
            int n9 = this.sample_index - this.fir_N + 16384;
            int n10 = 0;
            int n11 = 0;
            while (n11 < this.fir_N) {
                n10 += this.sample[n9 + n11] * this.fir[n8 + n11];
                ++n11;
            }
            if (++n6 == this.fir_RES) {
                n6 = 0;
                --n9;
            }
            n8 = n6 * this.fir_N;
            n11 = 0;
            int n12 = 0;
            while (n12 < this.fir_N) {
                n11 += this.sample[n9 + n12] * this.fir[n8 + n12];
                ++n12;
            }
            n12 = n10 + (n7 * (n11 - n10) >> 16);
            if ((n12 >>= 15) >= 32768) {
                n12 = Short.MAX_VALUE;
            } else if (n12 < Short.MIN_VALUE) {
                n12 = Short.MIN_VALUE;
            }
            sArray[n5++ * n2] = (short)n12;
        }
        n3 = 0;
        while (n3 < cycleCount.delta_t) {
            this.clock();
            short s = (short)this.output();
            this.sample[this.sample_index + 16384] = s;
            this.sample[this.sample_index] = s;
            ++this.sample_index;
            this.sample_index &= 0x3FFF;
            ++n3;
        }
        this.sample_offset -= cycleCount.delta_t << 16;
        cycleCount.delta_t = 0;
        return n5;
    }

    protected int clock_resample_fast(CycleCount cycleCount, short[] sArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        while ((n4 = (n3 = this.sample_offset + this.cycles_per_sample) >> 16) <= cycleCount.delta_t) {
            if (n5 >= n) {
                return n5;
            }
            int n6 = 0;
            while (n6 < n4) {
                this.clock();
                short s = (short)this.output();
                this.sample[this.sample_index + 16384] = s;
                this.sample[this.sample_index] = s;
                ++this.sample_index;
                this.sample_index &= 0x3FFF;
                ++n6;
            }
            cycleCount.delta_t -= n4;
            this.sample_offset = n3 & 0xFFFF;
            n6 = this.sample_offset * this.fir_RES >> 16;
            int n7 = n6 * this.fir_N;
            int n8 = this.sample_index - this.fir_N + 16384;
            int n9 = 0;
            int n10 = 0;
            while (n10 < this.fir_N) {
                n9 += this.sample[n8 + n10] * this.fir[n7 + n10];
                ++n10;
            }
            if ((n9 >>= 15) >= 32768) {
                n9 = Short.MAX_VALUE;
            } else if (n9 < Short.MIN_VALUE) {
                n9 = Short.MIN_VALUE;
            }
            sArray[n5++ * n2] = (short)n9;
        }
        n3 = 0;
        while (n3 < cycleCount.delta_t) {
            this.clock();
            short s = (short)this.output();
            this.sample[this.sample_index + 16384] = s;
            this.sample[this.sample_index] = s;
            ++this.sample_index;
            this.sample_index &= 0x3FFF;
            ++n3;
        }
        this.sample_offset -= cycleCount.delta_t << 16;
        cycleCount.delta_t = 0;
        return n5;
    }

    public static class CycleCount {
        public int delta_t;

        public CycleCount(int n) {
            this.delta_t = n;
        }
    }

    public static class FCPoints {
        public int[][] points;
        public int count;
    }

    public static class State {
        public char[] sid_register = new char[32];
        public int bus_value;
        public int bus_value_ttl;
        public int[] accumulator = new int[3];
        public int[] shift_register = new int[3];
        public int[] rate_counter = new int[3];
        public int[] rate_counter_period = new int[3];
        public int[] exponential_counter = new int[3];
        public int[] exponential_counter_period = new int[3];
        int[] envelope_counter = new int[3];
        public EnvelopeGenerator.State[] envelope_state = new EnvelopeGenerator.State[3];
        public boolean[] hold_zero = new boolean[3];

        public State() {
            int n = 0;
            while (n < 32) {
                this.sid_register[n] = '\u0000';
                ++n;
            }
            this.bus_value = 0;
            this.bus_value_ttl = 0;
            n = 0;
            while (n < 3) {
                this.accumulator[n] = 0;
                this.shift_register[n] = 0x7FFFF8;
                this.rate_counter[n] = 0;
                this.rate_counter_period[n] = 9;
                this.exponential_counter[n] = 0;
                this.exponential_counter_period[n] = 1;
                this.envelope_counter[n] = 0;
                this.envelope_state[n] = EnvelopeGenerator.State.RELEASE;
                this.hold_zero[n] = true;
                ++n;
            }
        }
    }
}

