/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.sidplay.libsidplay.components.sidtune;

import de.quippy.sidplay.libsidplay.common.SIDEndian;
import de.quippy.sidplay.libsidplay.components.sidtune.Buffer_sidtt;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTune;
import de.quippy.sidplay.libsidplay.components.sidtune.SidTuneInfo;
import java.io.IOException;
import java.io.OutputStream;

public class PSid {
    public static final int PSID_ID = 1347635524;
    public static final int RSID_ID = 1381189956;
    public static final int PSID_MUS = 1;
    public static final int PSID_SPECIFIC = 2;
    public static final int PSID_BASIC = 2;
    public static final int PSID_CLOCK = 12;
    public static final int PSID_SIDMODEL = 48;
    public static final int PSID_CLOCK_UNKNOWN = 0;
    public static final int PSID_CLOCK_PAL = 4;
    public static final int PSID_CLOCK_NTSC = 8;
    public static final int PSID_CLOCK_ANY = 12;
    public static final int PSID_SIDMODEL_UNKNOWN = 0;
    public static final int PSID_SIDMODEL_6581 = 16;
    public static final int PSID_SIDMODEL_8580 = 32;
    public static final int PSID_SIDMODEL_ANY = 48;
    static final String _sidtune_format_psid = "PlaySID one-file format (PSID)";
    static final String _sidtune_format_rsid = "Real C64 one-file format (RSID)";
    static final String _sidtune_unknown_psid = "Unsupported PSID version";
    static final String _sidtune_unknown_rsid = "Unsupported RSID version";
    static final String _sidtune_truncated = "ERROR: File is most likely truncated";
    static final String _sidtune_invalid = "ERROR: File contains invalid data";
    static final int _sidtune_psid_maxStrLen = 31;
    private SidTune sidtune;
    private SidTuneInfo info;

    public PSid(SidTune sidTune) {
        this.sidtune = sidTune;
        this.info = sidTune.info;
    }

    protected final SidTune.LoadStatus PSID_fileSupport(Buffer_sidtt buffer_sidtt) {
        int n;
        int n2 = buffer_sidtt.len();
        int n3 = 0;
        int n4 = 0;
        PHeader pHeader = new PHeader(buffer_sidtt.get(), 0);
        if (n2 < 6) {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        if (SIDEndian.endian_big32(pHeader.id, 0) == 1347635524L) {
            switch (SIDEndian.endian_big16(pHeader.version, 0)) {
                case 1: {
                    n4 = 1;
                }
                case 2: {
                    break;
                }
                default: {
                    this.info.formatString = _sidtune_unknown_psid;
                    return SidTune.LoadStatus.LOAD_ERROR;
                }
            }
            this.info.formatString = _sidtune_format_psid;
        } else if (SIDEndian.endian_big32(pHeader.id, 0) == 1381189956L) {
            if (SIDEndian.endian_big16(pHeader.version, 0) != 2) {
                this.info.formatString = _sidtune_unknown_rsid;
                return SidTune.LoadStatus.LOAD_ERROR;
            }
            this.info.formatString = _sidtune_format_rsid;
            n4 = 2;
        } else {
            return SidTune.LoadStatus.LOAD_NOT_MINE;
        }
        if (n2 < 126) {
            this.info.formatString = _sidtune_truncated;
            return SidTune.LoadStatus.LOAD_ERROR;
        }
        this.sidtune.fileOffset = SIDEndian.endian_big16(pHeader.data, 0);
        this.info.loadAddr = SIDEndian.endian_big16(pHeader.load, 0);
        this.info.initAddr = SIDEndian.endian_big16(pHeader.init, 0);
        this.info.playAddr = SIDEndian.endian_big16(pHeader.play, 0);
        this.info.songs = SIDEndian.endian_big16(pHeader.songs, 0);
        this.info.startSong = SIDEndian.endian_big16(pHeader.start, 0);
        this.info.sidChipBase1 = 54272;
        this.info.sidChipBase2 = 0;
        this.info.compatibility = n4;
        long l = SIDEndian.endian_big32(pHeader.speed, 0);
        if (this.info.songs > 256) {
            this.info.songs = 256;
        }
        this.info.musPlayer = false;
        this.info.sidModel = 0;
        this.info.relocPages = 0;
        this.info.relocStartPage = 0;
        if (SIDEndian.endian_big16(pHeader.version, 0) >= 2) {
            n = SIDEndian.endian_big16(pHeader.flags, 0);
            if ((n & 1) != 0) {
                n3 = 3;
                this.info.musPlayer = true;
            }
            switch (n4) {
                case 0: {
                    if ((n & 2) == 0) break;
                    this.info.compatibility = 1;
                    break;
                }
                case 2: {
                    if ((n & 2) == 0) break;
                    this.info.compatibility = 3;
                }
            }
            if ((n & 4) != 0) {
                n3 = (short)(n3 | 1);
            }
            if ((n & 8) != 0) {
                n3 = (short)(n3 | 2);
            }
            this.info.clockSpeed = (short)n3;
            this.info.sidModel = 0;
            if ((n & 0x10) != 0) {
                this.info.sidModel |= 1;
            }
            if ((n & 0x20) != 0) {
                this.info.sidModel |= 2;
            }
            this.info.relocStartPage = pHeader.relocStartPage;
            this.info.relocPages = pHeader.relocPages;
        }
        if (n4 == 2) {
            if (this.info.loadAddr != 0 || this.info.playAddr != 0 || l != 0L) {
                this.info.formatString = _sidtune_invalid;
                return SidTune.LoadStatus.LOAD_ERROR;
            }
            l = -1L;
        }
        this.sidtune.convertOldStyleSpeedToTables(l, (short)n3);
        this.info.numberOfInfoStrings = (short)3;
        n = 0;
        while (n < pHeader.name.length) {
            if (pHeader.name[n] == '\u0000') break;
            ++n;
        }
        this.info.infoString[0] = this.sidtune.infoString[0] = new String(pHeader.name, 0, Math.min(n, 31));
        n = 0;
        while (n < pHeader.author.length) {
            if (pHeader.author[n] == '\u0000') break;
            ++n;
        }
        this.info.infoString[1] = this.sidtune.infoString[1] = new String(pHeader.author, 0, Math.min(n, 31));
        n = 0;
        while (n < pHeader.released.length) {
            if (pHeader.released[n] == '\u0000') break;
            ++n;
        }
        this.info.infoString[2] = this.sidtune.infoString[2] = new String(pHeader.released, 0, Math.min(n, 31));
        if (this.info.musPlayer) {
            return this.sidtune.MUS_load(buffer_sidtt, false);
        }
        return SidTune.LoadStatus.LOAD_OK;
    }

    protected boolean PSID_fileSupportSave(OutputStream outputStream, short[] sArray) {
        try {
            PHeader pHeader = new PHeader();
            SIDEndian.endian_big32(pHeader.id, 0, 1347635524L);
            SIDEndian.endian_big16(pHeader.version, 0, 2);
            SIDEndian.endian_big16(pHeader.data, 0, 124);
            SIDEndian.endian_big16(pHeader.songs, 0, this.info.songs);
            SIDEndian.endian_big16(pHeader.start, 0, this.info.startSong);
            int n = 0;
            int n2 = 0;
            int n3 = this.info.songs <= 32 ? this.info.songs : 32;
            int n4 = 0;
            while (n4 < n3) {
                if (this.sidtune.songSpeed[n4] == 60) {
                    n = (short)(n | 1 << n4);
                }
                n2 = (short)(n2 | 1 << n4);
                ++n4;
            }
            SIDEndian.endian_big32(pHeader.speed, 0, n);
            n4 = 0;
            if (this.info.musPlayer) {
                SIDEndian.endian_big16(pHeader.load, 0, 0);
                SIDEndian.endian_big16(pHeader.init, 0, 0);
                SIDEndian.endian_big16(pHeader.play, 0, 0);
                pHeader.relocStartPage = 0;
                pHeader.relocPages = 0;
                n4 |= 1;
            } else {
                SIDEndian.endian_big16(pHeader.load, 0, 0);
                SIDEndian.endian_big16(pHeader.init, 0, this.info.initAddr);
                pHeader.relocStartPage = this.info.relocStartPage;
                pHeader.relocPages = this.info.relocPages;
                switch (this.info.compatibility) {
                    case 3: {
                        n4 |= 2;
                    }
                    case 2: {
                        SIDEndian.endian_big32(pHeader.id, 0, 1381189956L);
                        SIDEndian.endian_big16(pHeader.play, 0, 0);
                        SIDEndian.endian_big32(pHeader.speed, 0, 0L);
                        break;
                    }
                    case 1: {
                        n4 |= 2;
                    }
                    default: {
                        SIDEndian.endian_big16(pHeader.play, 0, this.info.playAddr);
                    }
                }
            }
            int n5 = 0;
            while (n5 < 32) {
                pHeader.name[n5] = '\u0000';
                pHeader.author[n5] = '\u0000';
                pHeader.released[n5] = '\u0000';
                ++n5;
            }
            if (this.info.numberOfInfoStrings == 3) {
                System.arraycopy(this.info.infoString[0], 0, pHeader.name, 0, Math.min(this.info.infoString[0].length(), 31));
                System.arraycopy(this.info.infoString[1], 0, pHeader.author, 0, Math.min(this.info.infoString[1].length(), 31));
                System.arraycopy(this.info.infoString[2], 0, pHeader.released, 0, Math.min(this.info.infoString[2].length(), 31));
            }
            n4 |= this.info.clockSpeed << 2;
            SIDEndian.endian_big16(pHeader.flags, 0, n4 |= this.info.sidModel << 4);
            SIDEndian.endian_big16(pHeader.reserved, 0, 0);
            this.write(outputStream, pHeader.getArray(), 0, 124);
            if (this.info.musPlayer) {
                this.write(outputStream, sArray, 0, this.info.dataFileLen);
            } else {
                short[] sArray2 = new short[]{(short)(this.info.loadAddr & 0xFF), (short)(this.info.loadAddr >> 8)};
                this.write(outputStream, sArray2, 0, 2);
                this.write(outputStream, sArray, this.sidtune.fileOffset, this.info.dataFileLen - this.sidtune.fileOffset);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private void write(OutputStream outputStream, short[] sArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n2) {
            outputStream.write(sArray[n3]);
            ++n3;
        }
    }

    public static class PHeader {
        public static final int SIZE = 124;
        public short[] id = new short[4];
        public short[] version = new short[2];
        public short[] data = new short[2];
        public short[] load = new short[2];
        public short[] init = new short[2];
        public short[] play = new short[2];
        public short[] songs = new short[2];
        public short[] start = new short[2];
        public short[] speed = new short[4];
        public char[] name = new char[32];
        public char[] author = new char[32];
        public char[] released = new char[32];
        public short[] flags = new short[2];
        public short relocStartPage;
        public short relocPages;
        public short[] reserved = new short[2];

        public PHeader(short[] sArray, int n) {
            int n2 = 0;
            while (n2 < 4) {
                this.id[n2] = sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 2) {
                this.version[n2] = sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 2) {
                this.data[n2] = sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 2) {
                this.load[n2] = sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 2) {
                this.init[n2] = sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 2) {
                this.play[n2] = sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 2) {
                this.songs[n2] = sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 2) {
                this.start[n2] = sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 4) {
                this.speed[n2] = sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 32) {
                this.name[n2] = (char)sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 32) {
                this.author[n2] = (char)sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 32) {
                this.released[n2] = (char)sArray[n++];
                ++n2;
            }
            n2 = 0;
            while (n2 < 2) {
                this.flags[n2] = sArray[n++];
                ++n2;
            }
            this.relocStartPage = sArray[n++];
            this.relocPages = sArray[n++];
            n2 = 0;
            while (n2 < 2) {
                this.reserved[n2] = sArray[n++];
                ++n2;
            }
        }

        public PHeader() {
        }

        public short[] getArray() {
            return new short[]{this.id[0], this.id[1], this.id[2], this.id[3], this.version[0], this.version[1], this.data[0], this.data[1], this.load[0], this.load[1], this.init[0], this.init[1], this.play[0], this.play[1], this.songs[0], this.songs[1], this.start[0], this.start[1], this.speed[0], this.speed[1], this.speed[2], this.speed[3], (short)this.name[0], (short)this.name[1], (short)this.name[2], (short)this.name[3], (short)this.name[4], (short)this.name[5], (short)this.name[6], (short)this.name[7], (short)this.name[8], (short)this.name[9], (short)this.name[10], (short)this.name[11], (short)this.name[12], (short)this.name[13], (short)this.name[14], (short)this.name[13], (short)this.name[16], (short)this.name[17], (short)this.name[18], (short)this.name[19], (short)this.name[20], (short)this.name[21], (short)this.name[22], (short)this.name[23], (short)this.name[24], (short)this.name[25], (short)this.name[26], (short)this.name[27], (short)this.name[28], (short)this.name[29], (short)this.name[30], (short)this.name[31], (short)this.author[0], (short)this.author[1], (short)this.author[2], (short)this.author[3], (short)this.author[4], (short)this.author[5], (short)this.author[6], (short)this.author[7], (short)this.author[8], (short)this.author[9], (short)this.author[10], (short)this.author[11], (short)this.author[12], (short)this.author[13], (short)this.author[14], (short)this.author[13], (short)this.author[16], (short)this.author[17], (short)this.author[18], (short)this.author[19], (short)this.author[20], (short)this.author[21], (short)this.author[22], (short)this.author[23], (short)this.author[24], (short)this.author[25], (short)this.author[26], (short)this.author[27], (short)this.author[28], (short)this.author[29], (short)this.author[30], (short)this.author[31], (short)this.released[0], (short)this.released[1], (short)this.released[2], (short)this.released[3], (short)this.released[4], (short)this.released[5], (short)this.released[6], (short)this.released[7], (short)this.released[8], (short)this.released[9], (short)this.released[10], (short)this.released[11], (short)this.released[12], (short)this.released[13], (short)this.released[14], (short)this.released[13], (short)this.released[16], (short)this.released[17], (short)this.released[18], (short)this.released[19], (short)this.released[20], (short)this.released[21], (short)this.released[22], (short)this.released[23], (short)this.released[24], (short)this.released[25], (short)this.released[26], (short)this.released[27], (short)this.released[28], (short)this.released[29], (short)this.released[30], (short)this.released[31], this.flags[0], this.flags[1], this.relocStartPage, this.relocPages, this.reserved[0], this.reserved[1]};
        }
    }
}

