/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.tools.ByteArrayWriter;
import de.quippy.jmac.tools.JMACException;
import java.io.UnsupportedEncodingException;

public class APETagField {
    public static final int TAG_FIELD_FLAG_READ_ONLY = 1;
    public static final int TAG_FIELD_FLAG_DATA_TYPE_MASK = 6;
    public static final int TAG_FIELD_FLAG_DATA_TYPE_TEXT_UTF8 = 0;
    public static final int TAG_FIELD_FLAG_DATA_TYPE_BINARY = 2;
    public static final int TAG_FIELD_FLAG_DATA_TYPE_EXTERNAL_INFO = 4;
    public static final int TAG_FIELD_FLAG_DATA_TYPE_RESERVED = 6;
    private String m_spFieldName;
    private byte[] m_spFieldValue;
    private int m_nFieldFlags;

    public APETagField(String string, byte[] byArray) {
        this(string, byArray, 0);
    }

    public APETagField(String string, byte[] byArray, int n) {
        this.m_spFieldName = string;
        this.m_spFieldValue = byArray;
        this.m_nFieldFlags = n;
        this.m_spFieldValue = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.m_spFieldValue, 0, byArray.length);
        this.m_nFieldFlags = n;
    }

    public int GetFieldSize() {
        try {
            return this.m_spFieldName.getBytes("US-ASCII").length + 1 + this.m_spFieldValue.length + 4 + 4;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JMACException("Unsupported Encoding", unsupportedEncodingException);
        }
    }

    public String GetFieldName() {
        return this.m_spFieldName;
    }

    public byte[] GetFieldValue() {
        return this.m_spFieldValue;
    }

    public int GetFieldValueSize() {
        return this.m_spFieldValue.length;
    }

    public int GetFieldFlags() {
        return this.m_nFieldFlags;
    }

    public int SaveField(ByteArrayWriter byteArrayWriter) {
        byteArrayWriter.writeInt(this.m_spFieldValue.length);
        byteArrayWriter.writeInt(this.m_nFieldFlags);
        byteArrayWriter.writeZString(this.m_spFieldName, "US-ASCII");
        byteArrayWriter.writeBytes(this.m_spFieldValue);
        return this.GetFieldSize();
    }

    public boolean GetIsReadOnly() {
        return (this.m_nFieldFlags & 1) > 0;
    }

    public boolean GetIsUTF8Text() {
        return (this.m_nFieldFlags & 6) == 0;
    }

    void SetFieldFlags(int n) {
        this.m_nFieldFlags = n;
    }
}

