/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.info.APEFileInfo;
import de.quippy.jmac.info.APEHeader;
import de.quippy.jmac.info.APETag;
import de.quippy.jmac.info.WaveFormat;
import de.quippy.jmac.info.WaveHeader;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.InputStreamFile;
import de.quippy.jmac.tools.JMACException;
import de.quippy.jmac.tools.RandomAccessFile;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class APEInfo {
    private boolean m_bHasFileInformationLoaded;
    private File m_spIO;
    private APETag m_spAPETag;
    private APEFileInfo m_APEFileInfo = new APEFileInfo();

    public APEInfo(URL uRL) throws IOException {
        this(uRL, null);
    }

    public APEInfo(URL uRL, APETag aPETag) throws IOException {
        this(uRL.openStream(), aPETag);
    }

    public APEInfo(java.io.File file) throws IOException {
        this(file, null);
    }

    public APEInfo(java.io.File file, APETag aPETag) throws IOException {
        this(new RandomAccessFile(file, "r"), aPETag);
    }

    public APEInfo(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public APEInfo(InputStream inputStream, APETag aPETag) throws IOException {
        this(new InputStreamFile(inputStream), aPETag);
    }

    public APEInfo(File file) throws IOException {
        this(file, null);
    }

    public APEInfo(File file, APETag aPETag) throws IOException {
        this.m_spIO = file;
        this.GetFileInformation();
        this.m_spAPETag = aPETag == null ? new APETag(this.m_spIO, file.isLocal()) : aPETag;
    }

    public void close() throws IOException {
        this.m_APEFileInfo.spWaveHeaderData = null;
        this.m_APEFileInfo.spSeekBitTable = null;
        this.m_APEFileInfo.spSeekByteTable = null;
        this.m_APEFileInfo.spAPEDescriptor = null;
        this.m_spAPETag = null;
        this.m_APEFileInfo.nSeekTableElements = 0;
        this.m_bHasFileInformationLoaded = false;
    }

    public int getApeInfoFileVersion() {
        return this.m_APEFileInfo.nVersion;
    }

    public int getApeInfoCompressionLevel() {
        return this.m_APEFileInfo.nCompressionLevel;
    }

    public int getApeInfoFormatFlags() {
        return this.m_APEFileInfo.nFormatFlags;
    }

    public int getApeInfoSampleRate() {
        return this.m_APEFileInfo.nSampleRate;
    }

    public int getApeInfoBitsPerSample() {
        return this.m_APEFileInfo.nBitsPerSample;
    }

    public int getApeInfoBytesPerSample() {
        return this.m_APEFileInfo.nBytesPerSample;
    }

    public int getApeInfoChannels() {
        return this.m_APEFileInfo.nChannels;
    }

    public int getApeInfoBlockAlign() {
        return this.m_APEFileInfo.nBlockAlign;
    }

    public int getApeInfoBlocksPerFrame() {
        return this.m_APEFileInfo.nBlocksPerFrame;
    }

    public int getApeInfoFinalFrameBlocks() {
        return this.m_APEFileInfo.nFinalFrameBlocks;
    }

    public int getApeInfoTotalFrames() {
        return this.m_APEFileInfo.nTotalFrames;
    }

    public int getApeInfoWavHeaderBytes() {
        return this.m_APEFileInfo.nWAVHeaderBytes;
    }

    public int getApeInfoWavTerminatingBytes() {
        return this.m_APEFileInfo.nWAVTerminatingBytes;
    }

    public int getApeInfoWavDataBytes() {
        return this.m_APEFileInfo.nWAVDataBytes;
    }

    public int getApeInfoWavTotalBytes() {
        return this.m_APEFileInfo.nWAVTotalBytes;
    }

    public int getApeInfoApeTotalBytes() {
        return this.m_APEFileInfo.nAPETotalBytes;
    }

    public int getApeInfoTotalBlocks() {
        return this.m_APEFileInfo.nTotalBlocks;
    }

    public int getApeInfoLengthMs() {
        return this.m_APEFileInfo.nLengthMS;
    }

    public int getApeInfoAverageBitrate() {
        return this.m_APEFileInfo.nAverageBitrate;
    }

    public int getApeInfoSeekByte(int n) {
        return n < 0 || n >= this.m_APEFileInfo.nTotalFrames ? 0 : this.m_APEFileInfo.spSeekByteTable[n] + this.m_APEFileInfo.nJunkHeaderBytes;
    }

    public int getApeInfoFrameBytes(int n) throws IOException {
        if (n < 0 || n >= this.m_APEFileInfo.nTotalFrames) {
            return -1;
        }
        if (n != this.m_APEFileInfo.nTotalFrames - 1) {
            return this.getApeInfoSeekByte(n + 1) - this.getApeInfoSeekByte(n);
        }
        if (this.m_spIO.isLocal()) {
            return (int)this.m_spIO.length() - this.m_spAPETag.GetTagBytes() - this.m_APEFileInfo.nWAVTerminatingBytes - this.getApeInfoSeekByte(n);
        }
        if (n > 0) {
            return this.getApeInfoSeekByte(n) - this.getApeInfoSeekByte(n - 1);
        }
        return -1;
    }

    public int getApeInfoFrameBlocks(int n) {
        if (n < 0 || n >= this.m_APEFileInfo.nTotalFrames) {
            return -1;
        }
        if (n != this.m_APEFileInfo.nTotalFrames - 1) {
            return this.m_APEFileInfo.nBlocksPerFrame;
        }
        return this.m_APEFileInfo.nFinalFrameBlocks;
    }

    public int getApeInfoFrameBitrate(int n) throws IOException {
        int n2;
        int n3 = this.getApeInfoFrameBytes(n);
        int n4 = this.getApeInfoFrameBlocks(n);
        if (n3 > 0 && n4 > 0 && this.m_APEFileInfo.nSampleRate > 0 && (n2 = n4 * 1000 / this.m_APEFileInfo.nSampleRate) != 0) {
            return n3 * 8 / n2;
        }
        return this.m_APEFileInfo.nAverageBitrate;
    }

    public int getApeInfoDecompressedBitrate() {
        return this.m_APEFileInfo.nDecompressedBitrate;
    }

    public int getApeInfoPeakLevel() {
        return this.m_APEFileInfo.nPeakLevel;
    }

    public int getApeInfoSeekBit(int n) {
        if (this.getApeInfoFileVersion() > 3800) {
            return 0;
        }
        if (n < 0 || n >= this.m_APEFileInfo.nTotalFrames) {
            return 0;
        }
        return this.m_APEFileInfo.spSeekBitTable[n];
    }

    public WaveFormat getApeInfoWaveFormatEx() {
        WaveFormat waveFormat = new WaveFormat();
        WaveFormat.FillWaveFormatEx(waveFormat, this.m_APEFileInfo.nSampleRate, this.m_APEFileInfo.nBitsPerSample, this.m_APEFileInfo.nChannels);
        return waveFormat;
    }

    public byte[] getApeInfoWavHeaderData(int n) {
        if ((this.m_APEFileInfo.nFormatFlags & 0x20) > 0) {
            if (44 > n) {
                return null;
            }
            WaveFormat waveFormat = this.getApeInfoWaveFormatEx();
            WaveHeader waveHeader = new WaveHeader();
            WaveHeader.FillWaveHeader(waveHeader, this.m_APEFileInfo.nWAVDataBytes, waveFormat, this.m_APEFileInfo.nWAVTerminatingBytes);
            return waveHeader.write();
        }
        if (this.m_APEFileInfo.nWAVHeaderBytes > n) {
            return null;
        }
        byte[] byArray = new byte[this.m_APEFileInfo.nWAVHeaderBytes];
        System.arraycopy(this.m_APEFileInfo.spWaveHeaderData, 0, byArray, 0, this.m_APEFileInfo.nWAVHeaderBytes);
        return byArray;
    }

    public File getApeInfoIoSource() {
        return this.m_spIO;
    }

    public APETag getApeInfoTag() {
        return this.m_spAPETag;
    }

    public byte[] getApeInfoWavTerminatingData(int n) throws IOException {
        if (this.m_APEFileInfo.nWAVTerminatingBytes > n) {
            return null;
        }
        if (this.m_APEFileInfo.nWAVTerminatingBytes > 0) {
            long l = this.m_spIO.getFilePointer();
            this.m_spIO.seek(this.m_spIO.length() - (long)(this.m_spAPETag.GetTagBytes() + this.m_APEFileInfo.nWAVTerminatingBytes));
            byte[] byArray = new byte[this.m_APEFileInfo.nWAVTerminatingBytes];
            try {
                this.m_spIO.readFully(byArray);
            }
            catch (EOFException eOFException) {
                throw new JMACException("Can't Read WAV Terminating Bytes");
            }
            this.m_spIO.seek(l);
            return byArray;
        }
        return null;
    }

    public APEFileInfo getApeInfoInternalInfo() {
        return this.m_APEFileInfo;
    }

    private void GetFileInformation() throws IOException {
        if (this.m_bHasFileInformationLoaded) {
            return;
        }
        APEHeader aPEHeader = new APEHeader(this.m_spIO);
        aPEHeader.Analyze(this.m_APEFileInfo);
        this.m_bHasFileInformationLoaded = true;
    }
}

