/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.decoder;

import de.quippy.jmac.decoder.AntiPredictor;
import de.quippy.jmac.decoder.AntiPredictorExtraHigh0000To3320;
import de.quippy.jmac.decoder.AntiPredictorExtraHigh3320To3600;
import de.quippy.jmac.decoder.AntiPredictorExtraHigh3600To3700;
import de.quippy.jmac.decoder.AntiPredictorExtraHigh3700To3800;
import de.quippy.jmac.decoder.AntiPredictorExtraHigh3800ToCurrent;
import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.decoder.UnBitArrayBase;
import de.quippy.jmac.decoder.UnBitArrayState;
import de.quippy.jmac.tools.JMACException;
import java.io.IOException;
import java.util.Arrays;

public class APEDecompressCore {
    private long[] aryCoefficientsA = new long[64];
    private long[] aryCoefficientsB = new long[64];
    public int[] m_pTempData;
    public int[] m_pDataX;
    public int[] m_pDataY;
    public AntiPredictor m_pAntiPredictorX;
    public AntiPredictor m_pAntiPredictorY;
    public UnBitArrayBase m_pUnBitArray;
    public UnBitArrayState m_BitArrayStateX = new UnBitArrayState();
    public UnBitArrayState m_BitArrayStateY = new UnBitArrayState();
    public IAPEDecompress m_pAPEDecompress;
    public int m_nBlocksProcessed;

    public APEDecompressCore(IAPEDecompress iAPEDecompress) {
        this.m_pAPEDecompress = iAPEDecompress;
        this.m_pUnBitArray = UnBitArrayBase.CreateUnBitArray(iAPEDecompress, iAPEDecompress.getApeInfoFileVersion());
        if (iAPEDecompress.getApeInfoFileVersion() >= 3930) {
            throw new JMACException("Wrong Version");
        }
        this.m_pAntiPredictorX = AntiPredictor.createAntiPredictor(iAPEDecompress.getApeInfoCompressionLevel(), iAPEDecompress.getApeInfoFileVersion());
        this.m_pAntiPredictorY = AntiPredictor.createAntiPredictor(iAPEDecompress.getApeInfoCompressionLevel(), iAPEDecompress.getApeInfoFileVersion());
        this.m_pDataX = new int[iAPEDecompress.getApeInfoBlocksPerFrame() + 16];
        this.m_pDataY = new int[iAPEDecompress.getApeInfoBlocksPerFrame() + 16];
        this.m_pTempData = new int[iAPEDecompress.getApeInfoBlocksPerFrame() + 16];
        this.m_nBlocksProcessed = 0;
    }

    public void GenerateDecodedArrays(int n, int n2, int n3) throws IOException {
        if (this.m_pAPEDecompress.getApeInfoChannels() == 2) {
            if ((n2 & 1) > 0 && (n2 & 2) > 0) {
                Arrays.fill(this.m_pDataX, 0, n, 0);
                Arrays.fill(this.m_pDataY, 0, n, 0);
            } else if ((n2 & 4) > 0) {
                this.GenerateDecodedArray(this.m_pDataX, n, n3, this.m_pAntiPredictorX);
                Arrays.fill(this.m_pDataY, 0, n, 0);
            } else {
                this.GenerateDecodedArray(this.m_pDataX, n, n3, this.m_pAntiPredictorX);
                this.GenerateDecodedArray(this.m_pDataY, n, n3, this.m_pAntiPredictorY);
            }
        } else if ((n2 & 1) > 0) {
            Arrays.fill(this.m_pDataX, 0, n, 0);
        } else {
            this.GenerateDecodedArray(this.m_pDataX, n, n3, this.m_pAntiPredictorX);
        }
    }

    public void GenerateDecodedArray(int[] nArray, int n, int n2, AntiPredictor antiPredictor) throws IOException {
        int n3 = this.m_pAPEDecompress.getApeInfoFrameBytes(n2);
        switch (this.m_pAPEDecompress.getApeInfoCompressionLevel()) {
            case 1000: {
                if (this.m_pAPEDecompress.getApeInfoFileVersion() < 3320) {
                    this.m_pUnBitArray.GenerateArray(this.m_pTempData, n, n3);
                    antiPredictor.antiPredict(this.m_pTempData, nArray, n);
                    break;
                }
                this.m_pUnBitArray.GenerateArray(nArray, n, n3);
                antiPredictor.antiPredict(nArray, null, n);
                break;
            }
            case 2000: {
                this.m_pUnBitArray.GenerateArray(this.m_pTempData, n, n3);
                antiPredictor.antiPredict(this.m_pTempData, nArray, n);
                break;
            }
            case 3000: {
                this.m_pUnBitArray.GenerateArray(this.m_pTempData, n, n3);
                antiPredictor.antiPredict(this.m_pTempData, nArray, n);
                break;
            }
            case 4000: {
                if (this.m_pAPEDecompress.getApeInfoFileVersion() < 3320) {
                    long l = this.m_pUnBitArray.DecodeValue(2, 4);
                    int n4 = 0;
                    while ((long)n4 <= l) {
                        this.aryCoefficientsA[n4] = this.m_pUnBitArray.DecodeValue(2, 6);
                        this.aryCoefficientsB[n4] = this.m_pUnBitArray.DecodeValue(2, 6);
                        ++n4;
                    }
                    this.m_pUnBitArray.GenerateArray(this.m_pTempData, n, n3);
                    if (!(antiPredictor instanceof AntiPredictorExtraHigh0000To3320)) {
                        throw new RuntimeException("pAntiPredictor of wrong type");
                    }
                    ((AntiPredictorExtraHigh0000To3320)antiPredictor).AntiPredict(this.m_pTempData, nArray, n, (int)l, this.aryCoefficientsA, this.aryCoefficientsB);
                    break;
                }
                if (this.m_pAPEDecompress.getApeInfoFileVersion() < 3600) {
                    long l = this.m_pUnBitArray.DecodeValue(2, 3);
                    int n5 = 0;
                    while ((long)n5 <= l) {
                        this.aryCoefficientsA[n5] = this.m_pUnBitArray.DecodeValue(2, 5);
                        this.aryCoefficientsB[n5] = this.m_pUnBitArray.DecodeValue(2, 5);
                        ++n5;
                    }
                    this.m_pUnBitArray.GenerateArray(this.m_pTempData, n, n3);
                    if (!(antiPredictor instanceof AntiPredictorExtraHigh3320To3600)) {
                        throw new RuntimeException("pAntiPredictor of wrong type");
                    }
                    ((AntiPredictorExtraHigh3320To3600)antiPredictor).AntiPredict(this.m_pTempData, nArray, n, (int)l, this.aryCoefficientsA, this.aryCoefficientsB);
                    break;
                }
                if (this.m_pAPEDecompress.getApeInfoFileVersion() < 3700) {
                    long l = this.m_pUnBitArray.DecodeValue(2, 3);
                    int n6 = 0;
                    while ((long)n6 <= l) {
                        this.aryCoefficientsA[n6] = this.m_pUnBitArray.DecodeValue(2, 6);
                        this.aryCoefficientsB[n6] = this.m_pUnBitArray.DecodeValue(2, 6);
                        ++n6;
                    }
                    this.m_pUnBitArray.GenerateArray(this.m_pTempData, n, n3);
                    if (!(antiPredictor instanceof AntiPredictorExtraHigh3600To3700)) {
                        throw new RuntimeException("pAntiPredictor of wrong type");
                    }
                    ((AntiPredictorExtraHigh3600To3700)antiPredictor).AntiPredict(this.m_pTempData, nArray, n, (int)l, this.aryCoefficientsA, this.aryCoefficientsB);
                    break;
                }
                if (this.m_pAPEDecompress.getApeInfoFileVersion() < 3800) {
                    long l = this.m_pUnBitArray.DecodeValue(2, 3);
                    int n7 = 0;
                    while ((long)n7 <= l) {
                        this.aryCoefficientsA[n7] = this.m_pUnBitArray.DecodeValue(2, 6);
                        this.aryCoefficientsB[n7] = this.m_pUnBitArray.DecodeValue(2, 6);
                        ++n7;
                    }
                    this.m_pUnBitArray.GenerateArray(this.m_pTempData, n, n3);
                    if (!(antiPredictor instanceof AntiPredictorExtraHigh3700To3800)) {
                        throw new RuntimeException("pAntiPredictor of wrong type");
                    }
                    ((AntiPredictorExtraHigh3700To3800)antiPredictor).AntiPredict(this.m_pTempData, nArray, n, (int)l, this.aryCoefficientsA, this.aryCoefficientsB);
                    break;
                }
                this.m_pUnBitArray.GenerateArray(this.m_pTempData, n, n3);
                if (!(antiPredictor instanceof AntiPredictorExtraHigh3800ToCurrent)) {
                    throw new RuntimeException("pAntiPredictor of wrong type");
                }
                ((AntiPredictorExtraHigh3800ToCurrent)antiPredictor).AntiPredict(this.m_pTempData, nArray, n, this.m_pAPEDecompress.getApeInfoFileVersion());
            }
        }
    }

    public UnBitArrayBase GetUnBitArrray() {
        return this.m_pUnBitArray;
    }
}

