/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.metadata;

import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.io.BitOutputStream;
import java.io.IOException;

public class SeekPoint {
    private static final int SEEKPOINT_SAMPLE_NUMBER_LEN = 64;
    private static final int SEEKPOINT_STREAM_OFFSET_LEN = 64;
    private static final int SEEKPOINT_FRAME_SAMPLES_LEN = 16;
    protected long sampleNumber;
    protected long streamOffset;
    protected int frameSamples;

    public SeekPoint(BitInputStream bitInputStream) throws IOException {
        this.sampleNumber = bitInputStream.readRawULong(64);
        this.streamOffset = bitInputStream.readRawULong(64);
        this.frameSamples = bitInputStream.readRawUInt(16);
    }

    public SeekPoint(long l, long l2, int n) {
        this.sampleNumber = l;
        this.streamOffset = l2;
        this.frameSamples = n;
    }

    public void write(BitOutputStream bitOutputStream) throws IOException {
        bitOutputStream.writeRawULong(this.sampleNumber, 64);
        bitOutputStream.writeRawULong(this.streamOffset, 64);
        bitOutputStream.writeRawUInt(this.frameSamples, 16);
    }

    public String toString() {
        return "sampleNumber=" + this.sampleNumber + " streamOffset=" + this.streamOffset + " frameSamples=" + this.frameSamples;
    }

    public int getFrameSamples() {
        return this.frameSamples;
    }

    public long getSampleNumber() {
        return this.sampleNumber;
    }

    public long getStreamOffset() {
        return this.streamOffset;
    }

    public void setStreamOffset(long l) {
        this.streamOffset = l;
    }
}

