/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.metadata;

import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.metadata.CueTrack;
import de.quippy.jflac.metadata.Metadata;
import de.quippy.jflac.metadata.Violation;
import java.io.IOException;

public class CueSheet
extends Metadata {
    private static final int CUESHEET_MEDIA_CATALOG_NUMBER_LEN = 1024;
    private static final int CUESHEET_LEAD_IN_LEN = 64;
    private static final int CUESHEET_IS_CD_LEN = 1;
    private static final int CUESHEET_RESERVED_LEN = 2071;
    private static final int CUESHEET_NUM_TRACKS_LEN = 8;
    protected byte[] mediaCatalogNumber = new byte[129];
    protected long leadIn = 0L;
    protected boolean isCD = false;
    protected int numTracks = 0;
    protected CueTrack[] tracks;

    public CueSheet(BitInputStream bitInputStream, int n, boolean bl) throws IOException {
        super(bl);
        bitInputStream.readByteBlockAlignedNoCRC(this.mediaCatalogNumber, 128);
        this.leadIn = bitInputStream.readRawULong(64);
        this.isCD = bitInputStream.readRawUInt(1) != 0;
        bitInputStream.skipBitsNoCRC(2071);
        this.numTracks = bitInputStream.readRawUInt(8);
        if (this.numTracks > 0) {
            this.tracks = new CueTrack[this.numTracks];
            int n2 = 0;
            while (n2 < this.numTracks) {
                this.tracks[n2] = new CueTrack(bitInputStream);
                ++n2;
            }
        }
    }

    void isLegal(boolean bl) throws Violation {
        if (bl) {
            if (this.leadIn < 88200L) {
                throw new Violation("CD-DA cue sheet must have a lead-in length of at least 2 seconds");
            }
            if (this.leadIn % 588L != 0L) {
                throw new Violation("CD-DA cue sheet lead-in length must be evenly divisible by 588 samples");
            }
        }
        if (this.numTracks == 0) {
            throw new Violation("cue sheet must have at least one track (the lead-out)");
        }
        if (bl && this.tracks[this.numTracks - 1].number != 170) {
            throw new Violation("CD-DA cue sheet must have a lead-out track number 170 (0xAA)");
        }
        int n = 0;
        while (n < this.numTracks) {
            if (this.tracks[n].number == 0) {
                throw new Violation("cue sheet may not have a track number 0");
            }
            if (bl && (this.tracks[n].number < 1 || this.tracks[n].number > 99) && this.tracks[n].number != 170) {
                throw new Violation("CD-DA cue sheet track number must be 1-99 or 170");
            }
            if (bl && this.tracks[n].offset % 588L != 0L) {
                throw new Violation("CD-DA cue sheet track offset must be evenly divisible by 588 samples");
            }
            if (n < this.numTracks - 1) {
                if (this.tracks[n].numIndices == 0) {
                    throw new Violation("cue sheet track must have at least one index point");
                }
                if (this.tracks[n].indices[0].number > 1) {
                    throw new Violation("cue sheet track's first index number must be 0 or 1");
                }
            }
            int n2 = 0;
            while (n2 < this.tracks[n].numIndices) {
                if (bl && this.tracks[n].indices[n2].offset % 588L != 0L) {
                    throw new Violation("CD-DA cue sheet track index offset must be evenly divisible by 588 samples");
                }
                if (n2 > 0 && this.tracks[n].indices[n2].number != this.tracks[n].indices[n2 - 1].number + 1) {
                    throw new Violation("cue sheet track index numbers must increase by 1");
                }
                ++n2;
            }
            ++n;
        }
    }
}

