/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.frame;

import de.quippy.jflac.frame.BadHeaderException;
import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.metadata.StreamInfo;
import de.quippy.jflac.util.ByteData;
import de.quippy.jflac.util.CRC8;
import java.io.IOException;

public class Header {
    public int blockSize;
    public int sampleRate;
    public int channels;
    public int channelAssignment;
    public int bitsPerSample;
    public int frameNumber;
    public long sampleNumber;
    protected byte crc;

    public Header(BitInputStream bitInputStream, byte[] byArray, StreamInfo streamInfo) throws IOException, BadHeaderException {
        int n;
        int n2;
        boolean bl;
        ByteData byteData;
        int n3;
        int n4;
        block52: {
            int n5;
            block51: {
                this.frameNumber = -1;
                this.sampleNumber = -1L;
                n4 = 0;
                n3 = 0;
                byteData = new ByteData(16);
                bl = streamInfo != null && streamInfo.getMinBlockSize() != streamInfo.getMaxBlockSize();
                boolean bl2 = streamInfo != null && streamInfo.getMinBlockSize() == streamInfo.getMaxBlockSize();
                byteData.append(byArray[0]);
                byteData.append(byArray[1]);
                if ((byteData.getData(1) & 3) != 0) {
                    throw new BadHeaderException("Bad Magic Number: " + (byteData.getData(1) & 0xFF));
                }
                int n6 = 0;
                while (n6 < 2) {
                    if (bitInputStream.peekRawUInt(8) == 255) {
                        throw new BadHeaderException("Found sync byte");
                    }
                    byteData.append((byte)bitInputStream.readRawUInt(8));
                    ++n6;
                }
                n6 = byteData.getData(2) >> 4 & 0xF;
                switch (n6) {
                    case 0: {
                        if (!bl2 || streamInfo == null) {
                            throw new BadHeaderException("Unknown Block Size (0)");
                        }
                        this.blockSize = streamInfo.getMinBlockSize();
                        break;
                    }
                    case 1: {
                        this.blockSize = 192;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        this.blockSize = 576 << n6 - 2;
                        break;
                    }
                    case 6: 
                    case 7: {
                        n4 = n6;
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.blockSize = 256 << n6 - 8;
                        break;
                    }
                }
                int n7 = byteData.getData(2) & 0xF;
                switch (n7) {
                    case 0: {
                        if (streamInfo == null) {
                            throw new BadHeaderException("Bad Sample Rate (0)");
                        }
                        this.sampleRate = streamInfo.getSampleRate();
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new BadHeaderException("Bad Sample Rate (" + n7 + ")");
                    }
                    case 4: {
                        this.sampleRate = 8000;
                        break;
                    }
                    case 5: {
                        this.sampleRate = 16000;
                        break;
                    }
                    case 6: {
                        this.sampleRate = 22050;
                        break;
                    }
                    case 7: {
                        this.sampleRate = 24000;
                        break;
                    }
                    case 8: {
                        this.sampleRate = 32000;
                        break;
                    }
                    case 9: {
                        this.sampleRate = 44100;
                        break;
                    }
                    case 10: {
                        this.sampleRate = 48000;
                        break;
                    }
                    case 11: {
                        this.sampleRate = 96000;
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        n3 = n7;
                        break;
                    }
                    case 15: {
                        throw new BadHeaderException("Bad Sample Rate (" + n7 + ")");
                    }
                }
                n5 = byteData.getData(3) >> 4 & 0xF;
                if ((n5 & 8) == 0) break block51;
                this.channels = 2;
                switch (n5 & 7) {
                    case 0: {
                        this.channelAssignment = 1;
                        break block52;
                    }
                    case 1: {
                        this.channelAssignment = 2;
                        break block52;
                    }
                    case 2: {
                        this.channelAssignment = 3;
                        break block52;
                    }
                    default: {
                        throw new BadHeaderException("Bad Channel Assignment (" + n5 + ")");
                    }
                }
            }
            this.channels = n5 + 1;
            this.channelAssignment = 0;
        }
        int n8 = (byteData.getData(3) & 0xE) >> 1;
        switch (n8) {
            case 0: {
                if (streamInfo != null) {
                    this.bitsPerSample = streamInfo.getBitsPerSample();
                    break;
                }
                throw new BadHeaderException("Bad BPS (" + n8 + ")");
            }
            case 1: {
                this.bitsPerSample = 8;
                break;
            }
            case 2: {
                this.bitsPerSample = 12;
                break;
            }
            case 4: {
                this.bitsPerSample = 16;
                break;
            }
            case 5: {
                this.bitsPerSample = 20;
                break;
            }
            case 6: {
                this.bitsPerSample = 24;
                break;
            }
            case 3: 
            case 7: {
                throw new BadHeaderException("Bad BPS (" + n8 + ")");
            }
        }
        if ((byteData.getData(3) & 1) != 0) {
            throw new BadHeaderException("this should be a zero padding bit");
        }
        if (n4 != 0 && bl) {
            this.sampleNumber = bitInputStream.readUTF8Long(byteData);
            if (this.sampleNumber == -1L) {
                throw new BadHeaderException("Bad Sample Number");
            }
        } else {
            n2 = bitInputStream.readUTF8Int(byteData);
            if (n2 == -1 || streamInfo == null) {
                throw new BadHeaderException("Bad Last Frame");
            }
            this.sampleNumber = (long)streamInfo.getMinBlockSize() * (long)n2;
        }
        if (n4 != 0) {
            n2 = bitInputStream.readRawUInt(8);
            byteData.append((byte)n2);
            if (n4 == 7) {
                n = bitInputStream.readRawUInt(8);
                byteData.append((byte)n);
                n2 = n2 << 8 | n;
            }
            this.blockSize = n2 + 1;
        }
        if (n3 != 0) {
            n2 = bitInputStream.readRawUInt(8);
            byteData.append((byte)n2);
            if (n3 != 12) {
                n = bitInputStream.readRawUInt(8);
                byteData.append((byte)n);
                n2 = n2 << 8 | n;
            }
            this.sampleRate = n3 == 12 ? n2 * 1000 : (n3 == 13 ? n2 : n2 * 10);
        }
        n2 = (byte)bitInputStream.readRawUInt(8);
        if (CRC8.calc(byteData.getData(), byteData.getLen()) != n2) {
            throw new BadHeaderException("STREAM_DECODER_ERROR_STATUS_BAD_HEADER");
        }
    }

    public String toString() {
        return "FrameHeader: BlockSize=" + this.blockSize + " SampleRate=" + this.sampleRate + " Channels=" + this.channels + " ChannelAssignment=" + this.channelAssignment + " BPS=" + this.bitsPerSample + " SampleNumber=" + this.sampleNumber;
    }
}

