/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.frame;

import de.quippy.jflac.ChannelData;
import de.quippy.jflac.LPCPredictor;
import de.quippy.jflac.frame.Channel;
import de.quippy.jflac.frame.EntropyCodingMethod;
import de.quippy.jflac.frame.EntropyPartitionedRice;
import de.quippy.jflac.frame.Header;
import de.quippy.jflac.io.BitInputStream;
import de.quippy.jflac.util.BitMath;
import java.io.IOException;

public class ChannelLPC
extends Channel {
    private static final int SUBFRAME_LPC_QLP_COEFF_PRECISION_LEN = 4;
    private static final int SUBFRAME_LPC_QLP_SHIFT_LEN = 5;
    private static final int MAX_LPC_ORDER = 32;
    private EntropyCodingMethod entropyCodingMethod;
    private int order;
    private int qlpCoeffPrecision;
    private int quantizationLevel;
    private int[] qlpCoeff = new int[32];
    private int[] warmup = new int[32];

    public ChannelLPC(BitInputStream bitInputStream, Header header, ChannelData channelData, int n, int n2, int n3) throws IOException {
        super(header, n2);
        this.order = n3;
        int n4 = 0;
        while (n4 < n3) {
            this.warmup[n4] = bitInputStream.readRawInt(n);
            ++n4;
        }
        n4 = bitInputStream.readRawUInt(4);
        if (n4 == 15) {
            throw new IOException("STREAM_DECODER_ERROR_STATUS_LOST_SYNC");
        }
        this.qlpCoeffPrecision = n4 + 1;
        this.quantizationLevel = bitInputStream.readRawInt(5);
        int n5 = 0;
        while (n5 < n3) {
            this.qlpCoeff[n5] = bitInputStream.readRawInt(this.qlpCoeffPrecision);
            ++n5;
        }
        n5 = bitInputStream.readRawUInt(2);
        switch (n5) {
            case 0: {
                this.entropyCodingMethod = new EntropyPartitionedRice();
                ((EntropyPartitionedRice)this.entropyCodingMethod).order = bitInputStream.readRawUInt(4);
                ((EntropyPartitionedRice)this.entropyCodingMethod).contents = channelData.getPartitionedRiceContents();
                break;
            }
            default: {
                throw new IOException("STREAM_DECODER_UNPARSEABLE_STREAM");
            }
        }
        ((EntropyPartitionedRice)this.entropyCodingMethod).readResidual(bitInputStream, n3, ((EntropyPartitionedRice)this.entropyCodingMethod).order, header, channelData.getResidual());
        System.arraycopy(this.warmup, 0, channelData.getOutput(), 0, n3);
        if (n + this.qlpCoeffPrecision + BitMath.ilog2(n3) <= 32) {
            if (n <= 16 && this.qlpCoeffPrecision <= 16) {
                LPCPredictor.restoreSignal(channelData.getResidual(), header.blockSize - n3, this.qlpCoeff, n3, this.quantizationLevel, channelData.getOutput(), n3);
            } else {
                LPCPredictor.restoreSignal(channelData.getResidual(), header.blockSize - n3, this.qlpCoeff, n3, this.quantizationLevel, channelData.getOutput(), n3);
            }
        } else {
            LPCPredictor.restoreSignalWide(channelData.getResidual(), header.blockSize - n3, this.qlpCoeff, n3, this.quantizationLevel, channelData.getOutput(), n3);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ChannelLPC: Order=" + this.order + " WastedBits=" + this.wastedBits);
        stringBuffer.append(" qlpCoeffPrecision=" + this.qlpCoeffPrecision + " quantizationLevel=" + this.quantizationLevel);
        stringBuffer.append("\n\t\tqlpCoeff: ");
        int n = 0;
        while (n < this.order) {
            stringBuffer.append(String.valueOf(this.qlpCoeff[n]) + " ");
            ++n;
        }
        stringBuffer.append("\n\t\tWarmup: ");
        n = 0;
        while (n < this.order) {
            stringBuffer.append(String.valueOf(this.warmup[n]) + " ");
            ++n;
        }
        stringBuffer.append("\n\t\tParameter: ");
        n = 0;
        while (n < 1 << ((EntropyPartitionedRice)this.entropyCodingMethod).order) {
            stringBuffer.append(String.valueOf(((EntropyPartitionedRice)this.entropyCodingMethod).contents.parameters[n]) + " ");
            ++n;
        }
        return stringBuffer.toString();
    }
}

