/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.frame;

import de.quippy.jflac.ChannelData;
import de.quippy.jflac.FixedPredictor;
import de.quippy.jflac.frame.Channel;
import de.quippy.jflac.frame.EntropyCodingMethod;
import de.quippy.jflac.frame.EntropyPartitionedRice;
import de.quippy.jflac.frame.Header;
import de.quippy.jflac.io.BitInputStream;
import java.io.IOException;

public class ChannelFixed
extends Channel {
    private static final int MAX_FIXED_ORDER = 4;
    private EntropyCodingMethod entropyCodingMethod;
    private int order;
    private int[] warmup = new int[4];
    private int[] residual;

    public ChannelFixed(BitInputStream bitInputStream, Header header, ChannelData channelData, int n, int n2, int n3) throws IOException {
        super(header, n2);
        this.residual = channelData.getResidual();
        this.order = n3;
        int n4 = 0;
        while (n4 < n3) {
            this.warmup[n4] = bitInputStream.readRawInt(n);
            ++n4;
        }
        n4 = bitInputStream.readRawUInt(2);
        switch (n4) {
            case 0: {
                int n5 = bitInputStream.readRawUInt(4);
                EntropyPartitionedRice entropyPartitionedRice = new EntropyPartitionedRice();
                this.entropyCodingMethod = entropyPartitionedRice;
                entropyPartitionedRice.order = n5;
                entropyPartitionedRice.contents = channelData.getPartitionedRiceContents();
                entropyPartitionedRice.readResidual(bitInputStream, n3, entropyPartitionedRice.order, header, channelData.getResidual());
                break;
            }
            default: {
                throw new IOException("STREAM_DECODER_UNPARSEABLE_STREAM");
            }
        }
        System.arraycopy(this.warmup, 0, channelData.getOutput(), 0, n3);
        FixedPredictor.restoreSignal(this.residual, header.blockSize - n3, n3, channelData.getOutput(), n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FLACSubframe_Fixed: Order=" + this.order + " PartitionOrder=" + ((EntropyPartitionedRice)this.entropyCodingMethod).order + " WastedBits=" + this.wastedBits);
        int n = 0;
        while (n < this.order) {
            stringBuffer.append(" warmup[" + n + "]=" + this.warmup[n]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

