/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.wav;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.BasicMixer;
import de.quippy.javamod.system.Log;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class WavMixer
extends BasicMixer {
    private int bufferSize;
    private byte[] output;
    private int sampleSizeInBits;
    private int sampleSizeInBytes;
    private int channels;
    private int sampleRate;
    private int lengthInMilliseconds;
    private URL waveFileUrl;
    private AudioInputStream audioInputStream;
    private long currentSamplesWritten;

    public WavMixer(URL uRL) {
        this.waveFileUrl = uRL;
        this.initialize();
    }

    private void initialize() {
        try {
            AudioFormat[] audioFormatArray;
            if (this.audioInputStream != null) {
                try {
                    this.audioInputStream.close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
            this.audioInputStream = AudioSystem.getAudioInputStream(new FileOrPackedInputStream(this.waveFileUrl));
            AudioFormat audioFormat = this.audioInputStream.getFormat();
            this.lengthInMilliseconds = 0;
            float f = audioFormat.getFrameRate();
            if (f != -1.0f) {
                this.lengthInMilliseconds = (int)((double)((float)this.audioInputStream.getFrameLength() * 1000.0f / f) + 0.5);
            } else {
                try {
                    this.lengthInMilliseconds = (int)((long)this.audioInputStream.available() / (long)(audioFormat.getSampleSizeInBits() >> 3) / (long)audioFormat.getChannels() * 1000L / (long)audioFormat.getSampleRate());
                }
                catch (IOException iOException) {
                    Log.error("[WavMixer] No data available!", iOException);
                }
            }
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            if (!AudioSystem.isLineSupported(info) && (audioFormatArray = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_SIGNED, audioFormat)) != null && audioFormatArray.length != 0) {
                this.audioInputStream = AudioSystem.getAudioInputStream(audioFormatArray[0], this.audioInputStream);
                audioFormat = this.audioInputStream.getFormat();
                Log.info("Converting input data to " + audioFormat.toString());
            }
            this.setAudioFormat(audioFormat);
            this.channels = audioFormat.getChannels();
            this.sampleSizeInBits = audioFormat.getSampleSizeInBits();
            this.sampleSizeInBytes = this.sampleSizeInBits >> 3;
            this.sampleRate = (int)audioFormat.getSampleRate();
            this.bufferSize = 250 * this.channels * this.sampleRate / 1000;
            this.bufferSize *= this.sampleSizeInBytes;
            this.output = new byte[this.bufferSize];
        }
        catch (Throwable throwable) {
            Log.error("[WavMixer]", throwable);
        }
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    public long getMillisecondPosition() {
        if (this.sampleRate != 0) {
            return this.currentSamplesWritten * 1000L / (long)this.sampleRate;
        }
        return 0L;
    }

    @Override
    protected void seek(long l) {
        try {
            if (this.getMillisecondPosition() > l) {
                if (this.audioInputStream != null) {
                    try {
                        this.audioInputStream.close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
                this.audioInputStream = AudioSystem.getAudioInputStream(this.waveFileUrl);
                this.currentSamplesWritten = 0L;
            }
            long l2 = l * (long)this.sampleRate / 1000L - this.currentSamplesWritten;
            long l3 = l2 * (long)this.sampleSizeInBytes * (long)this.channels;
            while (l3 > 0L) {
                l3 -= this.audioInputStream.skip(l3);
            }
            this.currentSamplesWritten += l2;
        }
        catch (Exception exception) {
            Log.error("[WavMixer]: error while seeking", exception);
        }
    }

    @Override
    public long getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    @Override
    public int getChannelCount() {
        return this.channels;
    }

    @Override
    public int getCurrentKBperSecond() {
        return this.sampleSizeInBits * this.channels * this.sampleRate / 1000;
    }

    @Override
    public int getCurrentSampleFrequency() {
        return this.sampleRate / 1000;
    }

    @Override
    public void startPlayback() {
        this.initialize();
        this.currentSamplesWritten = 0L;
        this.setIsPlaying();
        if (this.getSeekPosition() > 0L) {
            this.seek(this.getSeekPosition());
        }
        try {
            this.openAudioDevice();
            if (!this.isInitialized()) {
                return;
            }
            try {
                int n = 0;
                do {
                    if ((n = this.audioInputStream.read(this.output, 0, this.bufferSize)) <= 0) continue;
                    this.writeSampleDataToLine(this.output, 0, n);
                    this.currentSamplesWritten += (long)(n / this.sampleSizeInBytes / this.channels);
                    if (this.isStopping()) {
                        this.setIsStopped();
                        break;
                    }
                    if (this.isPausing()) {
                        this.setIsPaused();
                        while (this.isPaused()) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (!this.isInSeeking()) continue;
                    this.setIsSeeking();
                    while (this.isInSeeking()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } while (n != -1);
                if (n <= 0) {
                    this.setHasFinished();
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.setIsStopped();
            this.closeAudioDevice();
            if (this.audioInputStream != null) {
                try {
                    this.audioInputStream.close();
                    this.audioInputStream = null;
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
    }
}

