/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ogg;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.ogg.OGGInfoPanel;
import de.quippy.javamod.multimedia.ogg.OGGMixer;
import de.quippy.javamod.multimedia.ogg.metadata.OggMetaData;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class OGGContainer
extends MultimediaContainer {
    private static final String[] OGGFILEEXTENSION = new String[]{"ogg", "oga"};
    private JPanel oggInfoPanel;
    private OggMetaData oggMetaData = null;

    static {
        MultimediaContainerManager.registerContainer(new OGGContainer());
    }

    @Override
    public MultimediaContainer getInstance(URL uRL) {
        MultimediaContainer multimediaContainer = super.getInstance(uRL);
        this.oggMetaData = new OggMetaData(uRL);
        ((OGGInfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.oggMetaData, this.getPrintableFileUrl());
        return multimediaContainer;
    }

    @Override
    public String getSongName() {
        if (this.oggMetaData != null) {
            return this.oggMetaData.getShortDescription();
        }
        return super.getSongName();
    }

    @Override
    public Object[] getSongInfosFor(URL uRL) {
        String string = MultimediaContainerManager.getSongNameFromURL(uRL);
        Long l = -1L;
        try {
            OggMetaData oggMetaData = new OggMetaData(uRL);
            string = oggMetaData.getShortDescription();
            l = oggMetaData.getLengthInMilliseconds();
        }
        catch (Throwable throwable) {}
        return new Object[]{string, l};
    }

    @Override
    public Mixer createNewMixer() {
        return new OGGMixer(this.getFileURL(), this.oggMetaData.getLengthInMilliseconds());
    }

    @Override
    public boolean canExport() {
        return true;
    }

    @Override
    public String[] getFileExtensionList() {
        return OGGFILEEXTENSION;
    }

    @Override
    public String getName() {
        return "ogg/vorbis-File";
    }

    @Override
    public JPanel getConfigPanel() {
        return null;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.oggInfoPanel == null) {
            this.oggInfoPanel = new OGGInfoPanel();
        }
        return this.oggInfoPanel;
    }

    @Override
    public void configurationChanged(Properties properties) {
    }

    @Override
    public void configurationSave(Properties properties) {
    }
}

