/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.tracker;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.mod.loader.instrument.Envelope;
import de.quippy.javamod.multimedia.mod.loader.instrument.Instrument;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.Pattern;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternRow;
import de.quippy.javamod.multimedia.mod.loader.tracker.ProTrackerMod;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.IOException;

public class XMMod
extends ProTrackerMod {
    private static final String[] MODFILEEXTENSION = new String[]{"xm"};
    private int version;
    private int headerSize;
    private int songRestart;
    private int flag;

    static {
        ModuleFactory.registerModule(new XMMod());
    }

    public XMMod() {
    }

    protected XMMod(String string) {
        super(string);
    }

    @Override
    public String[] getFileExtensionList() {
        return MODFILEEXTENSION;
    }

    @Override
    public int getFrequencyTable() {
        return (this.songFlags & 0x10) != 0 ? 8 : 4;
    }

    public int getSongRestart() {
        return this.songRestart;
    }

    private void setIntoPatternElement(PatternElement patternElement, ModfileInputStream modfileInputStream) throws IOException {
        int n;
        int n2;
        long l = modfileInputStream.getFilePointer();
        int n3 = modfileInputStream.readByteAsInt();
        modfileInputStream.seek(l);
        int n4 = n2 = (n3 & 0x80) != 0 ? modfileInputStream.readByteAsInt() : 31;
        if ((n2 & 1) != 0) {
            n = 0;
            int n5 = modfileInputStream.readByteAsInt();
            if (n5 == 97) {
                n = -1;
                n5 = -1;
            } else if (n5 != 0) {
                if (n5 < 97) {
                    n5 += 12;
                }
                n = Helpers.noteValues[(n5 -= 12) - 1];
            }
            patternElement.setNoteIndex(n5);
            patternElement.setPeriod(n);
        }
        if ((n2 & 2) != 0) {
            patternElement.setInstrument(modfileInputStream.readByteAsInt());
        }
        if ((n2 & 4) != 0 && (n = modfileInputStream.readByteAsInt()) != 0) {
            if (n <= 80) {
                patternElement.setVolumeEffekt(1);
                patternElement.setVolumeEffektOp(n - 16);
            } else {
                patternElement.setVolumeEffekt((n >> 4) - 4);
                patternElement.setVolumeEffektOp(n & 0xF);
            }
        }
        if ((n2 & 8) != 0) {
            patternElement.setEffekt(modfileInputStream.readByteAsInt());
        }
        if ((n2 & 0x10) != 0) {
            patternElement.setEffektOp(modfileInputStream.readByteAsInt());
        }
    }

    private boolean isXMMod(String string) {
        if (string.equals("Extended Module: ")) {
            return true;
        }
        return string.toLowerCase().equals("extended module: ");
    }

    @Override
    public boolean checkLoadingPossible(ModfileInputStream modfileInputStream) throws IOException {
        String string = modfileInputStream.readString(17);
        modfileInputStream.seek(0L);
        return this.isXMMod(string);
    }

    @Override
    protected Module getNewInstance(String string) {
        return new XMMod(string);
    }

    @Override
    public void loadModFileInternal(ModfileInputStream modfileInputStream) throws IOException {
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.setModType(2);
        this.setBaseVolume(128);
        this.setModID(modfileInputStream.readString(17));
        if (!this.isXMMod(this.getModID())) {
            throw new IOException("Unsupported XM Module!");
        }
        this.setSongName(modfileInputStream.readString(20));
        modfileInputStream.skip(1L);
        String string = modfileInputStream.readString(20);
        this.setTrackerName(string.trim());
        this.version = modfileInputStream.readIntelWord();
        if (this.version < 260) {
            Log.info("XM-Version is below 0x0104... ");
        }
        long l = modfileInputStream.getFilePointer();
        this.headerSize = modfileInputStream.readIntelDWord();
        this.setSongLength(modfileInputStream.readIntelWord());
        this.songRestart = modfileInputStream.readIntelWord();
        this.setNChannels(modfileInputStream.readIntelWord());
        this.setNPattern(modfileInputStream.readIntelWord());
        this.setNInstruments(modfileInputStream.readIntelWord());
        this.flag = modfileInputStream.readIntelWord();
        if ((this.flag & 1) != 0) {
            this.songFlags |= 0x10;
        }
        if ((this.flag & 0x1000) != 0) {
            this.songFlags |= 0x8000;
        }
        this.setTempo(modfileInputStream.readIntelWord());
        this.setBPMSpeed(modfileInputStream.readIntelWord());
        int n7 = 0;
        this.allocArrangement(256);
        int n8 = 0;
        while (n8 < 256) {
            this.getArrangement()[n8 - n7] = modfileInputStream.readByteAsInt();
            ++n8;
        }
        modfileInputStream.seek(l + (long)this.headerSize);
        PatternContainer patternContainer = new PatternContainer(this.getNPattern());
        int n9 = 0;
        while (n9 < this.getNPattern()) {
            l = modfileInputStream.getFilePointer();
            n6 = modfileInputStream.readIntelDWord();
            n5 = modfileInputStream.readByteAsInt();
            if (n5 != 0) {
                throw new IOException("Unknown pattern packing type: " + n5);
            }
            n4 = modfileInputStream.readIntelWord();
            n3 = modfileInputStream.readIntelWord();
            modfileInputStream.seek(l + (long)n6);
            Pattern pattern = new Pattern(n4);
            if (n3 > 0) {
                n2 = 0;
                while (n2 < n4) {
                    object = new PatternRow(this.getNChannels());
                    n = 0;
                    while (n < this.getNChannels()) {
                        PatternElement patternElement = new PatternElement(n9, n2, n);
                        this.setIntoPatternElement(patternElement, modfileInputStream);
                        ((PatternRow)object).setPatternElement(n, patternElement);
                        ++n;
                    }
                    pattern.setPatternRow(n2, (PatternRow)object);
                    ++n2;
                }
            }
            patternContainer.setPattern(n9, pattern);
            ++n9;
        }
        this.setPatternContainer(patternContainer);
        InstrumentsContainer instrumentsContainer = new InstrumentsContainer(this, this.getNInstruments(), 0);
        this.setInstrumentContainer(instrumentsContainer);
        n6 = 0;
        n5 = 0;
        while (n5 < this.getNInstruments()) {
            Object object2;
            n4 = 0;
            n3 = 0;
            int n10 = 0;
            n2 = 0;
            l = modfileInputStream.getFilePointer();
            object = new Instrument();
            n = modfileInputStream.readIntelDWord();
            ((Instrument)object).setName(modfileInputStream.readString(22));
            modfileInputStream.readByteAsInt();
            int n11 = modfileInputStream.readIntelWord();
            if (n11 > 0) {
                this.setNSamples(this.getNSamples() + n11);
                modfileInputStream.readIntelDWord();
                int[] nArray = new int[96];
                object2 = new int[96];
                int n12 = 0;
                while (n12 < 96) {
                    nArray[n12] = modfileInputStream.readByteAsInt() + n6 + 1;
                    object2[n12] = n12;
                    ++n12;
                }
                ((Instrument)object).setIndexArray(nArray);
                ((Instrument)object).setNoteArray((int[])object2);
                int[] nArray2 = new int[12];
                int[] nArray3 = new int[12];
                int n13 = 0;
                while (n13 < 12) {
                    nArray2[n13] = modfileInputStream.readIntelWord();
                    nArray3[n13] = modfileInputStream.readIntelWord();
                    ++n13;
                }
                Envelope envelope = new Envelope();
                envelope.setPosition(nArray2);
                envelope.setValue(nArray3);
                ((Instrument)object).setVolumeEnvelope(envelope);
                int[] nArray4 = new int[12];
                int[] nArray5 = new int[12];
                int n14 = 0;
                while (n14 < 12) {
                    nArray4[n14] = modfileInputStream.readIntelWord();
                    nArray5[n14] = modfileInputStream.readIntelWord();
                    ++n14;
                }
                Envelope envelope2 = new Envelope();
                envelope2.setPosition(nArray4);
                envelope2.setValue(nArray5);
                ((Instrument)object).setPanningEnvelope(envelope2);
                envelope.setNPoints(modfileInputStream.readByteAsInt());
                envelope2.setNPoints(modfileInputStream.readByteAsInt());
                envelope.setSustainPoint(modfileInputStream.readByteAsInt());
                envelope.setLoopStartPoint(modfileInputStream.readByteAsInt());
                envelope.setLoopEndPoint(modfileInputStream.readByteAsInt());
                envelope2.setSustainPoint(modfileInputStream.readByteAsInt());
                envelope2.setLoopStartPoint(modfileInputStream.readByteAsInt());
                envelope2.setLoopEndPoint(modfileInputStream.readByteAsInt());
                envelope.setXMType(modfileInputStream.readByteAsInt());
                envelope2.setXMType(modfileInputStream.readByteAsInt());
                n4 = modfileInputStream.readByteAsInt();
                n3 = modfileInputStream.readByteAsInt();
                n10 = modfileInputStream.readByteAsInt();
                n2 = modfileInputStream.readByteAsInt();
                ((Instrument)object).setVolumeFadeOut(modfileInputStream.readIntelWord());
                modfileInputStream.skip(2L);
            }
            modfileInputStream.seek(l + (long)n);
            instrumentsContainer.reallocSampleSpace(this.getNSamples());
            int n15 = 0;
            while (n15 < n11) {
                object2 = new Sample();
                ((Sample)object2).setVibratoType(n4);
                ((Sample)object2).setVibratoSweep(n3);
                ((Sample)object2).setVibratoDepth(n10);
                ((Sample)object2).setVibratoRate(n2);
                ((Sample)object2).setLength(modfileInputStream.readIntelDWord());
                int n16 = modfileInputStream.readIntelDWord();
                int n17 = modfileInputStream.readIntelDWord();
                int n18 = n16 + n17;
                int n19 = modfileInputStream.readByteAsInt() & 0x7F;
                ((Sample)object2).setVolume(n19 > 64 ? 64 : n19);
                int n20 = modfileInputStream.readByteAsInt();
                n20 = n20 > 127 ? n20 - 256 : n20;
                ((Sample)object2).setFineTune(n20);
                ((Sample)object2).setBaseFrequency(Helpers.it_fineTuneTable[(n20 >> 4) + 8]);
                ((Sample)object2).setFlags(modfileInputStream.readByteAsInt());
                int n21 = 0;
                if ((((Sample)object2).flags & 3) != 0) {
                    n21 |= 1;
                }
                if ((((Sample)object2).flags & 2) == 2) {
                    n21 |= 4;
                }
                ((Sample)object2).setLoopType(n21);
                if ((((Sample)object2).flags & 0x10) != 0) {
                    ((Sample)object2).length >>= 1;
                    n16 >>= 1;
                    n18 >>= 1;
                }
                ((Sample)object2).setRepeatStart(n16);
                ((Sample)object2).setRepeatStop(n18);
                ((Sample)object2).setRepeatLength(n18 - n16);
                ((Sample)object2).setPanning(modfileInputStream.readByteAsInt());
                int n22 = modfileInputStream.readByteAsInt();
                ((Sample)object2).setTranspose(n22 > 127 ? n22 - 256 : n22);
                modfileInputStream.skip(1L);
                ((Sample)object2).setName(modfileInputStream.readString(22));
                instrumentsContainer.setSample(n15 + n6, (Sample)object2);
                ++n15;
            }
            n15 = 0;
            while (n15 < n11) {
                object2 = instrumentsContainer.getSample(n15 + n6);
                int n23 = 2;
                if ((((Sample)object2).flags & 0x10) != 0) {
                    n23 |= 4;
                }
                this.readSampleData((Sample)object2, n23, modfileInputStream);
                ++n15;
            }
            instrumentsContainer.setInstrument(n5, (Instrument)object);
            n6 += n11;
            ++n5;
        }
        this.cleanUpArrangement();
    }
}

