/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader.tracker;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.multimedia.mod.loader.instrument.InstrumentsContainer;
import de.quippy.javamod.multimedia.mod.loader.instrument.Sample;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternContainer;
import de.quippy.javamod.multimedia.mod.loader.pattern.PatternElement;
import de.quippy.javamod.multimedia.mod.mixer.BasicModMixer;
import de.quippy.javamod.multimedia.mod.mixer.ProTrackerMixer;
import de.quippy.javamod.system.Helpers;
import java.io.IOException;

public class ProTrackerMod
extends Module {
    private static final String[] MODFILEEXTENSION = new String[]{"nst", "mod", "wow"};
    private boolean isAmigaLike;

    static {
        ModuleFactory.registerModule(new ProTrackerMod());
    }

    public ProTrackerMod() {
    }

    protected ProTrackerMod(String string) {
        super(string);
    }

    @Override
    public String[] getFileExtensionList() {
        return MODFILEEXTENSION;
    }

    @Override
    public BasicModMixer getModMixer(int n, int n2, int n3) {
        return new ProTrackerMixer(this, n, n2, n3);
    }

    @Override
    public int getPanningValue(int n) {
        if (n % 3 != 0) {
            return 256;
        }
        return 0;
    }

    @Override
    public int getChannelVolume(int n) {
        return 64;
    }

    @Override
    public int getFrequencyTable() {
        return this.isAmigaLike ? 2 : 4;
    }

    @Override
    public boolean doFastSlides() {
        return false;
    }

    private String getModType(String string) {
        if (string.length() == 4) {
            this.setNSamples(31);
            if (string.equals("M.K.") || string.equals("M!K!") || string.equals("M&K!") || string.equals("N.T.")) {
                this.isAmigaLike = true;
                this.setNChannels(4);
                return "ProTracker";
            }
            if (string.startsWith("FLT")) {
                this.isAmigaLike = false;
                this.setNChannels(Integer.parseInt(Character.toString(string.charAt(3))));
                return "StarTrekker";
            }
            if (string.startsWith("TDZ")) {
                this.isAmigaLike = false;
                this.setNChannels(Integer.parseInt(Character.toString(string.charAt(3))));
                return "StarTrekker";
            }
            if (string.endsWith("CHN")) {
                this.isAmigaLike = false;
                this.setNChannels(Integer.parseInt(Character.toString(string.charAt(0))));
                return "StarTrekker";
            }
            if (string.equals("CD81") || string.equals("OKTA")) {
                this.isAmigaLike = false;
                this.setNChannels(8);
                return "Atari Oktalyzer";
            }
            String string2 = string.substring(0, 2);
            String string3 = string.substring(2, 4);
            if (string3.equals("CH") || string3.equals("CN")) {
                this.isAmigaLike = false;
                this.setNChannels(Integer.parseInt(string2));
                return "TakeTracker";
            }
        }
        this.isAmigaLike = true;
        this.setNSamples(15);
        this.setNChannels(4);
        this.setModID("NONE");
        return "NoiseTracker";
    }

    private int calculatePatternCount(int n) {
        int n2;
        int n3 = 150;
        if (this.getNSamples() > 15) {
            n3 += 4;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.getNSamples()) {
            n4 = (int)((long)n4 + (30L + (long)this.getInstrumentContainer().getSample((int)n5).length));
            ++n5;
        }
        n5 = n - n3 - n4;
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.getSongLength()) {
            n2 = this.getArrangement()[n7];
            if (n2 > n6 && n2 < 128) {
                n6 = this.getArrangement()[n7];
            }
            ++n7;
        }
        if (this.getModID().equals("M.K.") && (n7 = ++n6 * 2048) == n5) {
            this.isAmigaLike = true;
            this.setNChannels(8);
            this.setTrackerName("Grave Composer");
        }
        n7 = 256 * this.getNChannels();
        this.setNPattern(n5 / n7);
        n2 = n5 % n7;
        if (n2 > 0) {
            if (n6 > this.getNPattern()) {
                n2 -= n7;
                this.setNPattern(n6 + 1);
            } else {
                n2 += (this.getNPattern() - n6) * n7;
                this.setNPattern(n6);
            }
            return n2;
        }
        return 0;
    }

    private PatternElement createNewPatternElement(int n, int n2, int n3, int n4) {
        PatternElement patternElement = new PatternElement(n, n2, n3);
        if (this.getNSamples() > 15) {
            patternElement.setInstrument(((n4 & 0xF0000000) >> 24 | (n4 & 0xF000) >> 12) & this.getNSamples());
            patternElement.setPeriod((n4 & 0xFFF0000) >> 16);
        } else {
            patternElement.setInstrument((n4 & 0xF000) >> 12 & this.getNSamples());
            patternElement.setPeriod((n4 & 0xFFFF0000) >> 16);
        }
        if (patternElement.getPeriod() > 0) {
            patternElement.setNoteIndex(Helpers.getNoteIndexForPeriod(patternElement.getPeriod()) + 1);
        }
        patternElement.setEffekt((n4 & 0xF00) >> 8);
        patternElement.setEffektOp(n4 & 0xFF);
        if (patternElement.getEffekt() == 12 && patternElement.getEffektOp() > 64) {
            patternElement.setEffektOp(64);
        }
        return patternElement;
    }

    @Override
    public boolean checkLoadingPossible(ModfileInputStream modfileInputStream) throws IOException {
        modfileInputStream.seek(1080L);
        String string = modfileInputStream.readString(4);
        modfileInputStream.seek(0L);
        return string.equals("M.K.") || string.equals("M!K!") || string.equals("M&K!") || string.equals("N.T.") || string.startsWith("FLT") || string.startsWith("TDZ") || string.endsWith("CHN") || string.equals("CD81") || string.equals("OKTA") || string.endsWith("CH") || string.endsWith("CN");
    }

    @Override
    protected Module getNewInstance(String string) {
        return new ProTrackerMod(string);
    }

    @Override
    public void loadModFileInternal(ModfileInputStream modfileInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        this.setModType(1);
        this.setBaseVolume(128);
        this.setBPMSpeed(125);
        this.setTempo(6);
        modfileInputStream.seek(1080L);
        this.setModID(modfileInputStream.readString(4));
        modfileInputStream.seek(0L);
        this.setTrackerName(this.getModType(this.getModID()));
        this.setSongName(modfileInputStream.readString(20));
        this.setNInstruments(this.getNSamples());
        InstrumentsContainer instrumentsContainer = new InstrumentsContainer(this, 0, this.getNSamples());
        this.setInstrumentContainer(instrumentsContainer);
        int n5 = 0;
        while (n5 < this.getNSamples()) {
            object = new Sample();
            ((Sample)object).setName(modfileInputStream.readString(22));
            ((Sample)object).setLength(modfileInputStream.readMotorolaWord() << 1);
            n4 = modfileInputStream.readByteAsInt() & 0xF;
            n4 = n4 > 7 ? n4 - 16 : n4;
            ((Sample)object).setFineTune(n4 << 4);
            ((Sample)object).setTranspose(0);
            ((Sample)object).setBaseFrequency(Helpers.it_fineTuneTable[n4 + 8]);
            n3 = modfileInputStream.readByteAsInt() & 0x7F;
            ((Sample)object).setVolume(n3 > 64 ? 64 : n3);
            n2 = modfileInputStream.readMotorolaWord() << 1;
            n = modfileInputStream.readMotorolaWord() << 1;
            int n6 = n2 + n;
            if (((Sample)object).length < 4) {
                ((Sample)object).length = 0;
            }
            if (((Sample)object).length > 0) {
                if (n2 > ((Sample)object).length) {
                    n2 = ((Sample)object).length - 1;
                }
                if (n6 > ((Sample)object).length) {
                    n6 = ((Sample)object).length;
                }
                if (n2 >= n6 || n6 <= 8 || n6 - n2 <= 4) {
                    n6 = 0;
                    n2 = 0;
                    ((Sample)object).setLoopType(0);
                }
                if (n2 < n6) {
                    ((Sample)object).setLoopType(1);
                }
            } else {
                ((Sample)object).setLoopType(0);
            }
            ((Sample)object).setRepeatStart(n2);
            ((Sample)object).setRepeatStop(n6);
            ((Sample)object).setRepeatLength(n6 - n2);
            ((Sample)object).setPanning(-1);
            instrumentsContainer.setSample(n5, (Sample)object);
            ++n5;
        }
        this.setSongLength(modfileInputStream.readByteAsInt());
        modfileInputStream.skip(1L);
        this.allocArrangement(128);
        n5 = 0;
        while (n5 < 128) {
            this.getArrangement()[n5] = modfileInputStream.readByteAsInt();
            ++n5;
        }
        if (this.getNSamples() > 15) {
            modfileInputStream.skip(4L);
        }
        n5 = this.calculatePatternCount((int)modfileInputStream.getLength());
        object = new PatternContainer(this.getNPattern(), 64, this.getNChannels());
        this.setPatternContainer((PatternContainer)object);
        n4 = 0;
        while (n4 < this.getNPattern()) {
            if (this.getModID().equals("FLT8")) {
                n3 = 0;
                while (n3 < 64) {
                    n2 = 0;
                    while (n2 < 4) {
                        n = modfileInputStream.readMotorolaDWord();
                        ((PatternContainer)object).setPatternElement(this.createNewPatternElement(n4, n3, n2, n));
                        ++n2;
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 < 64) {
                    n2 = 4;
                    while (n2 < 8) {
                        n = modfileInputStream.readMotorolaDWord();
                        ((PatternContainer)object).setPatternElement(this.createNewPatternElement(n4, n3, n2, n));
                        ++n2;
                    }
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < 64) {
                    n2 = 0;
                    while (n2 < this.getNChannels()) {
                        n = modfileInputStream.readMotorolaDWord();
                        ((PatternContainer)object).setPatternElement(this.createNewPatternElement(n4, n3, n2, n));
                        ++n2;
                    }
                    ++n3;
                }
            }
            ++n4;
        }
        if (n5 < 0) {
            n4 = this.getInstrumentContainer().getFullSampleLength();
            n4 = (int)modfileInputStream.getLength() - n4;
            if ((long)n4 < modfileInputStream.getFilePointer()) {
                modfileInputStream.seek(n4);
            }
        }
        n4 = 0;
        while (n4 < this.getNSamples()) {
            Sample sample = this.getInstrumentContainer().getSample(n4);
            this.readSampleData(sample, 0, modfileInputStream);
            ++n4;
        }
        this.cleanUpArrangement();
    }
}

