/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod.loader;

import de.quippy.javamod.io.ModfileInputStream;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ModuleFactory {
    private static HashMap<String, Module> fileExtensionMap;
    private static ArrayList<Module> modulesArray;

    private ModuleFactory() {
    }

    private static HashMap<String, Module> getFileExtensionMap() {
        if (fileExtensionMap == null) {
            fileExtensionMap = new HashMap();
        }
        return fileExtensionMap;
    }

    private static ArrayList<Module> getModulesArray() {
        if (modulesArray == null) {
            modulesArray = new ArrayList();
        }
        return modulesArray;
    }

    public static void registerModule(Module module) {
        ModuleFactory.getModulesArray().add(module);
        String[] stringArray = module.getFileExtensionList();
        int n = 0;
        while (n < stringArray.length) {
            ModuleFactory.getFileExtensionMap().put(stringArray[n], module);
            ++n;
        }
    }

    public static void deregisterModule(Module module) {
        ModuleFactory.getModulesArray().remove(module);
        String[] stringArray = module.getFileExtensionList();
        int n = 0;
        while (n < stringArray.length) {
            ModuleFactory.getFileExtensionMap().remove(stringArray[n]);
            ++n;
        }
    }

    public static String[] getSupportedFileExtensions() {
        Set<String> set = ModuleFactory.getFileExtensionMap().keySet();
        String[] stringArray = new String[set.size()];
        return set.toArray(stringArray);
    }

    public static Module getModuleFromExtension(String string) {
        return ModuleFactory.getFileExtensionMap().get(string.toLowerCase());
    }

    private static Module getModuleFromStreamByID(ModfileInputStream modfileInputStream) {
        for (Module module : ModuleFactory.getModulesArray()) {
            try {
                if (!module.checkLoadingPossible(modfileInputStream)) continue;
                return module;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static Module getModuleFromStream(ModfileInputStream modfileInputStream) {
        for (Module module : ModuleFactory.getModulesArray()) {
            try {
                Module module2 = module.loadModFile(modfileInputStream);
                modfileInputStream.seek(0L);
                return module2;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static Module getInstance(String string) throws IOException {
        return ModuleFactory.getInstance(new File(string));
    }

    public static Module getInstance(File file) throws IOException {
        return ModuleFactory.getInstance(file.toURI().toURL());
    }

    public static Module getInstance(URL uRL) throws IOException {
        ModfileInputStream modfileInputStream = null;
        try {
            modfileInputStream = new ModfileInputStream(uRL);
            Module module = ModuleFactory.getModuleFromStreamByID(modfileInputStream);
            if (module != null) {
                Module module2 = module.loadModFile(modfileInputStream);
                return module2;
            }
            module = ModuleFactory.getModuleFromStream(modfileInputStream);
            if (module != null) {
                Module module3 = module;
                return module3;
            }
            try {
                throw new IOException("Unsupported MOD-Type: " + modfileInputStream.getFileName());
            }
            catch (Exception exception) {
                Log.error("[ModuleFactory] Failed with loading " + uRL.toString(), exception);
                return null;
            }
        }
        finally {
            if (modfileInputStream != null) {
                try {
                    modfileInputStream.close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
    }
}

