/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.mod;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.mod.ModConfigPanel;
import de.quippy.javamod.multimedia.mod.ModInfoPanel;
import de.quippy.javamod.multimedia.mod.ModMixer;
import de.quippy.javamod.multimedia.mod.loader.Module;
import de.quippy.javamod.multimedia.mod.loader.ModuleFactory;
import de.quippy.javamod.system.Log;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class ModContainer
extends MultimediaContainer {
    public static final String PROPERTY_PLAYER_BITSPERSAMPLE = "javamod.player.bitspersample";
    public static final String PROPERTY_PLAYER_STEREO = "javamod.player.stereo";
    public static final String PROPERTY_PLAYER_FREQUENCY = "javamod.player.frequency";
    public static final String PROPERTY_PLAYER_ISP = "javamod.player.ISP";
    public static final String PROPERTY_PLAYER_WIDESTEREOMIX = "javamod.player.widestereomix";
    public static final String PROPERTY_PLAYER_NOISEREDUCTION = "javamod.player.noisereduction";
    public static final String PROPERTY_PLAYER_MEGABASS = "javamod.player.megabass";
    public static final String PROPERTY_PLAYER_NOLOOPS = "javamod.player.noloops";
    public static final String DEFAULT_WIDESTEREOMIX = "false";
    public static final String DEFAULT_NOISEREDUCTION = "false";
    public static final String DEFAULT_MEGABASS = "false";
    public static final String DEFAULT_NOLOOPS = "0";
    public static final String DEFAULT_SAMPLERATE = "44100";
    public static final String DEFAULT_CHANNEL = "2";
    public static final String DEFAULT_BITSPERSAMPLE = "16";
    public static final String DEFAULT_INTERPOLATION_INDEX = "1";
    public static final String[] SAMPLERATE = new String[]{"8000", "11025", "16000", "22050", "33075", "44100", "48000", "96000"};
    public static final String[] CHANNELS = new String[]{"1", "2"};
    public static final String[] BITSPERSAMPLE = new String[]{"8", "16", "24"};
    public static final String[] INTERPOLATION = new String[]{"none", "linear", "cubic spline", "windowed FIR"};
    private Module currentMod;
    private ModMixer currentMixer;
    private ModInfoPanel modInfoPanel;
    private ModConfigPanel modConfigPanel;

    static {
        MultimediaContainerManager.registerContainer(new ModContainer());
    }

    @Override
    public MultimediaContainer getInstance(URL uRL) {
        MultimediaContainer multimediaContainer = super.getInstance(uRL);
        try {
            this.currentMod = ModuleFactory.getInstance(uRL);
            if (this.currentMod == null) {
                Log.error("[ModContainer] Failed with loading of " + uRL.toString(), new Exception("Modfile " + uRL.toString() + " is obviously corrupt!"));
                multimediaContainer = null;
            } else {
                ((ModInfoPanel)this.getInfoPanel()).fillInfoPanelWith(this.currentMod);
            }
        }
        catch (Exception exception) {
            this.currentMod = null;
            throw new RuntimeException(exception);
        }
        return multimediaContainer;
    }

    @Override
    public String getSongName() {
        String string;
        if (this.currentMod != null && (string = this.currentMod.getSongName()) != null && string.trim().length() != 0) {
            return string;
        }
        return super.getSongName();
    }

    @Override
    public Object[] getSongInfosFor(URL uRL) {
        String string = MultimediaContainerManager.getSongNameFromURL(uRL);
        Long l = -1L;
        try {
            ModConfigPanel modConfigPanel;
            int n;
            Module module = ModuleFactory.getInstance(uRL);
            String string2 = module.getSongName();
            if (string2 != null && string2.trim().length() != 0) {
                string = string2;
            }
            if ((n = (modConfigPanel = (ModConfigPanel)this.getConfigPanel()).getLoopValue()) == 0) {
                n = 2;
            }
            ModMixer modMixer = new ModMixer(module, 8, 1, 1000, 0, false, false, false, n);
            l = modMixer.getLengthInMilliseconds();
        }
        catch (Throwable throwable) {}
        return new Object[]{string, l};
    }

    @Override
    public boolean canExport() {
        return true;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.modInfoPanel == null) {
            this.modInfoPanel = new ModInfoPanel();
        }
        return this.modInfoPanel;
    }

    @Override
    public JPanel getConfigPanel() {
        if (this.modConfigPanel == null) {
            this.modConfigPanel = new ModConfigPanel();
            this.modConfigPanel.setParentContainer(this);
        }
        return this.modConfigPanel;
    }

    @Override
    public String[] getFileExtensionList() {
        return ModuleFactory.getSupportedFileExtensions();
    }

    @Override
    public String getName() {
        return "Mod-File";
    }

    @Override
    public void configurationChanged(Properties properties) {
        ModConfigPanel modConfigPanel = (ModConfigPanel)this.getConfigPanel();
        modConfigPanel.getPlayerSetUp_SampleRate().setSelectedItem(properties.getProperty(PROPERTY_PLAYER_FREQUENCY, DEFAULT_SAMPLERATE));
        modConfigPanel.getPlayerSetUp_BitsPerSample().setSelectedItem(properties.getProperty(PROPERTY_PLAYER_BITSPERSAMPLE, DEFAULT_BITSPERSAMPLE));
        modConfigPanel.getPlayerSetUp_Channels().setSelectedItem(properties.getProperty(PROPERTY_PLAYER_STEREO, DEFAULT_CHANNEL));
        modConfigPanel.getPlayerSetUp_Interpolation().setSelectedIndex(Integer.parseInt(properties.getProperty(PROPERTY_PLAYER_ISP, DEFAULT_INTERPOLATION_INDEX)));
        modConfigPanel.getPlayerSetUp_WideStereoMix().setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_PLAYER_WIDESTEREOMIX, "false")));
        modConfigPanel.getPlayerSetUp_NoiseReduction().setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_PLAYER_NOISEREDUCTION, "false")));
        modConfigPanel.getPlayerSetUp_MegaBass().setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_PLAYER_MEGABASS, "false")));
        int n = Integer.parseInt(properties.getProperty(PROPERTY_PLAYER_NOLOOPS, DEFAULT_NOLOOPS));
        modConfigPanel.setLoopValue(n);
    }

    @Override
    public void configurationSave(Properties properties) {
        ModConfigPanel modConfigPanel = (ModConfigPanel)this.getConfigPanel();
        properties.setProperty(PROPERTY_PLAYER_FREQUENCY, modConfigPanel.getPlayerSetUp_SampleRate().getSelectedItem().toString());
        properties.setProperty(PROPERTY_PLAYER_BITSPERSAMPLE, modConfigPanel.getPlayerSetUp_BitsPerSample().getSelectedItem().toString());
        properties.setProperty(PROPERTY_PLAYER_STEREO, modConfigPanel.getPlayerSetUp_Channels().getSelectedItem().toString());
        properties.setProperty(PROPERTY_PLAYER_ISP, Integer.toString(modConfigPanel.getPlayerSetUp_Interpolation().getSelectedIndex()));
        properties.setProperty(PROPERTY_PLAYER_WIDESTEREOMIX, Boolean.toString(modConfigPanel.getPlayerSetUp_WideStereoMix().isSelected()));
        properties.setProperty(PROPERTY_PLAYER_NOISEREDUCTION, Boolean.toString(modConfigPanel.getPlayerSetUp_NoiseReduction().isSelected()));
        properties.setProperty(PROPERTY_PLAYER_MEGABASS, Boolean.toString(modConfigPanel.getPlayerSetUp_MegaBass().isSelected()));
        properties.setProperty(PROPERTY_PLAYER_NOLOOPS, Integer.toString(modConfigPanel.getLoopValue()));
    }

    @Override
    public Mixer createNewMixer() {
        if (this.currentMod == null) {
            return null;
        }
        Properties properties = new Properties();
        this.configurationSave(properties);
        int n = Integer.parseInt(properties.getProperty(PROPERTY_PLAYER_FREQUENCY, DEFAULT_SAMPLERATE));
        int n2 = Integer.parseInt(properties.getProperty(PROPERTY_PLAYER_BITSPERSAMPLE, DEFAULT_BITSPERSAMPLE));
        int n3 = Integer.parseInt(properties.getProperty(PROPERTY_PLAYER_STEREO, DEFAULT_CHANNEL));
        int n4 = Integer.parseInt(properties.getProperty(PROPERTY_PLAYER_ISP, DEFAULT_INTERPOLATION_INDEX));
        boolean bl = Boolean.parseBoolean(properties.getProperty(PROPERTY_PLAYER_WIDESTEREOMIX, "false"));
        boolean bl2 = Boolean.parseBoolean(properties.getProperty(PROPERTY_PLAYER_NOISEREDUCTION, "false"));
        boolean bl3 = Boolean.parseBoolean(properties.getProperty(PROPERTY_PLAYER_MEGABASS, "false"));
        int n5 = Integer.parseInt(properties.getProperty(PROPERTY_PLAYER_NOLOOPS, DEFAULT_NOLOOPS));
        this.currentMixer = new ModMixer(this.currentMod, n2, n3, n, n4, bl, bl2, bl3, n5);
        return this.currentMixer;
    }

    public ModMixer getCurrentMixer() {
        return this.currentMixer;
    }

    public Module getCurrentMod() {
        return this.currentMod;
    }
}

