/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.ape;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.ape.APEInfoPanel;
import de.quippy.javamod.multimedia.ape.APEMixer;
import de.quippy.javamod.system.Log;
import de.quippy.jmac.decoder.IAPEDecompress;
import de.quippy.jmac.info.APETag;
import de.quippy.jmac.tools.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.JPanel;

public class APEContainer
extends MultimediaContainer {
    private static final String[] APEFILEEXTENSION = new String[]{"ape", "apl", "mac"};
    private JPanel apeInfoPanel;
    private APETag idTag;

    static {
        MultimediaContainerManager.registerContainer(new APEContainer());
    }

    @Override
    public boolean canExport() {
        return true;
    }

    @Override
    public MultimediaContainer getInstance(URL uRL) {
        MultimediaContainer multimediaContainer;
        block12: {
            multimediaContainer = super.getInstance(uRL);
            File file = null;
            try {
                try {
                    file = File.createFile(uRL, "r");
                    IAPEDecompress iAPEDecompress = IAPEDecompress.CreateIAPEDecompress(file);
                    this.idTag = iAPEDecompress.getApeInfoTag();
                    ((APEInfoPanel)this.getInfoPanel()).fillInfoPanelWith(iAPEDecompress, this.getPrintableFileUrl(), this.getSongName());
                }
                catch (IOException iOException) {
                    if (file == null) break block12;
                    try {
                        file.close();
                    }
                    catch (IOException iOException2) {
                        Log.error("IGNORED", iOException2);
                    }
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
            }
        }
        return multimediaContainer;
    }

    @Override
    public Mixer createNewMixer() {
        return new APEMixer(this.getFileURL());
    }

    private String getSongName(APETag aPETag, URL uRL) {
        if (aPETag != null) {
            try {
                String string = aPETag.GetFieldString("Artist");
                String string2 = aPETag.GetFieldString("Title");
                if (string2 == null || string2.length() == 0) {
                    string2 = MultimediaContainerManager.getSongNameFromURL(uRL);
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (string != null && string.length() != 0) {
                    stringBuilder.append(string).append(" - ");
                }
                return stringBuilder.append(string2).toString();
            }
            catch (Throwable throwable) {}
        }
        return MultimediaContainerManager.getSongNameFromURL(uRL);
    }

    @Override
    public String getSongName() {
        if (this.idTag != null) {
            return this.getSongName(this.idTag, this.getFileURL());
        }
        return super.getSongName();
    }

    @Override
    public Object[] getSongInfosFor(URL uRL) {
        String string = MultimediaContainerManager.getSongNameFromURL(uRL);
        Long l = -1L;
        try {
            File file = File.createFile(uRL, "r");
            IAPEDecompress iAPEDecompress = IAPEDecompress.CreateIAPEDecompress(file);
            APETag aPETag = iAPEDecompress.getApeInfoTag();
            string = this.getSongName(aPETag, uRL);
            l = iAPEDecompress.getApeInfoDecompressLengthMS();
        }
        catch (Throwable throwable) {}
        return new Object[]{string, l};
    }

    @Override
    public JPanel getConfigPanel() {
        return null;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.apeInfoPanel == null) {
            this.apeInfoPanel = new APEInfoPanel();
        }
        return this.apeInfoPanel;
    }

    @Override
    public void configurationChanged(Properties properties) {
    }

    @Override
    public void configurationSave(Properties properties) {
    }

    @Override
    public String[] getFileExtensionList() {
        return APEFILEEXTENSION;
    }

    @Override
    public String getName() {
        return "APE-File";
    }
}

