/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia;

import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerEventListener;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class MultimediaContainer {
    private ArrayList<MultimediaContainerEventListener> listeners = new ArrayList();
    private URL fileURL;

    public MultimediaContainer getInstance(URL uRL) {
        this.fileURL = uRL;
        return this;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public String getPrintableFileUrl() {
        return this.getPrintableFileUrl(this.getFileURL());
    }

    public String getPrintableFileUrl(URL uRL) {
        try {
            File file = new File(uRL.toURI());
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return file.getAbsolutePath();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
    }

    public void updateLookAndFeel() {
        JPanel jPanel = this.getInfoPanel();
        JPanel jPanel2 = this.getConfigPanel();
        if (jPanel != null) {
            SwingUtilities.updateComponentTreeUI(jPanel);
        }
        if (jPanel2 != null) {
            SwingUtilities.updateComponentTreeUI(jPanel2);
        }
    }

    public void addListener(MultimediaContainerEventListener multimediaContainerEventListener) {
        this.listeners.add(multimediaContainerEventListener);
    }

    public void removeListener(MultimediaContainerEventListener multimediaContainerEventListener) {
        this.listeners.remove(multimediaContainerEventListener);
    }

    protected void fireMultimediaContainerEvent(MultimediaContainerEvent multimediaContainerEvent) {
        int n = 0;
        while (n < this.listeners.size()) {
            this.listeners.get(n).multimediaContainerEventOccured(multimediaContainerEvent);
            ++n;
        }
    }

    public String getSongName() {
        return MultimediaContainerManager.getSongNameFromURL(this.fileURL);
    }

    public abstract Object[] getSongInfosFor(URL var1);

    public abstract boolean canExport();

    public abstract JPanel getInfoPanel();

    public abstract JPanel getConfigPanel();

    public abstract String[] getFileExtensionList();

    public abstract String getName();

    public abstract void configurationChanged(Properties var1);

    public abstract void configurationSave(Properties var1);

    public abstract Mixer createNewMixer();
}

