/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.mixer.dsp.pitchshift;

import de.quippy.javamod.mixer.dsp.DSPEffekt;
import de.quippy.javamod.mixer.dsp.FFT2;
import de.quippy.javamod.system.FastMath;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;

public class PitchShift
implements DSPEffekt {
    private static final int MAXFIFO = 2;
    private float[][] gInFIFO = null;
    private float[][] gOutFIFO = null;
    private float[][] stretchFIFO = null;
    private float[] gFFTworksp = null;
    private float[][] gLastPhase = null;
    private float[][] gSumPhase = null;
    private float[][] gOutputAccum = null;
    private float[] gAnaFreq = null;
    private float[] gAnaMagn = null;
    private float[] gSynFreq = null;
    private float[] gSynMagn = null;
    private float[] gWindow = null;
    private float[] gWindow2 = null;
    private float[] gWindow3 = null;
    private float[] outBuffer = null;
    private FFT2 fft = null;
    private int gRover;
    private float pitchScale;
    private float sampleScale;
    private int fftFrameSize;
    private int osamp;
    private float sampleRate;
    private int fftFrameSize2;
    private int stepSize;
    private float freqPerBin;
    private float expct;
    private float expct2;
    private float inFifoLatency;
    private boolean isActive;
    private int sampleBufferSize;
    private int channels;

    public PitchShift(float f, float f2, int n, int n2) {
        this.pitchScale = f;
        this.sampleScale = f2;
        this.fftFrameSize = n;
        this.osamp = n2;
        this.isActive = false;
    }

    public PitchShift() {
        this(1.0f, 1.0f, 4096, 32);
    }

    @Override
    public void initialize(AudioFormat audioFormat, int n) {
        this.sampleBufferSize = n;
        this.sampleRate = audioFormat.getSampleRate();
        this.channels = audioFormat.getChannels();
        this.outBuffer = new float[this.sampleBufferSize];
        this.changeFFTFrameSize(this.fftFrameSize);
    }

    @Override
    public void setIsActive(boolean bl) {
        this.isActive = bl;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public synchronized float getPitchScale() {
        return this.pitchScale;
    }

    public synchronized void setPitchScale(float f) {
        this.pitchScale = f;
    }

    public synchronized float getSampleScale() {
        return this.sampleScale;
    }

    public synchronized void setSampleScale(float f) {
        this.sampleScale = f;
    }

    public synchronized void setPitchAndSampleScale(float f, float f2) {
        this.setPitchScale(f);
        this.setSampleScale(f2);
    }

    public int getFftFrameSize() {
        return this.fftFrameSize;
    }

    public synchronized void setFFTFrameSize(int n) {
        this.changeFFTFrameSize(n);
    }

    public synchronized int getFFTOversampling() {
        return this.osamp;
    }

    public synchronized void setFFTOversampling(int n) {
        this.changeFFTOversampling(n);
    }

    private void changeFFTFrameSize(int n) {
        this.fftFrameSize = n;
        this.fftFrameSize2 = this.fftFrameSize >> 1;
        this.stepSize = this.fftFrameSize / this.osamp;
        this.freqPerBin = this.sampleRate / (float)this.fftFrameSize;
        this.expct = (float)Math.PI * 2 * (float)this.stepSize / (float)this.fftFrameSize;
        this.expct2 = (float)Math.PI * 2 / (float)this.osamp;
        this.inFifoLatency = this.fftFrameSize - this.stepSize;
        this.gRover = (int)this.inFifoLatency;
        this.fft = new FFT2(this.fftFrameSize);
        this.stretchFIFO = new float[this.channels][2];
        this.gInFIFO = new float[this.channels][this.fftFrameSize];
        this.gOutFIFO = new float[this.channels][this.fftFrameSize];
        this.gFFTworksp = new float[this.fftFrameSize << 1];
        this.gLastPhase = new float[this.channels][this.fftFrameSize >> 1];
        this.gSumPhase = new float[this.channels][this.fftFrameSize >> 1];
        this.gOutputAccum = new float[this.channels][this.fftFrameSize << 1];
        this.gAnaFreq = new float[this.fftFrameSize];
        this.gAnaMagn = new float[this.fftFrameSize];
        this.gSynFreq = new float[this.fftFrameSize];
        this.gSynMagn = new float[this.fftFrameSize];
        this.gWindow = new float[this.fftFrameSize];
        this.gWindow2 = new float[this.fftFrameSize];
        this.gWindow3 = new float[this.fftFrameSize2];
        Arrays.fill(this.gAnaFreq, 0.0f);
        Arrays.fill(this.gAnaMagn, 0.0f);
        Arrays.fill(this.gSynFreq, 0.0f);
        Arrays.fill(this.gSynMagn, 0.0f);
        Arrays.fill(this.gFFTworksp, 0.0f);
        int n2 = 0;
        while (n2 < this.channels) {
            Arrays.fill(this.gInFIFO[n2], 0.0f);
            Arrays.fill(this.gOutFIFO[n2], 0.0f);
            Arrays.fill(this.gOutputAccum[n2], 0.0f);
            Arrays.fill(this.gLastPhase[n2], 0.0f);
            Arrays.fill(this.gSumPhase[n2], 0.0f);
            ++n2;
        }
        this.computeWindow();
    }

    private void changeFFTOversampling(int n) {
        this.osamp = n;
        this.stepSize = this.fftFrameSize / this.osamp;
        this.expct = (float)Math.PI * 2 * (float)this.stepSize / (float)this.fftFrameSize;
        this.inFifoLatency = this.fftFrameSize - this.stepSize;
        this.gRover = (int)this.inFifoLatency;
    }

    private void processFrame(int n) {
        this.windowAndInterleave(n);
        this.analyze(n);
        this.process();
        this.synthesize(n);
        this.windowAndAccumulate(n);
        System.arraycopy(this.gOutputAccum[n], 0, this.gOutFIFO[n], 0, this.stepSize);
        System.arraycopy(this.gOutputAccum[n], this.stepSize, this.gOutputAccum[n], 0, this.fftFrameSize);
        System.arraycopy(this.gInFIFO[n], this.stepSize, this.gInFIFO[n], 0, (int)this.inFifoLatency);
    }

    private void computeWindow() {
        int n = 0;
        while (n < this.fftFrameSize) {
            this.gWindow[n] = -0.5f * (float)Math.cos(Math.PI * 2 * (double)n / (double)this.fftFrameSize) + 0.5f;
            this.gWindow2[n] = 2.0f * this.gWindow[n] / (float)(this.fftFrameSize2 * this.osamp);
            ++n;
        }
        n = 0;
        while (n < this.fftFrameSize2) {
            this.gWindow3[n] = (float)n * this.expct;
            ++n;
        }
    }

    private void windowAndInterleave(int n) {
        int n2 = 0;
        while (n2 < this.fftFrameSize) {
            this.gFFTworksp[n2 << 1] = this.gInFIFO[n][n2] * this.gWindow[n2];
            this.gFFTworksp[(n2 << 1) + 1] = 0.0f;
            ++n2;
        }
    }

    private void analyze(int n) {
        this.fft.smsFft(this.gFFTworksp, -1);
        int n2 = 0;
        while (n2 < this.fftFrameSize2) {
            float f = this.gFFTworksp[n2 << 1];
            float f2 = this.gFFTworksp[(n2 << 1) + 1];
            float f3 = 2.0f * (float)FastMath.sqrt(f * f + f2 * f2);
            float f4 = (float)FastMath.atan2(f2, f);
            float f5 = f4 - this.gLastPhase[n][n2];
            this.gLastPhase[n][n2] = f4;
            int n3 = (int)((double)(f5 -= (float)n2 * this.expct) / Math.PI);
            n3 = n3 >= 0 ? (n3 += n3 & 1) : (n3 -= n3 & 1);
            f5 -= (float)Math.PI * (float)n3;
            f5 = (float)this.osamp * f5 / ((float)Math.PI * 2);
            f5 = (float)n2 * this.freqPerBin + f5 * this.freqPerBin;
            this.gAnaMagn[n2] = f3;
            this.gAnaFreq[n2] = f5;
            ++n2;
        }
    }

    private void process() {
        Arrays.fill(this.gSynMagn, 0, this.fftFrameSize, 0.0f);
        int n = 0;
        while (n <= this.fftFrameSize2) {
            int n2 = (int)((float)n / this.pitchScale);
            if (n2 <= this.fftFrameSize2) {
                if (this.gAnaMagn[n2] > this.gSynMagn[n]) {
                    this.gSynMagn[n] = this.gAnaMagn[n2];
                    this.gSynFreq[n] = this.gAnaFreq[n2] * this.pitchScale;
                }
                if (n > 0 && this.gSynFreq[n] == 0.0f) {
                    this.gSynFreq[n] = this.gSynFreq[n - 1];
                    this.gSynMagn[n] = this.gSynMagn[n - 1];
                }
            }
            ++n;
        }
    }

    private void synthesize(int n) {
        int n2 = 0;
        while (n2 < this.fftFrameSize2) {
            float f = this.gSynMagn[n2];
            float f2 = this.gSynFreq[n2];
            f2 = (f2 - (float)n2 * this.freqPerBin) / this.freqPerBin * this.expct2 + this.gWindow3[n2];
            float[] fArray = this.gSumPhase[n];
            int n3 = n2;
            float f3 = fArray[n3] + f2;
            fArray[n3] = f3;
            float f4 = f3;
            this.gFFTworksp[n2 << 1] = f * (float)FastMath.fastCos(f4);
            this.gFFTworksp[(n2 << 1) + 1] = f * (float)FastMath.fastSin(f4);
            ++n2;
        }
        Arrays.fill(this.gFFTworksp, this.fftFrameSize + 2, this.fftFrameSize << 1, 0.0f);
        this.fft.smsFft(this.gFFTworksp, 1);
    }

    private void windowAndAccumulate(int n) {
        int n2 = 0;
        while (n2 < this.fftFrameSize) {
            float[] fArray = this.gOutputAccum[n];
            int n3 = n2;
            fArray[n3] = fArray[n3] + this.gWindow2[n2] * this.gFFTworksp[n2 << 1];
            ++n2;
        }
    }

    private float getSampleFrom(int n, float[] fArray, float f, float f2) {
        float[] fArray2 = this.stretchFIFO[n];
        float f3 = fArray2[0];
        float f4 = fArray2[1];
        float f5 = f + f2;
        float f6 = f5 - FastMath.floor(f);
        int n2 = (int)f5 - (int)f;
        if (n2 > 0) {
            fArray2[0] = fArray2[1];
            fArray2[1] = fArray[((int)f5 * this.channels + n) % this.sampleBufferSize];
        }
        return f3 + (f4 - f3) * f6;
    }

    @Override
    public synchronized int doEffekt(float[] fArray, int n, int n2) {
        int n3;
        if (!this.isActive) {
            return n2;
        }
        if (this.gRover == 0) {
            this.gRover = (int)this.inFifoLatency;
        }
        float f = (float)(n + n2) / (float)this.channels;
        float f2 = (float)n / (float)this.channels;
        int n4 = 0;
        while (f2 < f) {
            n3 = 0;
            while (n3 < this.channels) {
                this.gInFIFO[n3][this.gRover] = this.getSampleFrom(n3, fArray, f2, this.sampleScale);
                this.outBuffer[n4++] = this.gOutFIFO[n3][this.gRover - (int)this.inFifoLatency];
                ++n3;
            }
            f2 += this.sampleScale;
            ++this.gRover;
            if (this.gRover < this.fftFrameSize) continue;
            this.gRover = (int)this.inFifoLatency;
            n3 = 0;
            while (n3 < this.channels) {
                this.processFrame(n3);
                ++n3;
            }
        }
        n3 = n4;
        int n5 = n + n3;
        if (n5 >= this.sampleBufferSize) {
            System.arraycopy(this.outBuffer, n3 -= (n5 -= this.sampleBufferSize), fArray, 0, n5);
        }
        System.arraycopy(this.outBuffer, 0, fArray, n, n3);
        return n4;
    }
}

