/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.playlist;

import de.quippy.javamod.main.gui.tools.FileChooserFilter;
import de.quippy.javamod.main.playlist.PlayListEntry;
import de.quippy.javamod.main.playlist.PlaylistChangedListener;
import de.quippy.javamod.main.playlist.cuesheet.CueFile;
import de.quippy.javamod.main.playlist.cuesheet.CueIndex;
import de.quippy.javamod.main.playlist.cuesheet.CueSheet;
import de.quippy.javamod.main.playlist.cuesheet.CueTrack;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PlayList {
    public static String[] SUPPORTEDPLAYLISTS = new String[]{"pls", "m3u", "cue", "zip"};
    public static FileChooserFilter PLAYLIST_FILE_FILTER = new FileChooserFilter(SUPPORTEDPLAYLISTS, PlayList.getFileChooserDescription());
    public static String[] SUPPORTEDSAVELISTS = new String[]{"pls", "m3u"};
    public static FileChooserFilter PLAYLIST_SAVE_FILE_FILTER = new FileChooserFilter(SUPPORTEDSAVELISTS, PlayList.getFileChooserDescription());
    private static String INDEX_STRING = "  index ";
    private URL loadedFromURL;
    private ArrayList<PlayListEntry> entries;
    private int current;
    private boolean repeat;
    private ArrayList<PlaylistChangedListener> listeners = new ArrayList();

    public PlayList(boolean bl, boolean bl2) {
        this.entries = new ArrayList();
        this.current = -1;
        this.repeat = bl2;
        if (bl) {
            this.doShuffle();
        }
    }

    public PlayList(ArrayList<PlayListEntry> arrayList, boolean bl, boolean bl2) {
        this.entries = arrayList;
        int n = 0;
        while (n < arrayList.size()) {
            arrayList.get(n).setSavedInPlaylist(this);
            ++n;
        }
        this.current = -1;
        this.repeat = bl2;
        if (bl) {
            this.doShuffle();
        }
    }

    public PlayList(File[] fileArray, boolean bl, boolean bl2) {
        this(PlayList.generateURLListFromFiles(fileArray), bl, bl2);
    }

    public PlayList(String[] stringArray, boolean bl, boolean bl2) {
        this(PlayList.generateURLListFromFileNames(stringArray), bl, bl2);
    }

    public PlayList(URL[] uRLArray, boolean bl, boolean bl2) {
        this.entries = new ArrayList(uRLArray.length);
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            if (PlayList.isPlaylistFile(uRL)) {
                try {
                    PlayList playList = PlayList.createFromFile(uRL, false, false);
                    if (this.getLoadedFromURL() == null) {
                        this.setLoadedFromURL(uRL);
                    }
                    Iterator<PlayListEntry> iterator = playList.getIterator();
                    while (iterator.hasNext()) {
                        PlayListEntry playListEntry = iterator.next();
                        playListEntry.setSavedInPlaylist(this);
                        this.entries.add(playListEntry);
                    }
                }
                catch (IOException iOException) {
                    Log.error("PlayList", iOException);
                }
            } else {
                this.entries.add(new PlayListEntry(uRLArray[n], this));
            }
            ++n;
        }
        this.current = -1;
        this.repeat = bl2;
        if (bl) {
            this.doShuffle();
        }
    }

    public synchronized void addPlaylistChangedListener(PlaylistChangedListener playlistChangedListener) {
        this.listeners.add(playlistChangedListener);
    }

    public synchronized void removePlaylistChangedListener(PlaylistChangedListener playlistChangedListener) {
        this.listeners.remove(playlistChangedListener);
    }

    public synchronized void fireActiveElementChanged(PlayListEntry playListEntry, PlayListEntry playListEntry2) {
        int n = 0;
        while (n < this.listeners.size()) {
            this.listeners.get(n).activeElementChanged(playListEntry, playListEntry2);
            ++n;
        }
    }

    public synchronized void fireSelectedElementChanged(PlayListEntry playListEntry, PlayListEntry playListEntry2) {
        int n = 0;
        while (n < this.listeners.size()) {
            this.listeners.get(n).selectedElementChanged(playListEntry, playListEntry2);
            ++n;
        }
    }

    public synchronized boolean isRepeat() {
        return this.repeat;
    }

    public synchronized void setRepeat(boolean bl) {
        this.repeat = bl;
    }

    public synchronized void doShuffle() {
        Random random = new Random(System.currentTimeMillis());
        ArrayList<PlayListEntry> arrayList = new ArrayList<PlayListEntry>(this.size());
        while (!this.entries.isEmpty()) {
            arrayList.add(this.entries.remove(random.nextInt(this.entries.size())));
        }
        this.entries = arrayList;
        this.current = -1;
        int n = 0;
        while (n < this.entries.size()) {
            PlayListEntry playListEntry = this.entries.get(n);
            if (playListEntry.isActive()) {
                if (this.current == -1) {
                    this.current = n;
                } else {
                    playListEntry.setActive(false);
                }
            }
            ++n;
        }
    }

    private synchronized ArrayList<PlayListEntry> getEntries() {
        return this.entries;
    }

    public synchronized PlayListEntry[] getAllEntries() {
        return this.entries.toArray(new PlayListEntry[this.entries.size()]);
    }

    public synchronized PlayListEntry getCurrentEntry() {
        if (this.current >= 0 && this.current < this.size()) {
            return this.entries.get(this.current);
        }
        return null;
    }

    public synchronized PlayListEntry getEntry(int n) {
        if (n >= 0 && n < this.size()) {
            return this.entries.get(n);
        }
        return null;
    }

    private synchronized void activateCurrentEntry() {
        PlayListEntry playListEntry = this.getCurrentEntry();
        if (playListEntry != null) {
            playListEntry.setActive(true);
        }
    }

    private synchronized void deactivateCurrentEntry() {
        PlayListEntry playListEntry = this.getCurrentEntry();
        if (playListEntry != null) {
            playListEntry.setActive(false);
        }
    }

    public synchronized boolean setCurrentElement(int n) {
        if (n >= 0 && n < this.size() && n != this.current) {
            PlayListEntry playListEntry = this.getCurrentEntry();
            this.deactivateCurrentEntry();
            this.current = n;
            this.activateCurrentEntry();
            this.fireActiveElementChanged(playListEntry, this.getCurrentEntry());
            return true;
        }
        return false;
    }

    public synchronized void setCurrentElementByTimeIndex(long l) {
        if (this.current == -1 || this.entries == null) {
            return;
        }
        int n = this.current;
        int n2 = this.entries.size() - 1;
        URL uRL = null;
        do {
            PlayListEntry playListEntry = this.entries.get(n);
            if (uRL != null && !Helpers.isEqualURL(uRL, playListEntry.getFile())) {
                return;
            }
            uRL = playListEntry.getFile();
            long l2 = playListEntry.getTimeIndex();
            if (l2 > l) {
                --n;
                continue;
            }
            long l3 = l2 + playListEntry.getDuration();
            if (l3 >= l) break;
            ++n;
        } while (n >= 0 && n <= n2);
        if (n != this.current) {
            this.setCurrentElement(n);
        }
    }

    public synchronized PlayListEntry[] getSelectedEntries() {
        if (this.entries.size() > 0) {
            ArrayList<PlayListEntry> arrayList = new ArrayList<PlayListEntry>(this.entries.size());
            int n = 0;
            while (n < this.entries.size()) {
                PlayListEntry playListEntry = this.entries.get(n);
                if (playListEntry.isSelected()) {
                    arrayList.add(playListEntry);
                }
                ++n;
            }
            if (arrayList.size() > 0) {
                return arrayList.toArray(new PlayListEntry[arrayList.size()]);
            }
        }
        return null;
    }

    public synchronized void addSelectedElement(int n) {
        PlayListEntry playListEntry = this.entries.get(n);
        playListEntry.setSelected(true);
        this.fireSelectedElementChanged(null, playListEntry);
    }

    public synchronized void toggleSelectedElement(int n) {
        PlayListEntry playListEntry;
        playListEntry.setSelected(!(playListEntry = this.entries.get(n)).isSelected());
        this.fireSelectedElementChanged(null, playListEntry);
    }

    public synchronized void setSelectedElement(int n) {
        this.setSelectedElements(n, n);
    }

    public synchronized void setSelectedElements(int n, int n2) {
        int n3;
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        n3 = 0;
        while (n3 < this.entries.size()) {
            PlayListEntry playListEntry = this.entries.get(n3);
            if (playListEntry.isSelected() && (n3 < n || n3 > n2)) {
                playListEntry.setSelected(false);
                this.fireSelectedElementChanged(playListEntry, null);
            } else if (!playListEntry.isSelected() && n3 >= n && n3 <= n2) {
                playListEntry.setSelected(true);
                this.fireSelectedElementChanged(null, playListEntry);
            }
            ++n3;
        }
    }

    public synchronized boolean next() {
        if (this.hasNext()) {
            PlayListEntry playListEntry = this.getCurrentEntry();
            this.deactivateCurrentEntry();
            this.current = this.current >= this.size() - 1 ? 0 : ++this.current;
            this.activateCurrentEntry();
            this.fireActiveElementChanged(playListEntry, this.getCurrentEntry());
            return true;
        }
        return false;
    }

    public synchronized boolean previous() {
        if (this.hasPrevious()) {
            PlayListEntry playListEntry = this.getCurrentEntry();
            this.deactivateCurrentEntry();
            --this.current;
            this.activateCurrentEntry();
            this.fireActiveElementChanged(playListEntry, this.getCurrentEntry());
            return true;
        }
        return false;
    }

    public synchronized boolean hasNext() {
        return this.current < this.size() - 1 || this.repeat;
    }

    public synchronized boolean hasPrevious() {
        return this.current > 0;
    }

    public synchronized int size() {
        return this.entries.size();
    }

    public synchronized int indexOf(PlayListEntry playListEntry) {
        return this.entries.indexOf(playListEntry);
    }

    public synchronized void addAllAt(int n, PlayList playList) {
        ArrayList<PlayListEntry> arrayList = playList.getEntries();
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            arrayList.get(n3).setSavedInPlaylist(this);
            ++n3;
        }
        if (n > this.entries.size()) {
            n = this.entries.size();
        }
        this.entries.addAll(n, arrayList);
        if (this.current >= n) {
            this.current += n2;
        }
    }

    public synchronized void addEntry(PlayListEntry playListEntry) {
        playListEntry.setSavedInPlaylist(this);
        this.entries.add(playListEntry);
    }

    public synchronized void move(int n, int n2) {
        PlayListEntry playListEntry = this.entries.remove(n);
        this.entries.add(n2, playListEntry);
        if (this.current == n) {
            this.current = n2;
        } else if (this.current == n2) {
            ++this.current;
        }
    }

    public synchronized void remove(int n) {
        this.entries.remove(n);
        if (this.current > n && this.current > -1) {
            --this.current;
        } else if (this.current == n) {
            this.current = -1;
        }
    }

    public URL getLoadedFromURL() {
        return this.loadedFromURL;
    }

    private void setLoadedFromURL(URL uRL) {
        this.loadedFromURL = uRL;
    }

    public synchronized void savePlayListTo(File file) throws IOException {
        PrintStream printStream = null;
        try {
            int n;
            String string = file.getAbsolutePath();
            String string2 = string.toLowerCase();
            boolean bl = string2.endsWith("pls");
            boolean bl2 = string2.endsWith("cue");
            if (!(bl || bl2 || string2.endsWith("m3u"))) {
                string = String.valueOf(string) + ".M3U";
                file = new File(string);
            }
            if (file.exists()) {
                n = file.delete();
                if (n != 0) {
                    n = file.createNewFile();
                }
                if (n == 0) {
                    throw new IOException("Could not overwrite file " + string);
                }
            }
            string = string.substring(0, string.lastIndexOf(File.separatorChar) + 1);
            string2 = string.toLowerCase();
            n = string.length();
            CueSheet cueSheet = null;
            CueFile cueFile = null;
            CueTrack cueTrack = null;
            int n2 = 0;
            int n3 = 0;
            if (!bl2) {
                printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                printStream.println(bl ? "[playlist]" : "#EXTM3U");
            } else {
                cueSheet = new CueSheet();
                cueSheet.setCueSheedFileName(Helpers.createURLfromFile(file));
            }
            int n4 = 0;
            while (n4 < this.size()) {
                PlayListEntry playListEntry = this.entries.get(n4);
                URL uRL = playListEntry.getFile();
                if (uRL != null) {
                    Object object;
                    if (bl2 && cueSheet != null) {
                        if (cueFile == null || !Helpers.isEqualURL(cueFile.getFile(), uRL)) {
                            cueFile = new CueFile();
                            cueSheet.addFile(cueFile);
                            cueFile.setFile(uRL);
                            object = Helpers.getExtensionFromURL(uRL).toLowerCase();
                            if (((String)object).equals("mp3")) {
                                cueFile.setType("MP3");
                            } else {
                                cueFile.setType("WAVE");
                            }
                        }
                        if (!playListEntry.getFormattedName().startsWith(INDEX_STRING) || cueTrack == null) {
                            cueTrack = new CueTrack();
                            cueFile.addTrack(cueTrack);
                            cueTrack.setFormat("AUDIO");
                            cueTrack.setTrackNo(++n3);
                            cueTrack.setTitle(playListEntry.getFormattedName());
                            n2 = 0;
                        }
                        object = new CueIndex();
                        ((CueIndex)object).setIndexNo(++n2);
                        ((CueIndex)object).setMillisecondIndex(playListEntry.getTimeIndex());
                        cueTrack.addIndex((CueIndex)object);
                    } else if (printStream != null) {
                        object = Helpers.createLocalFileStringFromURL(uRL, true);
                        if (((String)object).toLowerCase().startsWith(string2)) {
                            object = ((String)object).substring(n);
                        }
                        String string3 = Long.toString(Helpers.getMillisecondsFromTimeString(playListEntry.getDurationString()) / 1000L);
                        if (bl) {
                            String string4 = String.valueOf(Integer.toString(n4 + 1)) + '=';
                            printStream.println("File" + string4 + (String)object);
                            printStream.println("Title" + string4 + playListEntry.getFormattedName());
                            printStream.println("Length" + string4 + string3);
                        } else {
                            printStream.println("#EXTINF:" + string3 + ',' + playListEntry.getFormattedName());
                            printStream.println((String)object);
                        }
                    }
                }
                ++n4;
            }
            if (bl && printStream != null) {
                printStream.println("NumberOfEntries=" + this.size());
                printStream.println("Version=2");
            } else if (bl2 && cueSheet != null) {
                cueSheet.writeCueSheet(file);
            }
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    public synchronized void savePlayListTo(String string) throws IOException {
        this.savePlayListTo(new File(string));
    }

    private static URL[] generateURLListFromFileNames(String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(new File(stringArray[n]));
            ++n;
        }
        return PlayList.generateURLListFromFiles(arrayList.toArray(new File[arrayList.size()]));
    }

    private static URL[] generateURLListFromFiles(File[] fileArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>(fileArray.length);
        int n = 0;
        while (n < fileArray.length) {
            URL uRL = Helpers.createURLfromFile(fileArray[n]);
            if (uRL != null) {
                arrayList.add(uRL);
            }
            ++n;
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private static PlayList readPLSFile(URL uRL, BufferedReader bufferedReader, boolean bl, boolean bl2) throws IOException {
        Object object;
        String string;
        String[] stringArray = null;
        String[] stringArray2 = null;
        URL[] uRLArray = null;
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            if (string.length() == 0) continue;
            string = string.toLowerCase();
            int n2 = string.indexOf(61);
            object = string.substring(n2 + 1);
            if (string.startsWith("numberofentries")) {
                n = Integer.parseInt((String)object);
                stringArray = new String[n];
                stringArray2 = new String[n];
                uRLArray = new URL[n];
                continue;
            }
            if (string.startsWith("file") && uRLArray != null) {
                n = Integer.parseInt(string.substring(4, n2)) - 1;
                uRLArray[n] = Helpers.createAbsolutePathForFile(uRL, (String)object);
                continue;
            }
            if (string.startsWith("title") && stringArray != null) {
                n = Integer.parseInt(string.substring(5, n2)) - 1;
                stringArray[n] = object;
                continue;
            }
            if (!string.startsWith("length") || stringArray2 == null || ((String)object).equals("-1")) continue;
            n = Integer.parseInt(string.substring(6, n2)) - 1;
            stringArray2[n] = object;
        }
        ArrayList<PlayListEntry> arrayList = new ArrayList<PlayListEntry>();
        if (uRLArray != null && stringArray != null && stringArray2 != null) {
            int n = 0;
            while (n < uRLArray.length) {
                PlayListEntry playListEntry = new PlayListEntry(uRLArray[n], null);
                if (stringArray[n] != null && stringArray[n].length() != 0) {
                    playListEntry.setSongName(stringArray[n]);
                }
                if (stringArray2[n] != null && stringArray2[n].length() != 0) {
                    int n3 = Integer.parseInt(stringArray2[n]);
                    playListEntry.setDuration((long)n3 * 1000L);
                }
                arrayList.add(playListEntry);
                ++n;
            }
        }
        if (arrayList.size() > 0) {
            object = new PlayList(arrayList, bl, bl2);
            super.setLoadedFromURL(uRL);
            return object;
        }
        return null;
    }

    private static PlayList readM3UFile(URL uRL, BufferedReader bufferedReader, boolean bl, boolean bl2) throws IOException {
        String string;
        ArrayList<PlayListEntry> arrayList = new ArrayList<PlayListEntry>();
        String string2 = null;
        String string3 = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0 || string.startsWith("#EXTM3U")) continue;
            if (string.startsWith("#EXTINF:")) {
                int n = string.indexOf(44);
                if (n <= -1) continue;
                string3 = string.substring(8, n);
                string2 = string.substring(n + 1);
                continue;
            }
            URL uRL2 = Helpers.createAbsolutePathForFile(uRL, string);
            if (uRL2 == null) {
                uRL2 = Helpers.createURLfromString(string);
            }
            PlayListEntry playListEntry = new PlayListEntry(uRL2, null);
            arrayList.add(playListEntry);
            if (string2 != null && string2.length() != 0) {
                playListEntry.setSongName(string2);
            }
            if (string3 != null && string3.length() != 0) {
                int n = Integer.parseInt(string3);
                playListEntry.setDuration((long)n * 1000L);
            }
            string3 = null;
            string2 = null;
        }
        if (arrayList.size() > 0) {
            PlayList playList = new PlayList(arrayList, bl, bl2);
            playList.setLoadedFromURL(uRL);
            return playList;
        }
        return null;
    }

    private static PlayList readZIPFile(URL uRL, boolean bl, boolean bl2) throws IOException {
        ArrayList<File> arrayList;
        block16: {
            arrayList = new ArrayList<File>();
            ZipInputStream zipInputStream = null;
            try {
                try {
                    ZipEntry zipEntry;
                    File file = new File(uRL.toURI());
                    zipInputStream = new ZipInputStream(uRL.openStream());
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        if (zipEntry.isDirectory()) continue;
                        arrayList.add(new File(String.valueOf(file.getCanonicalPath()) + File.separatorChar + zipEntry.getName()));
                    }
                }
                catch (Throwable throwable) {
                    if (zipInputStream != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (IOException iOException) {
                            Log.error("IGNORED", iOException);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (zipInputStream != null) {
                    try {
                        zipInputStream.close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
                throw throwable;
            }
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
        if (arrayList.size() > 0) {
            return new PlayList(arrayList.toArray(new File[arrayList.size()]), bl, bl2);
        }
        return null;
    }

    private static PlayList readCUEFile(URL uRL, boolean bl, boolean bl2) throws IOException {
        CueSheet cueSheet = CueSheet.createCueSheet(uRL);
        int n = 0;
        ArrayList<CueFile> arrayList = cueSheet.getCueFiles();
        int n2 = arrayList.size();
        if (n2 > 0) {
            ArrayList<PlayListEntry> arrayList2 = new ArrayList<PlayListEntry>();
            int n3 = 0;
            while (n3 < n2) {
                CueFile cueFile = arrayList.get(n3);
                Object[] objectArray = MultimediaContainerManager.getSongInfosFor(cueFile.getFile());
                long l = objectArray[1] != null ? (Long)objectArray[1] : -1L;
                ArrayList<CueTrack> arrayList3 = cueFile.getTracks();
                int n4 = arrayList3.size();
                int n5 = 0;
                while (n5 < n4) {
                    CueTrack cueTrack = arrayList3.get(n5);
                    ArrayList<CueIndex> arrayList4 = cueTrack.getIndexes();
                    int n6 = arrayList4.size();
                    int n7 = 0;
                    while (n7 < n6) {
                        CueIndex cueIndex = arrayList4.get(n7);
                        int n8 = cueIndex.getIndexNo();
                        if (n8 > 0) {
                            PlayListEntry playListEntry;
                            long l2 = cueIndex.getMillisecondIndex();
                            if (n5 > 0) {
                                playListEntry = arrayList2.get(n - 1);
                                long l3 = l2 - playListEntry.getTimeIndex();
                                playListEntry.setDuration(l3);
                                l -= l3;
                            }
                            playListEntry = new PlayListEntry(cueFile.getFile(), null);
                            if (n8 > 1) {
                                playListEntry.setSongName(String.valueOf(INDEX_STRING) + n8);
                            } else {
                                StringBuilder stringBuilder = new StringBuilder();
                                if (cueSheet.getTitle() != null) {
                                    stringBuilder.append(cueSheet.getTitle());
                                }
                                if (cueTrack.getTitle() != null) {
                                    if (stringBuilder.length() > 0) {
                                        stringBuilder.append(" - ");
                                    }
                                    stringBuilder.append(cueTrack.getTitle());
                                }
                                playListEntry.setSongName(stringBuilder.toString());
                            }
                            playListEntry.setTimeIndexInFile(l2);
                            playListEntry.setDuration(l);
                            arrayList2.add(n++, playListEntry);
                        }
                        ++n7;
                    }
                    ++n5;
                }
                ++n3;
            }
            return new PlayList(arrayList2, bl, bl2);
        }
        return null;
    }

    public static PlayList createNewListWithFiles(URL[] uRLArray, boolean bl, boolean bl2) {
        return new PlayList(uRLArray, bl, bl2);
    }

    public static PlayList createNewListWithFile(URL uRL, boolean bl, boolean bl2) {
        return PlayList.createNewListWithFiles(new URL[]{uRL}, bl, bl2);
    }

    public static PlayList createNewListWithFiles(File[] fileArray, boolean bl, boolean bl2) {
        return new PlayList(fileArray, bl, bl2);
    }

    public static PlayList createNewListWithFile(File file, boolean bl, boolean bl2) {
        return PlayList.createNewListWithFiles(new File[]{file}, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlayList createFromFile(URL uRL, boolean bl, boolean bl2) throws IOException {
        PlayList playList = null;
        String string = uRL.getPath().toLowerCase();
        if (string.endsWith(".zip")) {
            return PlayList.readZIPFile(uRL, bl, bl2);
        }
        if (string.endsWith(".cue")) {
            return PlayList.readCUEFile(uRL, bl, bl2);
        }
        if (!PlayList.isPlaylistFile(uRL)) return PlayList.createNewListWithFile(uRL, bl, bl2);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string2 = bufferedReader.readLine();
            if (string2 == null) return playList;
            if ((string2 = string2.trim()).equalsIgnoreCase("[playlist]")) {
                playList = PlayList.readPLSFile(uRL, bufferedReader, bl, bl2);
                return playList;
            } else {
                if (!string2.equalsIgnoreCase("#EXTM3U")) throw new IllegalArgumentException("Unsupported Playlist File: " + uRL.toString());
                playList = PlayList.readM3UFile(uRL, bufferedReader, bl, bl2);
            }
            return playList;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
    }

    public static PlayList createFromFile(File file, boolean bl, boolean bl2) throws IOException {
        return PlayList.createFromFile(file.toURI().toURL(), bl, bl2);
    }

    public static PlayList createFromFile(String string, boolean bl, boolean bl2) throws IOException {
        return PlayList.createFromFile(new File(string), bl, bl2);
    }

    public static boolean isPlaylistFile(URL uRL) {
        return PlayList.isPlaylistFile(uRL.getPath().toLowerCase());
    }

    public static boolean isPlaylistFile(String string) {
        int n = 0;
        while (n < SUPPORTEDPLAYLISTS.length) {
            if (string.endsWith(String.valueOf('.') + SUPPORTEDPLAYLISTS[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String getFileChooserDescription() {
        StringBuilder stringBuilder = new StringBuilder("Playlist (");
        int n = 0;
        while (n < SUPPORTEDPLAYLISTS.length) {
            stringBuilder.append("*.").append(SUPPORTEDPLAYLISTS[n]);
            if (n < SUPPORTEDPLAYLISTS.length - 1) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static String getFileChooserSaveDescription() {
        StringBuilder stringBuilder = new StringBuilder("Playlist (");
        int n = 0;
        while (n < SUPPORTEDSAVELISTS.length) {
            stringBuilder.append("*.").append(SUPPORTEDSAVELISTS[n]);
            if (n < SUPPORTEDSAVELISTS.length - 1) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public synchronized Iterator<PlayListEntry> getIterator() {
        return this.entries.iterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            stringBuilder.append('[').append(this.entries.get(n2)).append(']');
            if (n2 < n) {
                stringBuilder.append(',');
            }
            ++n2;
        }
        return stringBuilder.toString();
    }
}

