/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui.components;

import de.quippy.javamod.system.Log;
import javax.swing.JPanel;

public abstract class ThreadUpdatePanel
extends JPanel {
    private static final long serialVersionUID = 499420014207584726L;
    private volatile boolean threadRunning;
    private volatile int pause;
    private final int desiredFPS;
    private final MeterUpdateThread uiUpdateThread;
    private final long nanoWait;

    public ThreadUpdatePanel(int n) {
        this.desiredFPS = n;
        this.nanoWait = 1000000000L / (long)n;
        this.uiUpdateThread = new MeterUpdateThread(this);
    }

    protected void startThread() {
        this.threadRunning = true;
        this.uiUpdateThread.start();
    }

    public void pauseThread() {
        if (this.pause == 0) {
            this.pause = 1;
            while (this.pause == 1) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void unPauseThread() {
        this.pause = 0;
    }

    protected void stopThread() {
        this.threadRunning = false;
    }

    public int getDesiredFPS() {
        return this.desiredFPS;
    }

    protected abstract void doThreadUpdate();

    private static final class MeterUpdateThread
    extends Thread {
        private final ThreadUpdatePanel me;

        public MeterUpdateThread(ThreadUpdatePanel threadUpdatePanel) {
            this.me = threadUpdatePanel;
            this.setName("ThreadUpdatePanel::" + threadUpdatePanel.getClass().getName());
            this.setDaemon(true);
            this.setPriority(10);
        }

        @Override
        public void run() {
            while (this.me.threadRunning) {
                long l = System.nanoTime();
                try {
                    this.me.doThreadUpdate();
                }
                catch (Throwable throwable) {
                    Log.error(this.getName(), throwable);
                }
                long l2 = this.me.nanoWait - (System.nanoTime() - l);
                if (l2 > 0L) {
                    try {
                        Thread.sleep(l2 / 1000000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.me.pause != 1) continue;
                this.me.pause = 2;
                while (this.me.pause == 2) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

