/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SimpleTextViewerDialog
extends JDialog {
    private static final long serialVersionUID = -5666092255473846658L;
    private JButton closeButton;
    private JScrollPane scrollPane;
    private JTextArea textArea;
    private URL url;

    public SimpleTextViewerDialog(JFrame jFrame, boolean bl, URL uRL) {
        super((Frame)jFrame, bl);
        this.url = uRL;
        this.initialize();
    }

    public SimpleTextViewerDialog(JFrame jFrame, boolean bl, String string) {
        this(jFrame, bl);
        this.setDisplayTextFromURL(string);
    }

    public SimpleTextViewerDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.url = null;
        this.initialize();
    }

    private void initialize() {
        this.setTitle("File Viewer");
        this.setName("SimpleTextFileViewer");
        this.setSize(new Dimension(640, 480));
        this.setPreferredSize(this.getSize());
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SimpleTextViewerDialog.this.doClose();
            }
        });
        this.setLayout(new GridBagLayout());
        Container container = this.getContentPane();
        container.add((Component)this.getScrollPane(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 17, 1.0, 1.0));
        container.add((Component)this.getCloseButton(), Helpers.getGridBagConstraint(0, 1, 1, 0, 0, 10, 0.0, 0.0));
        if (this.url != null) {
            this.fillTextArea();
        }
        this.pack();
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setName("scrollPane_TextField");
            this.scrollPane.setViewportView(this.getTextArea());
        }
        return this.scrollPane;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setName("modInfo_Instruments");
            this.textArea.setEditable(false);
            this.textArea.setFont(Helpers.getTextAreaFont());
        }
        return this.textArea;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setMnemonic('C');
            this.closeButton.setText("Close");
            this.closeButton.setToolTipText("Close");
            this.closeButton.setFont(Helpers.DIALOG_FONT);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SimpleTextViewerDialog.this.doClose();
                }
            });
        }
        return this.closeButton;
    }

    public void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void fillTextArea() {
        block14: {
            if (this.url != null) {
                BufferedReader bufferedReader = null;
                try {
                    try {
                        String string;
                        bufferedReader = new BufferedReader(new InputStreamReader(this.url.openStream()));
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((string = bufferedReader.readLine()) != null) {
                            stringBuilder.append(string).append('\n');
                        }
                        this.getTextArea().setText(stringBuilder.toString());
                        this.getTextArea().select(0, 0);
                    }
                    catch (Throwable throwable) {
                        Log.error("reading text failed", throwable);
                        if (bufferedReader == null) break block14;
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            Log.error("IGNORED", iOException);
                        }
                    }
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            Log.error("IGNORED", iOException);
                        }
                    }
                }
            }
        }
    }

    public void setDisplayTextFromURL(URL uRL) {
        this.url = uRL;
        this.fillTextArea();
    }

    public void setDisplayTextFromURL(String string) {
        try {
            this.url = new URL(string);
            this.fillTextArea();
        }
        catch (MalformedURLException malformedURLException) {
            Log.error("url not correct", malformedURLException);
        }
    }
}

