/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main;

import de.quippy.javamod.main.JavaModMainBase;
import de.quippy.javamod.main.gui.PlayThread;
import de.quippy.javamod.main.gui.PlayThreadEventListener;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.mod.ModContainer;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class CommandLine
extends JavaModMainBase
implements PlayThreadEventListener {
    private URL modFileName;
    private File wavFileName;
    private boolean shuffle;
    private boolean repeat;
    private float initialVolume = 1.0f;
    private MultimediaContainer currentContainer;
    private PlayThread playerThread = null;
    private PlayList currentPlayList = null;

    public CommandLine() {
        super(false);
    }

    private static void showHelp() {
        Log.info("java -jar ./javamod [-rx] [-b{8,16,24}] [-s{+,-}] [-i{+,-}] [-w{+,-}] [-n{+,-}] [-m{+,-}] [-l{+,-}] [-h{+,-}] [-j{+,-}] [-v0.0-1.0]");
        Log.info("                    [-eWAVFILE] MODFILE\n");
        Log.info("-rx        : use Samplerate x (8000/11025/22050/44100/96000...");
        Log.info("                               anything allowed, your soundhardware supports)");
        Log.info("-b8/16/24  : #Bits per sample");
        Log.info("-s+/-      : Stereo/Mono");
        Log.info("-i0/1/2/3  : interpolation: 0:none; 1:linear; 2:cubic spline; 3:fir interpolation");
        Log.info("-w+/-      : do/don't wide stereo mix");
        Log.info("-n+/-      : do/don't noise reduction");
        Log.info("-m+/-      : do/don't mega bass");
        Log.info("-l0/1/2    : set infinit loop handling: 0:original; 1:fade out; 2:ignore");
        Log.info("-h+/-      : do/don't shuffle playlists after loading");
        Log.info("-j+/-      : do/don't repeat playlist");
        Log.info("-v0.0-1.0  : set volume");
        Log.info("-eWAVEFILE : export to wave file");
    }

    private void parseParameters(String[] stringArray) {
        Properties properties = new Properties();
        int n = 0;
        while (n < stringArray.length) {
            block21: {
                String string;
                block20: {
                    if (!stringArray[n].startsWith("-")) break block20;
                    string = stringArray[n].substring(2);
                    switch (stringArray[n].toLowerCase().charAt(1)) {
                        case 'i': {
                            properties.setProperty("javamod.player.ISP", Integer.toString(Integer.parseInt(string.substring(0, 1))));
                            break block21;
                        }
                        case 's': {
                            properties.setProperty("javamod.player.stereo", string.charAt(0) == '+' ? "2" : "1");
                            break block21;
                        }
                        case 'w': {
                            properties.setProperty("javamod.player.widestereomix", string.charAt(0) == '+' ? "TRUE" : "FALSE");
                            break block21;
                        }
                        case 'n': {
                            properties.setProperty("javamod.player.noisereduction", string.charAt(0) == '+' ? "TRUE" : "FALSE");
                            break block21;
                        }
                        case 'm': {
                            properties.setProperty("javamod.player.megabass", string.charAt(0) == '+' ? "TRUE" : "FALSE");
                            break block21;
                        }
                        case 'l': {
                            properties.setProperty("javamod.player.noloops", Integer.toString(Integer.parseInt(string.substring(0, 1))));
                            break block21;
                        }
                        case 'h': {
                            this.shuffle = string.charAt(0) == '+';
                            break block21;
                        }
                        case 'j': {
                            this.repeat = string.charAt(0) == '+';
                            break block21;
                        }
                        case 'b': {
                            int n2 = Integer.parseInt(string);
                            if (n2 != 8 && n2 != 16 && n2 != 24) {
                                throw new RuntimeException("samplesize of " + n2 + " is not supported");
                            }
                            properties.setProperty("javamod.player.bitspersample", Integer.toString(n2));
                            break block21;
                        }
                        case 'r': {
                            properties.setProperty("javamod.player.frequency", Integer.toString(Integer.parseInt(string)));
                            break block21;
                        }
                        case 'e': {
                            this.wavFileName = new File(string);
                            break block21;
                        }
                        case 'v': {
                            this.initialVolume = Float.parseFloat(string);
                        }
                        default: {
                            throw new RuntimeException("Unknown parameter: " + stringArray[n].charAt(1));
                        }
                    }
                }
                string = stringArray[n];
                try {
                    this.modFileName = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        this.modFileName = new File(string).toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException2) {
                        Log.error("This is not parsable: " + string, malformedURLException);
                        System.exit(-1);
                    }
                }
            }
            ++n;
        }
        MultimediaContainerManager.configureContainer(properties);
    }

    @Override
    public void playThreadEventOccured(PlayThread playThread) {
        if (!playThread.isRunning() && playThread.getHasFinishedNormaly()) {
            if (this.currentPlayList != null && this.currentPlayList.next()) {
                this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
            } else {
                System.exit(0);
            }
        }
    }

    private void doStartPlaying() {
        if (this.currentContainer != null) {
            this.doStopPlaying();
            if (this.currentContainer instanceof ModContainer) {
                System.out.println(((ModContainer)this.currentContainer).getCurrentMod().toString());
            }
            Mixer mixer = this.createNewMixer();
            mixer.setExportFile(this.wavFileName);
            this.playerThread = new PlayThread(mixer, this);
            this.playerThread.start();
        }
    }

    private void doStopPlaying() {
        if (this.playerThread != null) {
            this.playerThread.stopMod();
            this.playerThread = null;
        }
    }

    private Mixer createNewMixer() {
        Mixer mixer = this.currentContainer.createNewMixer();
        if (mixer != null) {
            mixer.setVolume(this.initialVolume);
        }
        return mixer;
    }

    private void loadMultimediaOrPlayListFile(URL uRL) {
        this.currentPlayList = null;
        try {
            if (PlayList.isPlaylistFile(uRL)) {
                this.currentPlayList = PlayList.createFromFile(uRL, this.shuffle, this.repeat);
                if (this.currentPlayList.next()) {
                    uRL = this.currentPlayList.getCurrentEntry().getFile();
                }
            }
            if (uRL != null) {
                this.loadMultimediaFile(uRL);
            }
        }
        catch (Throwable throwable) {
            Log.error("[MainForm::loadMultimediaOrPlayListFile]", throwable);
            this.currentPlayList = null;
        }
    }

    private void loadMultimediaFile(URL uRL) {
        try {
            try {
                MultimediaContainer multimediaContainer;
                if (uRL != null && (multimediaContainer = MultimediaContainerManager.getMultimediaContainer(uRL)) != null) {
                    this.currentContainer = multimediaContainer;
                }
            }
            catch (Throwable throwable) {
                Log.error("[MainForm::loadMultimediaFile] Loading of " + uRL + " failed!", throwable);
                this.currentContainer = null;
                if (this.playerThread != null) {
                    this.doStartPlaying();
                }
            }
        }
        finally {
            if (this.playerThread != null) {
                this.doStartPlaying();
            }
        }
    }

    public static void main(String[] stringArray) {
        block4: {
            Log.info("Java Mod Player V2.0 \u00a9 by Daniel Becker since 2006\n");
            try {
                if (stringArray.length == 0) {
                    CommandLine.showHelp();
                    break block4;
                }
                CommandLine commandLine = new CommandLine();
                commandLine.parseParameters(stringArray);
                commandLine.loadMultimediaOrPlayListFile(commandLine.modFileName);
                commandLine.doStartPlaying();
                while (true) {
                    Thread.sleep(1L);
                }
            }
            catch (Exception exception) {
                Log.error("Error occured:", exception);
                CommandLine.showHelp();
                System.exit(-1);
            }
        }
    }
}

