/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.qtcomponents;

import com.apple.mrj.macos.carbon.CarbonAccess;
import com.apple.mrj.macos.carbon.CarbonEventClient;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTNullPointerException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.io.AliasHandle;
import quicktime.io.QTFile;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.comp.Component;
import quicktime.std.comp.ComponentIdentifier;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieProgress;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.qtcomponents.MovieImportInfo;
import quicktime.std.qtcomponents.QTCompDispatcher;
import quicktime.util.QTHandleRef;
import quicktime.util.QTUtils;
import quicktime.util.StringHandle;

public final class MovieImporter
extends Component
implements QuickTimeLib {
    private static Object linkage;
    private QTCompDispatcher progUPP;
    private static Object dontOpenComponent;
    int res = 0;
    static /* synthetic */ Class class$quicktime$std$qtcomponents$MovieImporter;

    public static MovieImporter fromTrack(Track track) throws StdQTException {
        int n = MovieImporter.IsScrapMovie(QTObject.ID(track));
        StdQTException.checkError(MovieImporter.GetMoviesError());
        return new MovieImporter(n, null);
    }

    private MovieImporter(int n, Object object) throws StdQTException {
        super(n, object);
    }

    public MovieImporter() throws QTException {
        this(0);
    }

    public MovieImporter(int n) throws QTException {
        super(1700885536, n);
    }

    public MovieImporter(ComponentIdentifier componentIdentifier) throws QTException {
        super(componentIdentifier, 1700885536);
    }

    public MovieImporter(DataRef dataRef, int n) throws QTException {
        this(MovieImporter.allocate(dataRef, n), dontOpenComponent);
    }

    public MovieImporter(DataRef dataRef, int n, String string) throws QTException {
        this(MovieImporter.allocate(dataRef, n, string), dontOpenComponent);
    }

    private static int allocate(DataRef dataRef, int n) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(MovieImporter.GetMovieImporterForDataRef(dataRef.getType(), QTObject.ID(dataRef), n, nArray));
        return nArray[0];
    }

    private static int allocate(DataRef dataRef, int n, String string) throws QTException {
        int[] nArray = new int[]{0};
        StringHandle stringHandle = new StringHandle("X." + string, 2);
        dataRef.concatenate(stringHandle);
        StdQTException.checkError(MovieImporter.GetMovieImporterForDataRef(dataRef.getType(), QTObject.ID(dataRef), n, nArray));
        return nArray[0];
    }

    public MovieImportInfo fromFile(QTFile qTFile, Movie movie, Track track, int n, int n2) throws QTException {
        if (this.progUPP != null) {
            this.progUPP.theCurrentMov = movie;
        }
        return Track.fromMovieImporterFile(this, qTFile, movie, track, n, n2);
    }

    public MovieImportInfo fromHandle(QTHandleRef qTHandleRef, Movie movie, Track track, int n, int n2) throws QTException {
        if (this.progUPP != null) {
            this.progUPP.theCurrentMov = movie;
        }
        return Track.fromMovieImporterHandle(this, qTHandleRef, movie, track, n, n2);
    }

    public MovieImportInfo fromDataRef(DataRef dataRef, Movie movie, Track track, int n, int n2) throws QTException {
        if (this.progUPP != null) {
            this.progUPP.theCurrentMov = movie;
        }
        return Track.fromMovieImporterDataRef(this, dataRef, movie, track, n, n2);
    }

    public void setSampleDuration(int n, int n2) throws StdQTException {
        int n3 = MovieImporter.MovieImportSetSampleDuration(this._ID(), n, n2);
        StdQTException.checkError(n3);
    }

    public void setSampleDescription(SampleDescription sampleDescription, int n) throws StdQTException {
        int n2 = MovieImporter.MovieImportSetSampleDescription(this._ID(), QTObject.ID(sampleDescription), n);
        StdQTException.checkError(n2);
    }

    public void setMediaFile(AliasHandle aliasHandle) throws QTException {
        int n = MovieImporter.MovieImportSetMediaFile(this._ID(), QTObject.ID(aliasHandle));
        StdQTException.checkError(n);
    }

    public void setDimensions(float f, float f2) throws StdQTException {
        int n = MovieImporter.MovieImportSetDimensions(this._ID(), QTUtils.X2Fix(f), QTUtils.X2Fix(f2));
        StdQTException.checkError(n);
    }

    public void setChunkSize(int n) throws StdQTException {
        int n2 = MovieImporter.MovieImportSetChunkSize(this._ID(), n);
        StdQTException.checkError(n2);
    }

    public void setProgressProc(MovieProgress movieProgress) throws StdQTException {
        if (movieProgress == null) {
            this.removeProgressProc();
            return;
        }
        if (this.progUPP != null) {
            this.removeProgressProc();
        }
        this.progUPP = new QTCompDispatcher(movieProgress);
        int n = MovieImporter.MovieImportSetProgressProc(this._ID(), this.progUPP.ID(), 0);
        StdQTException.checkError(n);
    }

    public void removeProgressProc() throws StdQTException {
        int n = MovieImporter.MovieImportSetProgressProc(this._ID(), 0, 0);
        if (this.progUPP != null) {
            this.progUPP.cleanupMethodClosure();
            this.progUPP = null;
        }
        StdQTException.checkError(n);
    }

    public void setAuxiliaryData(QTHandleRef qTHandleRef, int n) throws StdQTException {
        int n2 = MovieImporter.MovieImportSetAuxiliaryData(this._ID(), QTObject.ID(qTHandleRef), n);
        StdQTException.checkError(n2);
    }

    public void setFromScrap(boolean bl) throws StdQTException {
        byte by = (byte)(bl ? 1 : 0);
        int n = MovieImporter.MovieImportSetFromScrap(this._ID(), by);
        StdQTException.checkError(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doUserDialog(QTFile qTFile) throws QTException {
        final byte[] byArray = new byte[1];
        final byte[] byArray2 = qTFile.getFSSpec(true, 256);
        final int n = this._ID();
        int n2 = 0;
        if (QTSession.isCurrentOS(4)) {
            n2 = (Integer)CarbonAccess.invokeCarbonEventClient(new CarbonEventClient(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object invoke() {
                    int n2 = 0;
                    Object object = QTNative.globalsLock;
                    synchronized (object) {
                        n2 = MovieImporter.MovieImportDoUserDialog(n, byArray2, 0, byArray);
                    }
                    return new Integer(n2);
                }
            });
            StdQTException.checkError(n2);
            return byArray[0] != 0;
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n2 = MovieImporter.MovieImportDoUserDialog(this._ID(), qTFile.getFSSpec(true, 256), 0, byArray);
            StdQTException.checkError(n2);
        }
        return byArray[0] != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doUserDialog(QTHandleRef qTHandleRef) throws QTException {
        byte[] byArray = new byte[1];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            int n = MovieImporter.MovieImportDoUserDialog(this._ID(), null, QTObject.ID(qTHandleRef), byArray);
            StdQTException.checkError(n);
        }
        return byArray[0] != 0;
    }

    public void setDuration(int n) throws StdQTException {
        int n2 = MovieImporter.MovieImportSetDuration(this._ID(), n);
        StdQTException.checkError(n2);
    }

    public int getAuxiliaryDataType() throws StdQTException {
        int[] nArray = new int[1];
        int n = MovieImporter.MovieImportGetAuxiliaryDataType(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public boolean validate(QTFile qTFile) throws QTException {
        byte[] byArray = new byte[1];
        int n = MovieImporter.MovieImportValidate(this._ID(), qTFile.getFSSpec(true, 256), 0, byArray);
        StdQTException.checkError(n);
        return byArray[0] != 0;
    }

    public boolean validate(QTHandleRef qTHandleRef) throws QTException {
        byte[] byArray = new byte[1];
        int n = MovieImporter.MovieImportValidate(this._ID(), null, QTObject.ID(qTHandleRef), byArray);
        StdQTException.checkError(n);
        return byArray[0] != 0;
    }

    public int getFileType() throws StdQTException {
        int[] nArray = new int[1];
        int n = MovieImporter.MovieImportGetFileType(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public SampleDescription getSampleDescription() throws StdQTException {
        return SampleDescription.fromMovieImporter(this);
    }

    public int getMediaType() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = MovieImporter.MovieImportGetSampleDescription(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray2[0];
    }

    public AtomContainer getMIMETypeList() throws StdQTException {
        return AtomContainer.fromMovieImporterMIME(this);
    }

    public void setOffsetAndLimit(int n, int n2) throws StdQTException {
        StdQTException.checkError(MovieImporter.MovieImportSetOffsetAndLimit(this._ID(), n, n2));
    }

    public void setImportSettingsFromAtomContainer(AtomContainer atomContainer) throws StdQTException {
        int n = MovieImporter.MovieImportSetSettingsFromAtomContainer(this._ID(), QTObject.ID(atomContainer));
        StdQTException.checkError(n);
    }

    public AtomContainer getImportSettingsFromAtomContainer() throws StdQTException {
        return AtomContainer.fromMovieImporterSettings(this);
    }

    public void setNewMovieFlags(int n) throws StdQTException {
        int n2 = MovieImporter.MovieImportSetNewMovieFlags(this._ID(), n);
        StdQTException.checkError(n2);
    }

    protected void _dispose() throws QTException {
        try {
            MovieImporter.MovieImportSetProgressProc(this._ID(), 0, 0);
        }
        catch (QTNullPointerException qTNullPointerException) {
            // empty catch block
        }
        if (this.progUPP != null) {
            this.progUPP.cleanupMethodClosure();
        }
        this.progUPP = null;
    }

    private static native int IsScrapMovie(int var0);

    private static native short GetMoviesError();

    private static native short GetMovieImporterForDataRef(int var0, int var1, int var2, int[] var3);

    private static native int MovieImportSetSampleDuration(int var0, int var1, int var2);

    private static native int MovieImportSetSampleDescription(int var0, int var1, int var2);

    private static native int MovieImportSetMediaFile(int var0, int var1);

    private static native int MovieImportSetDimensions(int var0, int var1, int var2);

    private static native int MovieImportSetChunkSize(int var0, int var1);

    private static native int MovieImportSetProgressProc(int var0, int var1, int var2);

    private static native int MovieImportSetAuxiliaryData(int var0, int var1, int var2);

    private static native int MovieImportSetFromScrap(int var0, byte var1);

    private static native int MovieImportDoUserDialog(int var0, byte[] var1, int var2, byte[] var3);

    private static native int MovieImportSetDuration(int var0, int var1);

    private static native int MovieImportGetAuxiliaryDataType(int var0, int[] var1);

    private static native int MovieImportValidate(int var0, byte[] var1, int var2, byte[] var3);

    private static native int MovieImportGetFileType(int var0, int[] var1);

    private static native int MovieImportGetSampleDescription(int var0, int[] var1, int[] var2);

    private static native int MovieImportSetOffsetAndLimit(int var0, int var1, int var2);

    private static native int MovieImportSetSettingsFromAtomContainer(int var0, int var1);

    private static native int MovieImportSetNewMovieFlags(int var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$qtcomponents$MovieImporter == null ? (class$quicktime$std$qtcomponents$MovieImporter = MovieImporter.class$("quicktime.std.qtcomponents.MovieImporter")) : class$quicktime$std$qtcomponents$MovieImporter);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        dontOpenComponent = new Object();
    }
}

