/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import quicktime.std.StdQTException;
import quicktime.std.music.QTMIDIPort;
import quicktime.util.QTHandleRef;

public final class QTMIDIPortList
extends QTHandleRef
implements Cloneable {
    QTMIDIPortList(int n) {
        super(n, null, false);
    }

    public int getLength() {
        return this.getShortAt(0);
    }

    public QTMIDIPort getPort(int n) throws StdQTException {
        if (n > this.getShortAt(0)) {
            StdQTException.checkError(-2075);
        }
        QTMIDIPort qTMIDIPort = new QTMIDIPort();
        byte[] byArray = qTMIDIPort.getBytes();
        int n2 = 2 + --n * 96;
        for (int i = 0; i < 96; ++i) {
            byArray[i] = this.getByteAt(i + n2);
        }
        return qTMIDIPort;
    }

    public Object clone() {
        return new QTMIDIPortList(this.makeAndCopyHandle());
    }

    public String toString() {
        return this.getClass().getName() + "[numberOfPorts=" + this.getLength() + "]";
    }
}

