/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.audio;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.audio.ExtendedAudioSpec;
import quicktime.std.movies.media.AudioMediaHandler;
import quicktime.std.movies.media.Media;

public class AudioMediaControl
implements ExtendedAudioSpec {
    protected Media audioMedia;
    protected AudioMediaHandler audioHandler;
    private boolean muted;

    public AudioMediaControl(Media media) throws QTException {
        this(media, (AudioMediaHandler)((Object)media.getHandler()));
    }

    private AudioMediaControl(Media media, AudioMediaHandler audioMediaHandler) throws QTException {
        this.audioMedia = media;
        this.audioHandler = audioMediaHandler;
        this.muted = this.audioMedia.getTrack().getVolume() < 0.0f;
    }

    public Media getMedia() {
        return this.audioMedia;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean bl) throws QTException {
        float f = this.audioMedia.getTrack().getVolume();
        if (bl != this.muted) {
            this.audioMedia.getTrack().setVolume(-f);
            this.muted = bl;
        }
    }

    public float getVolume() throws QTException {
        float f = this.audioMedia.getTrack().getVolume();
        return Math.abs(f);
    }

    public void setVolume(float f) throws QTException {
        if (f < 0.0f) {
            throw new QTException("Illegal volume");
        }
        if (!this.muted) {
            this.audioMedia.getTrack().setVolume(f);
        } else {
            this.audioMedia.getTrack().setVolume(-f);
        }
    }

    public float getBalance() throws QTException {
        return this.audioHandler.getBalance();
    }

    public void setBalance(float f) throws QTException {
        this.audioHandler.setBalance(f);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

