/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor;

public class Curve {
    private short[] samples;
    private String name;

    public static Curve createGammaCurve(double gamma, int samplesCount) {
        short[] samples = new short[samplesCount];
        int whiteLevel = 65535;
        for (int i = 0; i < samples.length; ++i) {
            double r = (double)i / (double)whiteLevel;
            double value = (double)whiteLevel * (r <= 0.018 ? r * gamma : Math.pow(r, gamma) * 1.099 - 0.099);
            if (value > (double)whiteLevel) {
                value = whiteLevel;
            }
            samples[i] = (short)value;
        }
        return new Curve(samples, "Gamma " + gamma);
    }

    public Curve(short[] samples, String name) {
        this.samples = samples;
        this.name = name;
    }

    public short[] getSamples() {
        return this.samples;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxSample() {
        return this.samples[this.samples.length - 1] & 0xFFFF;
    }

    public Curve resize(int newSamplesCount) {
        if (this.samples == null || this.samples.length == newSamplesCount) {
            return this;
        }
        short[] newSamples = new short[newSamplesCount];
        double xScale = (double)(this.samples.length - 1) / (double)(newSamples.length - 1);
        for (int i = 0; i < newSamples.length; ++i) {
            double x = xScale * (double)i;
            int x0 = (int)Math.floor(x);
            int x1 = x0 + 1;
            double delta = x - (double)x0;
            int y0 = this.samples[x0] & 0xFFFF;
            int y1 = x1 < this.samples.length ? this.samples[x1] & 0xFFFF : y0;
            newSamples[i] = (short)(y0 + (int)Math.round((double)(y1 - y0) * delta));
        }
        return new Curve(newSamples, this.name + " interpolated");
    }

    public String toString() {
        if (this.samples == null) {
            return "Curve[name: " + this.name + ", empty]";
        }
        return "Curve[name: " + this.name + ", sample count: " + this.samples.length + ", max: " + this.getMaxSample() + "]";
    }
}

