/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.minolta;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteOrder;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class MinoltaRawData {
    private static final String CLASS = MinoltaRawData.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private int rasterOffset;
    private int baseOffset;
    @CheckForNull
    private PRD prd;
    @CheckForNull
    private RIF rif;
    @CheckForNull
    private WBG wbg;

    public void load(@Nonnull RAWImageInputStream iis, int base, @Nonnull ByteOrder byteOrder) throws IOException {
        long save;
        this.rasterOffset = iis.readInt() + base;
        ByteOrder byteOrderSave = iis.getByteOrder();
        iis.setByteOrder(byteOrder);
        logger.fine(String.format("MRW header at %d (0x%x)", (int)iis.getStreamPosition(), (int)iis.getStreamPosition()), new Object[0]);
        while ((save = iis.getStreamPosition()) < (long)this.rasterOffset) {
            ByteOrder byteOrderSave2 = iis.getByteOrder();
            iis.setByteOrder(ByteOrder.BIG_ENDIAN);
            int tag = iis.readInt();
            iis.setByteOrder(byteOrderSave2);
            int len = iis.readInt();
            logger.fine("MRW header tag 0x%s length: %d", Integer.toHexString(tag), len);
            switch (tag) {
                case 5263940: {
                    this.prd = new PRD();
                    this.prd.load(iis);
                    break;
                }
                case 5718599: {
                    this.wbg = new WBG();
                    this.wbg.load(iis);
                    break;
                }
                case 5392710: {
                    this.rif = new RIF();
                    this.rif.load(iis);
                    break;
                }
                case 0x545457: {
                    this.baseOffset = (int)iis.getStreamPosition();
                    break;
                }
                default: {
                    logger.warning(String.format("Unknown Minolta Raw tag 0x%x", tag), new Object[0]);
                }
            }
            iis.seek(save + (long)len + 8L);
        }
        iis.setByteOrder(byteOrderSave);
    }

    @CheckForNull
    public PRD getPRD() {
        return this.prd;
    }

    @CheckForNull
    public RIF getRIF() {
        return this.rif;
    }

    @CheckForNull
    public WBG getWBG() {
        return this.wbg;
    }

    public int getRasterOffset() {
        return this.rasterOffset;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public static final class RIF
    implements Serializable {
        public static final int TAG = 5392710;
        private int unknown;
        private int saturation;
        private int contrast;
        private int sharpness;
        private int whiteBalance;
        private int subjectProgram;
        private int ccdSensitivity;
        private int colorMode;
        private int colorFilter;
        private int bwFilter;

        public int getBwFilter() {
            return this.bwFilter;
        }

        public int getCcdSensitivity() {
            return this.ccdSensitivity;
        }

        public int getColorFilter() {
            return this.colorFilter;
        }

        public int getColorMode() {
            return this.colorMode;
        }

        public int getContrast() {
            return this.contrast;
        }

        public int getSaturation() {
            return this.saturation;
        }

        public int getSharpness() {
            return this.sharpness;
        }

        public int getSubjectProgram() {
            return this.subjectProgram;
        }

        public int getUnknown() {
            return this.unknown;
        }

        public int getWhiteBalance() {
            return this.whiteBalance;
        }

        private void load(@Nonnull RAWImageInputStream iis) throws IOException {
        }
    }

    public static final class WBG
    implements Serializable {
        public static final int TAG = 5718599;
        private TagRational[] coefficients = new TagRational[4];

        @Nonnull
        public TagRational getRedCoefficient() {
            return this.coefficients[0];
        }

        @Nonnull
        public TagRational getGreen1Coefficient() {
            return this.coefficients[1];
        }

        @Nonnull
        public TagRational getGreen2Coefficient() {
            return this.coefficients[3];
        }

        @Nonnull
        public TagRational getBlueCoefficient() {
            return this.coefficients[2];
        }

        private void load(@Nonnull RAWImageInputStream iis) throws IOException {
            byte[] denominators = new byte[4];
            iis.readFully(denominators);
            int j = 0;
            for (int i = 0; i < 4; ++i) {
                this.coefficients[i ^ i >> 1 ^ j] = new TagRational(iis.readShort(), 64 << denominators[i]);
            }
        }
    }

    public static final class PRD
    implements Serializable {
        public static final int TAG = 5263940;
        private String version;
        @CheckForNull
        private Dimension ccdSize;
        @CheckForNull
        private Dimension imageSize;
        private int dataSize;
        private int pixelSize;
        private int storageMethod;
        private int unknown1;
        private int unknown2;
        private int unknown3;

        public Dimension getCcdSize() {
            return (Dimension)this.ccdSize.clone();
        }

        public int getDataSize() {
            return this.dataSize;
        }

        public Dimension getImageSize() {
            return (Dimension)this.imageSize.clone();
        }

        public int getPixelSize() {
            return this.pixelSize;
        }

        public int getStorageMethod() {
            return this.storageMethod;
        }

        public int getUnknown1() {
            return this.unknown1;
        }

        public int getUnknown2() {
            return this.unknown2;
        }

        public int getUnknown3() {
            return this.unknown3;
        }

        @CheckForNull
        public String getVersion() {
            return this.version;
        }

        private void load(@Nonnull RAWImageInputStream iis) throws IOException {
            byte[] bytes = new byte[8];
            iis.readFully(bytes);
            this.version = new String(bytes);
            int h1 = iis.readShort() & 0xFFFF;
            int w1 = iis.readShort() & 0xFFFF;
            this.ccdSize = new Dimension(w1, h1);
            int h2 = iis.readShort() & 0xFFFF;
            int w2 = iis.readShort() & 0xFFFF;
            this.imageSize = new Dimension(w2, h2);
            this.dataSize = iis.readByte();
            this.pixelSize = iis.readByte();
            this.storageMethod = iis.readByte();
            this.unknown1 = iis.readByte();
            this.unknown2 = iis.readByte();
            this.unknown3 = iis.readByte();
        }
    }
}

