/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.swing;

import java.io.IOException;
import java.io.Writer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class DocumentWriter
extends Writer {
    private Document doc;
    private AttributeSet a;

    public DocumentWriter(Document doc, AttributeSet a) {
        this.doc = doc;
        this.a = a;
    }

    public DocumentWriter(Document doc) {
        this(doc, null);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(new String(cbuf, off, len));
    }

    public void write(String str, int off, int len) throws IOException {
        this.write(str.substring(off, len));
    }

    public void write(String str) throws IOException {
        if (this.doc == null) {
            throw new IOException("Writer was closed");
        }
        try {
            this.doc.insertString(this.doc.getLength(), str, this.a);
        }
        catch (BadLocationException ble) {
            throw new IOException(ble.getMessage());
        }
    }

    public void flush() throws IOException {
        if (this.doc == null) {
            throw new IOException("Writer was closed");
        }
    }

    public void close() throws IOException {
        this.doc = null;
    }
}

