/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.app.VectorListModel;
import com.jhlabs.awt.ParagraphLayout;
import com.jhlabs.awt.SuperGridLayout;
import com.jhlabs.ie.layer.Layer;
import com.jhlabs.image.ColorWell;
import com.jhlabs.image.LightFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import com.jhlabs.math.ImageFunction2D;
import com.jhlabs.swing.SliderFactory;
import com.jhlabs.util.NameValue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LightFilterCustomizer
extends PreviewFilterCustomizer
implements ActionListener,
ChangeListener,
ItemListener,
ListSelectionListener {
    private JSlider azimuth;
    private JSlider elevation;
    private JSlider diffuseReflectivity;
    private JSlider specular;
    private JSlider lightIntensity;
    private JSlider shininess;
    private JSlider reflectivity;
    private JSlider bumpHeight;
    private JSlider bumpSoftness;
    private JSlider viewDistance;
    private JSlider opacity;
    private JSlider distance;
    private JSlider centreX;
    private JSlider centreY;
    private JSlider coneAngle;
    private JSlider focus;
    private ColorWell diffuseColor;
    private ColorWell specularColor;
    private ColorWell lightColor;
    private LightFilter filter;
    private JRadioButton useImageColors;
    private JRadioButton useConstantColors;
    private JPanel colorPanel;
    private JButton textureButton;
    private JButton envButton;
    private JButton newPointButton;
    private JButton newDirButton;
    private JButton newSpotButton;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JRadioButton useImageBumps;
    private JRadioButton useAlphaBumps;
    private JRadioButton useMapBumps;
    private JRadioButton useBevelBumps;
    private JComboBox bumpCombo;
    private JComboBox envCombo;
    private JComboBox bumpShapeCombo;
    private JList lightList;
    private JTabbedPane tabbedPane;
    private JSlider margin;
    private JSlider cornerRadius;
    private JComboBox shapeCombo;
    private JComboBox bevelCombo;
    private VectorListModel model;
    private Insets noInsets = new Insets(0, 0, 0, 0);

    public LightFilterCustomizer() {
        this.tabbedPane = new JTabbedPane();
        JPanel lightPanel = new JPanel();
        lightPanel.setLayout(new BorderLayout());
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        lightPanel.add((Component)listPanel, "West");
        this.lightList = new JList();
        this.lightList.setSelectionMode(0);
        this.lightList.getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.lightList);
        scrollPane.setSize(200, 50);
        listPanel.add((Component)scrollPane, "Center");
        JPanel p3 = new JPanel();
        this.newPointButton = this.makeButton("pointlight.gif", "Create a new point light");
        p3.add(this.newPointButton);
        this.newDirButton = this.makeButton("distantlight.gif", "Create a new distant light");
        p3.add(this.newDirButton);
        this.newSpotButton = this.makeButton("spotlight.gif", "Create a new spot light");
        p3.add(this.newSpotButton);
        this.duplicateButton = this.makeButton("duplicate.gif", "Duplicate the selected light");
        p3.add(this.duplicateButton);
        this.deleteButton = this.makeButton("trash.gif", "Remove the selected light");
        p3.add(this.deleteButton);
        listPanel.add((Component)p3, "South");
        JPanel p = new JPanel();
        lightPanel.add((Component)p, "East");
        SuperGridLayout sgl = new SuperGridLayout(0, 2);
        sgl.setColWeight(1, 1);
        p.setLayout(sgl);
        p.add(new JLabel("Direction:", 4));
        this.azimuth = SliderFactory.create360AngleSlider();
        p.add(this.azimuth);
        this.azimuth.setPaintLabels(false);
        this.azimuth.addChangeListener(this);
        p.add(new JLabel("Elevation:", 4));
        this.elevation = SliderFactory.create90AngleSlider();
        p.add(this.elevation);
        this.elevation.setPaintLabels(false);
        this.elevation.addChangeListener(this);
        p.add(new JLabel("Distance:", 4));
        this.distance = SliderFactory.createPercentageSlider();
        p.add(this.distance);
        this.distance.setPaintLabels(false);
        this.distance.addChangeListener(this);
        p.add(new JLabel("Intensity:", 4));
        this.lightIntensity = SliderFactory.createPercentageSlider();
        p.add(this.lightIntensity);
        this.lightIntensity.setPaintLabels(false);
        this.lightIntensity.addChangeListener(this);
        p.add(new JLabel("X:", 4));
        this.centreX = SliderFactory.createPercentageSlider();
        p.add(this.centreX);
        this.centreX.setPaintLabels(false);
        this.centreX.addChangeListener(this);
        p.add(new JLabel("Y:", 4));
        this.centreY = SliderFactory.createPercentageSlider();
        p.add(this.centreY);
        this.centreY.setPaintLabels(false);
        this.centreY.addChangeListener(this);
        p.add(new JLabel("Cone Angle:", 4));
        this.coneAngle = SliderFactory.create90AngleSlider();
        p.add(this.coneAngle);
        this.coneAngle.setPaintLabels(false);
        this.coneAngle.addChangeListener(this);
        p.add(new JLabel("Focus:", 4));
        this.focus = new JSlider(0, 0, 100, 0);
        p.add(this.focus);
        this.focus.setPaintTicks(true);
        this.focus.setMajorTickSpacing(50);
        this.focus.setMinorTickSpacing(10);
        this.focus.addChangeListener(this);
        p.add(new JLabel("Color:", 4));
        JPanel p5 = new JPanel();
        p5.setLayout(new FlowLayout(0));
        p.add(p5);
        this.lightColor = new ColorWell();
        p5.add(this.lightColor);
        this.lightColor.addChangeListener(this);
        this.tabbedPane.addTab("Lights", lightPanel);
        JPanel p4 = new JPanel();
        p4.setLayout(new BorderLayout());
        JPanel p2 = new JPanel();
        p2.setLayout(new ParagraphLayout());
        ButtonGroup group = new ButtonGroup();
        p2.add((Component)new JLabel("Colors from:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.useImageColors = new JRadioButton("Source Image");
        p2.add(this.useImageColors);
        this.useImageColors.addChangeListener(this);
        group.add(this.useImageColors);
        this.useConstantColors = new JRadioButton("Constant Color:");
        p2.add((Component)this.useConstantColors, ParagraphLayout.NEW_LINE);
        this.useConstantColors.addChangeListener(this);
        group.add(this.useConstantColors);
        p2.add(new JLabel("Diffuse Color:", 4));
        this.diffuseColor = new ColorWell();
        p2.add(this.diffuseColor);
        this.diffuseColor.addChangeListener(this);
        p2.add(new JLabel("Specular Color:", 4));
        this.specularColor = new ColorWell();
        p2.add(this.specularColor);
        this.specularColor.addChangeListener(this);
        p4.add((Component)p2, "North");
        p = new JPanel();
        p.setLayout(new ParagraphLayout());
        p4.add((Component)p, "Center");
        p.add((Component)new JLabel("Shininess:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.shininess = SliderFactory.createPercentageSlider();
        p.add(this.shininess);
        this.shininess.setPaintLabels(false);
        this.shininess.addChangeListener(this);
        p.add((Component)new JLabel("Opacity:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.opacity = SliderFactory.createPercentageSlider();
        p.add(this.opacity);
        this.opacity.setPaintLabels(false);
        this.opacity.addChangeListener(this);
        p.add((Component)new JLabel("Reflectivity:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.reflectivity = SliderFactory.createPercentageSlider();
        p.add(this.reflectivity);
        this.reflectivity.setPaintLabels(false);
        this.reflectivity.addChangeListener(this);
        p.add((Component)new JLabel("Environment Map:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.envCombo = new JComboBox();
        p.add(this.envCombo);
        this.envCombo.addItemListener(this);
        this.tabbedPane.addTab("Material", p4);
        p = new JPanel();
        p.setLayout(new ParagraphLayout());
        group = new ButtonGroup();
        p.add((Component)new JLabel("Bumps from:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.useImageBumps = new JRadioButton("From Image");
        p.add(this.useImageBumps);
        this.useImageBumps.addChangeListener(this);
        group.add(this.useImageBumps);
        this.useAlphaBumps = new JRadioButton("From Image Transparency");
        p.add((Component)this.useAlphaBumps, ParagraphLayout.NEW_LINE);
        this.useAlphaBumps.addChangeListener(this);
        group.add(this.useAlphaBumps);
        this.useMapBumps = new JRadioButton("From Bump Map:");
        p.add((Component)this.useMapBumps, ParagraphLayout.NEW_LINE);
        this.useMapBumps.addChangeListener(this);
        group.add(this.useMapBumps);
        this.bumpCombo = new JComboBox();
        p.add(this.bumpCombo);
        this.bumpCombo.addItemListener(this);
        p.add((Component)new JLabel("Bump Shape:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.bumpShapeCombo = new JComboBox();
        p.add(this.bumpShapeCombo);
        this.bumpShapeCombo.addItemListener(this);
        p.add((Component)new JLabel("Bump Height:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.bumpHeight = new JSlider(0, -500, 500, 0);
        p.add(this.bumpHeight);
        this.bumpHeight.setPaintTicks(true);
        this.bumpHeight.setMajorTickSpacing(250);
        this.bumpHeight.setMinorTickSpacing(50);
        this.bumpHeight.setPaintLabels(true);
        this.bumpHeight.addChangeListener(this);
        p.add((Component)new JLabel("Bump Softness:", 4), ParagraphLayout.NEW_PARAGRAPH);
        this.bumpSoftness = new JSlider(0, 0, 100, 0);
        p.add(this.bumpSoftness);
        this.bumpSoftness.setPaintTicks(true);
        this.bumpSoftness.setMajorTickSpacing(100);
        this.bumpSoftness.setMinorTickSpacing(10);
        this.bumpSoftness.setPaintLabels(true);
        this.bumpSoftness.addChangeListener(this);
        this.tabbedPane.addTab("Bumps", p);
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.setSelectedIndex(0);
    }

    private JButton makeButton(String icon, String tooltip) {
        JButton b = new JButton(this.getImage(icon));
        b.setToolTipText(tooltip);
        b.putClientProperty("Quaqua.Button.style", "square");
        b.setMargin(this.noInsets);
        b.addActionListener(this);
        return b;
    }

    private ImageIcon getImage(String name) {
        return new ImageIcon(this.getClass().getResource(name));
    }

    public void setObject(Object o) {
        super.setObject(o);
        LightFilter filter = (LightFilter)o;
        this.model = new VectorListModel(filter.getLights());
        this.lightList.setModel(this.model);
        this.lightList.setSelectedIndex(0);
        this.shininess.setValue((int)((double)filter.material.highlight * 10.0));
        this.opacity.setValue((int)((double)filter.material.opacity * 100.0));
        this.reflectivity.setValue((int)((double)filter.material.reflectivity * 100.0));
        switch (filter.getColorSource()) {
            case 0: {
                this.useImageColors.setSelected(true);
                break;
            }
            case 1: {
                this.useConstantColors.setSelected(true);
            }
        }
        switch (filter.getBumpSource()) {
            case 0: {
                this.useImageBumps.setSelected(true);
                break;
            }
            case 1: {
                this.useAlphaBumps.setSelected(true);
                break;
            }
            case 2: {
                this.useMapBumps.setSelected(true);
            }
        }
        this.bumpHeight.setValue((int)((double)filter.getBumpHeight() * 100.0));
        this.bumpSoftness.setValue((int)filter.getBumpSoftness());
        this.diffuseColor.setEnabled(this.useConstantColors.isSelected());
        this.specularColor.setEnabled(this.useConstantColors.isSelected());
        this.bumpCombo.removeAllItems();
        this.envCombo.removeAllItems();
        if (this.filterContext != null) {
            Iterator it = this.filterContext.getImages();
            while (it.hasNext()) {
                NameValue nv = (NameValue)it.next();
                this.bumpCombo.addItem(nv);
                this.envCombo.addItem(nv);
            }
        }
        this.bumpShapeCombo.addItem("Normal");
        this.bumpShapeCombo.addItem("Outer");
        this.bumpShapeCombo.addItem("Inner");
        this.bumpShapeCombo.addItem("Pillow");
        this.bumpShapeCombo.addItem("Up");
        this.bumpShapeCombo.addItem("Down");
        this.filter = filter;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source instanceof JSlider && ((JSlider)source).getValueIsAdjusting()) {
                return;
            }
            if (source instanceof JRadioButton && !((JRadioButton)source).isSelected()) {
                return;
            }
            LightFilter.Light light = this.selectedLight();
            if (source == this.reflectivity) {
                this.filter.material.reflectivity = (float)this.reflectivity.getValue() / 100.0f;
            } else if (source == this.opacity) {
                this.filter.material.opacity = (float)this.opacity.getValue() / 100.0f;
            } else if (source == this.shininess) {
                this.filter.material.highlight = (float)this.shininess.getValue() / 10.0f;
            } else if (source == this.useImageColors || source == this.useConstantColors) {
                this.filter.setColorSource(this.useImageColors.isSelected() ? 0 : 1);
            } else if (source == this.bumpHeight) {
                this.filter.setBumpHeight((float)this.bumpHeight.getValue() / 100.0f);
            } else if (source == this.bumpSoftness) {
                this.filter.setBumpSoftness(this.bumpSoftness.getValue());
            } else if (source == this.diffuseColor) {
                this.filter.material.diffuseColor = this.diffuseColor.getRGB();
            } else if (source == this.specularColor) {
                this.filter.material.specularColor = this.specularColor.getRGB();
            } else if (source == this.useImageBumps || source == this.useAlphaBumps || source == this.useMapBumps || source == this.useBevelBumps) {
                this.filter.setBumpSource(this.useImageBumps.isSelected() ? 0 : (this.useAlphaBumps.isSelected() ? 1 : (this.useMapBumps.isSelected() ? 2 : 3)));
            } else if (light != null) {
                if (source == this.azimuth) {
                    light.setAzimuth((float)this.azimuth.getValue() * (float)Math.PI / 180.0f);
                } else if (source == this.elevation) {
                    light.setElevation((float)this.elevation.getValue() * (float)Math.PI / 180.0f);
                } else if (source == this.distance) {
                    light.setDistance((float)this.distance.getValue() * 10.0f);
                } else if (source == this.lightIntensity) {
                    light.setIntensity((float)this.lightIntensity.getValue() / 100.0f);
                } else if (source == this.centreX) {
                    light.setCentreX((float)this.centreX.getValue() / 100.0f);
                } else if (source == this.centreY) {
                    light.setCentreY((float)this.centreY.getValue() / 100.0f);
                } else if (source == this.coneAngle) {
                    light.setConeAngle((float)this.coneAngle.getValue() * (float)Math.PI / 180.0f);
                } else if (source == this.focus) {
                    light.setFocus((float)this.focus.getValue() / 100.0f);
                } else if (source == this.lightColor) {
                    light.setColor(this.lightColor.getRGB());
                }
            }
            this.preview();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (this.filter != null) {
            if (source == this.bumpCombo) {
                NameValue nv = (NameValue)this.bumpCombo.getSelectedItem();
                BufferedImage texture = ((Layer)nv.getValue()).getImage();
                if (texture != null) {
                    ImageFunction2D f = new ImageFunction2D(texture, 2, false);
                    this.filter.setBumpFunction(f);
                    this.preview();
                }
            } else if (source == this.envCombo) {
                NameValue nv = (NameValue)this.envCombo.getSelectedItem();
                BufferedImage texture = ((Layer)nv.getValue()).getImage();
                if (texture != null) {
                    ImageFunction2D f = new ImageFunction2D(texture, 2, false);
                    this.filter.setEnvironmentMap(texture);
                    this.preview();
                }
            } else if (source == this.bumpShapeCombo) {
                this.filter.setBumpShape(this.bumpShapeCombo.getSelectedIndex());
                this.preview();
            }
            this.preview();
        }
    }

    private LightFilter.Light selectedLight() {
        return (LightFilter.Light)this.lightList.getSelectedValue();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.lightSelected();
    }

    private void lightSelected() {
        LightFilter.Light light = this.selectedLight();
        LightFilter saveFilter = this.filter;
        this.filter = null;
        if (light != null) {
            int index = this.lightList.getLeadSelectionIndex();
            int type = light.type;
            this.duplicateButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.azimuth.setEnabled(type != 0);
            this.elevation.setEnabled(type != 0);
            this.distance.setEnabled(type != 0);
            this.centreX.setEnabled(type >= 2);
            this.centreY.setEnabled(type >= 2);
            this.coneAngle.setEnabled(type == 3);
            this.focus.setEnabled(type == 3);
            this.azimuth.setValue((int)((double)(light.getAzimuth() * 180.0f) / Math.PI));
            this.elevation.setValue((int)((double)(light.getElevation() * 180.0f) / Math.PI));
            this.distance.setValue((int)((double)light.getCentreX() / 10.0));
            this.centreX.setValue((int)((double)light.getCentreX() * 100.0));
            this.centreY.setValue((int)((double)light.getCentreY() * 100.0));
            this.coneAngle.setValue((int)((double)(light.getConeAngle() * 180.0f) / Math.PI));
            this.focus.setValue((int)((double)light.getFocus() * 100.0));
            this.lightIntensity.setValue((int)((double)light.getIntensity() * 100.0));
            this.lightColor.setColor(new Color(light.getColor()));
        } else {
            this.duplicateButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
        this.filter = saveFilter;
    }

    private void doNew(LightFilter.Light light) {
        Object[] possibleValues = new Object[]{"Ambient Light", "Point Light", "Spot Light"};
        this.model.addElement(light);
        int i = this.lightList.getModel().getSize() - 1;
        this.lightList.setSelectedIndex(i);
        this.lightList.ensureIndexIsVisible(i);
        this.preview();
    }

    private void doDelete() {
        LightFilter.Light light = this.selectedLight();
        if (light != null) {
            int index = this.lightList.getLeadSelectionIndex();
            this.model.removeElement(light);
            int size = this.lightList.getModel().getSize() - 1;
            index = index <= size ? index : size;
            this.lightList.setSelectedIndex(index);
            this.lightList.ensureIndexIsVisible(index);
            this.preview();
        }
    }

    private void doDuplicate() {
        LightFilter.Light light = this.selectedLight();
        if (light != null) {
            this.doNew((LightFilter.Light)light.clone());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.filter != null) {
            Object source = e.getSource();
            if (source == this.deleteButton) {
                this.doDelete();
            } else if (source == this.duplicateButton) {
                this.doDuplicate();
            } else if (source == this.newPointButton) {
                this.doNew(this.filter.new LightFilter.PointLight());
            } else if (source == this.newDirButton) {
                this.doNew(this.filter.new LightFilter.DistantLight());
            } else if (source == this.newSpotButton) {
                this.doNew(this.filter.new LightFilter.SpotLight());
            }
        }
    }
}

