/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Histogram;
import com.jhlabs.image.LevelsFilter;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class LevelsFilterCustomizer
extends PreviewFilterCustomizer
implements ActionListener {
    protected HistogramDisplay graph;
    protected Histogram histogram;
    private JButton autoButton;
    private LevelsFilter filter;

    public LevelsFilterCustomizer() {
        JPanel p = new JPanel();
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        p.setLayout(new BorderLayout());
        this.add((Component)p, "South");
        this.graph = new HistogramDisplay();
        p.add((Component)this.graph, "Center");
    }

    public void setPreviewImage(BufferedImage image) {
        PixelGrabber pg = new PixelGrabber(image, 0, 0, -1, -1, null, 0, -1);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("interrupted waiting for pixels!");
        }
        if ((pg.status() & 0x80) != 0) {
            throw new RuntimeException("image fetch aborted");
        }
        this.histogram = new Histogram((int[])pg.getPixels(), pg.getWidth(), pg.getHeight(), 0, pg.getWidth());
        this.graph.repaint();
    }

    public boolean previewWholeImage() {
        return true;
    }

    public void setObject(Object o) {
        super.setObject(o);
        this.filter = (LevelsFilter)o;
    }

    public void actionPerformed(ActionEvent e) {
        int min = 255;
        int max = 0;
        for (int channel = 0; channel < 3; ++channel) {
            min = Math.min(min, this.histogram.getMinValue(channel));
            max = Math.max(max, this.histogram.getMaxValue(channel));
        }
        this.filter.setLowLevel((float)min / 255.0f);
        this.filter.setLowLevel((float)max / 255.0f);
    }

    class HistogramDisplay
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private static final int MARGIN = 10;
        private static final int INPUT_Y = 36;
        private static final int OUTPUT_Y = 10;
        private boolean displayRGB = true;
        private int dragHandle = -1;

        public HistogramDisplay() {
            this.addMouseListener(this);
        }

        public Dimension getMinimumSize() {
            return new Dimension(276, 66);
        }

        public Dimension getPreferredSize() {
            return new Dimension(276, 200);
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension size = this.getSize();
            int w = size.width;
            int h = size.height;
            int b = h - 36;
            g.setColor(Color.white);
            g.fillRect(11, 1, w -= 20, b);
            g.setColor(Color.black);
            g.drawRect(10, 0, w - 1, b);
            if (LevelsFilterCustomizer.this.histogram != null) {
                if (this.displayRGB) {
                    int channel;
                    int max = 0;
                    for (channel = 0; channel <= 2; ++channel) {
                        max = Math.max(max, LevelsFilterCustomizer.this.histogram.getMaxFrequency(channel));
                    }
                    g2d.setComposite(AlphaComposite.getInstance(3, 0.6f));
                    for (channel = 0; channel <= 2; ++channel) {
                        g.setColor(channel == 0 ? Color.red : (channel == 1 ? Color.green : Color.blue));
                        for (int x = 0; x < 256; ++x) {
                            int y = LevelsFilterCustomizer.this.histogram.getFrequency(channel, x) * h / max;
                            g.drawLine(x + 10, b, x + 10, b - y);
                        }
                    }
                } else {
                    g.setColor(Color.black);
                    int channel = 0;
                    int max = LevelsFilterCustomizer.this.histogram.getMaxFrequency(channel);
                    for (int x = 0; x < 256; ++x) {
                        int y = LevelsFilterCustomizer.this.histogram.getFrequency(channel, x) * h / max;
                        g.drawLine(x + 10, b, x + 10, b - y);
                    }
                }
            }
            g2d.setPaint(new GradientPaint(10.0f, 0.0f, Color.black, w, 0.0f, Color.white));
            g2d.fillRect(10, h - 10 - 10, w, 10);
            g2d.setColor(Color.black);
            g2d.drawRect(10, h - 10 - 10, w - 1, 10);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(Color.black);
            int y = h - 36 + 10;
            int x = 10 + (int)((float)w * LevelsFilterCustomizer.this.filter.getLowLevel());
            g2d.fillPolygon(new int[]{x - 6, x, x + 6}, new int[]{y - 2, y - 7, y - 2}, 3);
            x = 10 + (int)((float)w * LevelsFilterCustomizer.this.filter.getHighLevel());
            g2d.fillPolygon(new int[]{x - 6, x, x + 6}, new int[]{y - 2, y - 7, y - 2}, 3);
            y = h - 10 + 10;
            x = 10 + (int)((float)w * LevelsFilterCustomizer.this.filter.getLowOutputLevel());
            g2d.fillPolygon(new int[]{x - 6, x, x + 6}, new int[]{y - 2, y - 7, y - 2}, 3);
            x = 10 + (int)((float)w * LevelsFilterCustomizer.this.filter.getHighOutputLevel());
            g2d.fillPolygon(new int[]{x - 6, x, x + 6}, new int[]{y - 2, y - 7, y - 2}, 3);
        }

        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Dimension size = this.getSize();
            if (y >= size.height - 36) {
                int w = size.width - 20;
                this.dragHandle = (x -= 10) > 5 && y >= size.height - 10 && Math.abs((float)x - (float)w * LevelsFilterCustomizer.this.filter.getLowOutputLevel()) <= 5.0f ? 2 : (y >= size.height - 10 && Math.abs((float)x - (float)w * LevelsFilterCustomizer.this.filter.getHighOutputLevel()) <= 5.0f ? 3 : (y >= size.height - 10 && Math.abs((float)x - (float)w * LevelsFilterCustomizer.this.filter.getLowOutputLevel()) <= 5.0f ? 2 : (x > 5 && Math.abs((float)x - (float)w * LevelsFilterCustomizer.this.filter.getLowLevel()) <= 5.0f ? 0 : (Math.abs((float)x - (float)w * LevelsFilterCustomizer.this.filter.getHighLevel()) <= 5.0f ? 1 : (Math.abs((float)x - (float)w * LevelsFilterCustomizer.this.filter.getLowLevel()) <= 5.0f ? 0 : -1)))));
                if (this.dragHandle != -1) {
                    this.addMouseMotionListener(this);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragHandle != -1) {
                this.removeMouseMotionListener(this);
                LevelsFilterCustomizer.this.preview();
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Dimension size = this.getSize();
            int w = size.width - 20;
            float v = Math.max(0.0f, Math.min(1.0f, (float)(x - 10) / (float)w));
            if (this.dragHandle == 0) {
                LevelsFilterCustomizer.this.filter.setLowLevel(Math.min(LevelsFilterCustomizer.this.filter.getHighLevel(), v));
            } else if (this.dragHandle == 1) {
                LevelsFilterCustomizer.this.filter.setHighLevel(Math.max(LevelsFilterCustomizer.this.filter.getLowLevel(), v));
            } else if (this.dragHandle == 2) {
                LevelsFilterCustomizer.this.filter.setLowOutputLevel(Math.min(LevelsFilterCustomizer.this.filter.getHighOutputLevel(), v));
            } else if (this.dragHandle == 3) {
                LevelsFilterCustomizer.this.filter.setHighOutputLevel(Math.max(LevelsFilterCustomizer.this.filter.getLowOutputLevel(), v));
            }
            this.repaint();
            LevelsFilterCustomizer.this.preview();
        }
    }
}

