/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.beans.PropertySheet;
import com.jhlabs.image.BlurTransition;
import com.jhlabs.image.ColorWell;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.ImageUtils;
import com.jhlabs.image.PreviewFilterCustomizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class FilterApplet
extends JApplet
implements Runnable,
ActionListener {
    private PreviewFilterCustomizer customizer;
    private BufferedImageOp filter;
    private JMenuItem saveItem;
    private JMenuItem openItem;
    private Thread thread = null;

    public FilterApplet() {
        ColorWell.setStandalone(true);
    }

    public void init() {
        this.setBackground(Color.white);
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().setLayout(new BorderLayout());
        String filterName = this.getParameter("filter");
        String imageName = this.getParameter("image");
        try {
            InputStream is;
            this.filter = (BufferedImageOp)Class.forName(filterName).newInstance();
            String name = filterName;
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(index + 1);
            }
            if ((is = this.filter.getClass().getResourceAsStream(name + ".xml")) != null) {
                PreviewFilterCustomizer pfc = new PreviewFilterCustomizer(new PropertySheet(), true);
                PropertySheet propertySheet = pfc.getPropertySheet();
                propertySheet.loadXML(is);
                PreviewFilterCustomizer.previewWholeImage = true;
                this.customizer = pfc;
            } else {
                this.customizer = (PreviewFilterCustomizer)Class.forName(filterName + "Customizer").newInstance();
            }
        }
        catch (Throwable e) {
            System.out.println("Error loading " + filterName + ":");
            e.printStackTrace();
        }
        if (imageName == null) {
            imageName = "/flower.jpg";
        }
        Image im = new ImageIcon(this.getClass().getResource(imageName)).getImage();
        BufferedImage image = ImageUtils.createImage(im.getSource());
        this.customizer.setObject(this.filter);
        this.customizer.setPreviewImage(image);
        this.customizer.preview();
        if (this.filter instanceof BlurTransition) {
            Image im2 = new ImageIcon(this.getClass().getResource("/poppy.jpg")).getImage();
            BufferedImage image2 = ImageUtils.createImage(im2.getSource());
            ((BlurTransition)this.filter).setDestination(image2);
            this.startThread();
        }
        if (this.getParameter("menu") != null) {
            JMenuBar menubar = new JMenuBar();
            JMenu fileMenu = new JMenu("File");
            this.openItem = new JMenuItem("Open...");
            this.saveItem = new JMenuItem("Save...");
            this.openItem.addActionListener(this);
            this.saveItem.addActionListener(this);
            fileMenu.add(this.openItem);
            fileMenu.add(this.saveItem);
            menubar.add(fileMenu);
            this.getContentPane().add((Component)menubar, "North");
        }
        this.getContentPane().add((Component)this.customizer, "Center");
    }

    public void startThread() {
        if (this.thread == null) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            float t = 0.0f;
            while (true) {
                t += 0.05f;
                if (this.filter != null) {
                    BufferedImageOp bufferedImageOp = this.filter;
                    synchronized (bufferedImageOp) {
                        ((BlurTransition)this.filter).setTransition(ImageMath.triangle(t));
                        this.customizer.preview();
                    }
                }
                Thread.sleep(40L);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Object source = e.getSource();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

