/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.ExploreLayout;
import com.jhlabs.image.MutatableFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ExplorePanel
extends JPanel {
    private MutateSample[] samples;
    private boolean keepColors = false;
    private boolean keepShape = false;
    private float mutationLevel = 1.0f;
    private boolean stopThread = false;
    private Thread filterThread;

    public ExplorePanel() {
        Border b = BorderFactory.createLineBorder(Color.black);
        this.setLayout(new ExploreLayout());
        this.samples = new MutateSample[13];
        for (int i = 0; i < this.samples.length; ++i) {
            this.samples[i] = new MutateSample(i);
            this.samples[i].setBorder(b);
            this.add(this.samples[i]);
        }
    }

    public BufferedImageOp getSelected() {
        return this.samples[0].getFilter();
    }

    public void setKeepShape(boolean keepShape) {
        this.keepShape = keepShape;
    }

    public boolean isKeepShape() {
        return this.keepShape;
    }

    public void setKeepColors(boolean keepColors) {
        this.keepColors = keepColors;
    }

    public boolean isKeepColors() {
        return this.keepColors;
    }

    public void setMutationLevel(float mutationLevel) {
        this.mutationLevel = mutationLevel;
    }

    public float setMutationLevel() {
        return this.mutationLevel;
    }

    public void setFilter(AbstractBufferedImageOp filter) {
        for (int i = 0; i < this.samples.length; ++i) {
            this.samples[i].filter = (BufferedImageOp)filter.clone();
            int w = i == 0 ? 144 : 64;
            this.samples[i].setImage(new BufferedImage(w, w, 2));
        }
        this.samples[0].refilter();
        this.choose(0, false, false);
    }

    public void choose(final int id, final boolean keepColors, final boolean keepShape) {
        int i;
        if (id != 0) {
            BufferedImageOp filter = this.samples[0].filter;
            this.samples[0].filter = this.samples[id].filter;
            this.samples[id].filter = filter;
        }
        int n = i = id == 0 ? 1 : 0;
        while (i < this.samples.length) {
            this.samples[i].filtering = true;
            this.samples[i].repaint();
            ++i;
        }
        this.stopThread = true;
        try {
            if (this.filterThread != null) {
                this.filterThread.join();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.stopThread = false;
        this.filterThread = new Thread(new Runnable(){

            public void run() {
                MutatableFilter sourceFilter = (MutatableFilter)((Object)((ExplorePanel)ExplorePanel.this).samples[0].filter);
                for (int i = 0; !ExplorePanel.this.stopThread && i < ExplorePanel.this.samples.length; ++i) {
                    if (i != 0) {
                        sourceFilter.mutate(ExplorePanel.this.mutationLevel, ((ExplorePanel)ExplorePanel.this).samples[i].filter, keepShape, keepColors);
                    }
                    if (i == 0 && id == 0) continue;
                    ExplorePanel.this.samples[i].refilter();
                }
            }
        });
        this.filterThread.start();
        this.firePropertyChange("filter", null, this.getSelected());
    }

    class MutateSample
    extends JComponent
    implements MouseListener {
        public BufferedImageOp filter;
        private BufferedImage image;
        private int id;
        public boolean filtering;

        public MutateSample(int id) {
            this.id = id;
            this.addMouseListener(this);
            this.setBackground(Color.white);
        }

        public Dimension getPreferredSize() {
            int w = this.id == 0 ? 144 : 64;
            return new Dimension(w, w);
        }

        public void refilter() {
            if (this.image != null) {
                this.image = this.filter.filter(this.image, this.image);
                this.setImage(this.image);
            }
        }

        public void setFilter(BufferedImageOp filter) {
            this.filter = filter;
        }

        public BufferedImageOp getFilter() {
            return this.filter;
        }

        public void mousePressed(MouseEvent e) {
            ExplorePanel.this.choose(this.id, ExplorePanel.this.keepColors, ExplorePanel.this.keepShape);
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void setImage(BufferedImage image) {
            this.image = image;
            this.filtering = false;
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            if (!this.filtering && this.image != null) {
                int x = (size.width - this.image.getWidth(this)) / 2;
                int y = (size.height - this.image.getHeight(this)) / 2;
                g.drawImage(this.image, x, y, this);
            }
        }
    }
}

