/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontChooser
extends JPanel
implements ItemListener,
ChangeListener {
    private int[] sizeValues = new int[]{8, 9, 10, 12, 14, 18, 24, 36, 48, 56, 72, 96, 128, 192, 255};
    private JComboBox families;
    private JComboBox sizes;
    private JSpinner sizeSpinner;
    private JCheckBox bold;
    private JCheckBox italic;
    private Vector listeners = null;
    private String family;
    private int size;
    private int style;
    private Font sampleFont;

    public FontChooser() {
        this.add(new Label("Font:", 2));
        this.families = new JComboBox();
        this.add(this.families);
        this.families.setMaximumRowCount(40);
        String[] fonts = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fonts = ge.getAvailableFontFamilyNames();
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (fonts == null) {
            fonts = this.getToolkit().getFontList();
        }
        for (int i = 0; i < fonts.length; ++i) {
            this.families.addItem(fonts[i]);
        }
        Integer value = new Integer(24);
        Integer min = new Integer(1);
        Integer max = new Integer(2000);
        Integer step = new Integer(1);
        SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
        this.sizeSpinner = new JSpinner(model);
        this.sizeSpinner.addChangeListener(this);
        this.add(this.sizeSpinner);
        this.bold = new JCheckBox("Bold");
        this.add(this.bold);
        this.italic = new JCheckBox("Italic");
        this.add(this.italic);
        this.family = "Courier";
        this.size = 48;
        this.families.addItemListener(this);
        this.bold.addItemListener(this);
        this.italic.addItemListener(this);
    }

    public void setObject(Font font) {
        this.sampleFont = font;
        if (font != null) {
            this.family = font.getFamily();
            this.size = font.getSize();
            this.style = font.getStyle();
            this.families.setSelectedItem(this.family);
            if (this.sizes != null) {
                this.sizes.setSelectedItem(Integer.toString(this.size));
            } else {
                this.sizeSpinner.setValue(new Integer(this.size));
            }
            this.bold.setSelected((this.style & 1) != 0);
            this.italic.setSelected((this.style & 2) != 0);
        }
    }

    public Font getObject() {
        return this.sampleFont;
    }

    public void fontChanged() {
        this.sampleFont = new Font(this.family, this.style, this.size);
        this.notifyListeners();
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        if (source == this.families) {
            this.family = (String)this.families.getSelectedItem();
            this.fontChanged();
        } else if (source == this.sizes) {
            try {
                this.size = Integer.parseInt((String)this.sizes.getSelectedItem());
                this.fontChanged();
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (source == this.bold) {
            this.style = this.bold.isSelected() ? (this.style |= 1) : (this.style &= 0xFFFFFFFE);
            this.fontChanged();
        } else if (source == this.italic) {
            this.style = this.italic.isSelected() ? (this.style |= 2) : (this.style &= 0xFFFFFFFD);
            this.fontChanged();
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == this.sizeSpinner) {
            this.size = ((SpinnerNumberModel)this.sizeSpinner.getModel()).getNumber().intValue();
            this.fontChanged();
        }
    }

    public void addActionListener(ActionListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(l);
    }

    public void removeActionListener(ActionListener l) {
        if (this.listeners != null) {
            this.listeners.removeElement(l);
        }
    }

    public void notifyListeners() {
        if (this.listeners != null) {
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ActionListener l = (ActionListener)e.nextElement();
                l.actionPerformed(new ActionEvent(this, 1001, null));
            }
        }
    }
}

