/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.ui;

import com.jhlabs.ie.ui.ColormapIcon;
import com.jhlabs.image.ArrayColormap;
import com.jhlabs.image.ImageMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;

public class ArrayColormapCustomizer
extends JComponent
implements PropertyChangeListener {
    public ArrayColormap colormap;
    private Image image;
    private ImageIcon arrowIcon;
    private int[] bounds = new int[]{0, 255};
    private int dragKnot = -1;
    private Graphics dragGraphics;
    private int dragX = 0;
    private int dragDX = 0;
    private int margin = 4;
    private int currentColor = -16777216;
    private Icon icon;
    protected Vector listeners = new Vector();

    public ArrayColormapCustomizer() {
        this(null);
    }

    public ArrayColormapCustomizer(ArrayColormap c) {
        this.setObject(c);
        this.enableEvents(16L);
        this.arrowIcon = new ImageIcon(this.getClass().getResource("arrowUp.gif"));
    }

    public void setObject(Object o) {
        this.colormap = (ArrayColormap)o;
        this.repaint();
    }

    public void repaint() {
        Dimension size = this.getSize();
        int w = size.width - 2 * this.margin;
        this.icon = new ColormapIcon(this.colormap, w, 16);
        super.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(128, 28);
    }

    public Dimension getMinimumSize() {
        return new Dimension(128, 28);
    }

    public void paintComponent(Graphics g) {
        if (this.colormap != null) {
            Dimension size = this.getSize();
            int w = size.width - 2 * this.margin;
            int h = size.height;
            this.icon.paintIcon(this, g, this.margin, 2);
            for (int i = 0; i < 2; ++i) {
                int x = this.margin + w * this.bounds[i] / 255;
                g.setColor(Color.gray);
                this.arrowIcon.paintIcon(this, g, x - 3, 19);
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        if (this.colormap == null) {
            return;
        }
        int id = e.getID();
        int x = e.getX();
        int y = e.getY();
        int width = this.getSize().width - 2 * this.margin;
        block0 : switch (id) {
            case 501: {
                if (y <= 19) {
                    int index = 255 * (x - this.margin) / width;
                    int lower = Math.min(this.bounds[0], this.bounds[1]);
                    int upper = Math.max(this.bounds[0], this.bounds[1]);
                    index = ImageMath.clamp(index, lower, upper);
                    if (e.isControlDown()) {
                        this.colormap.setColorRange(lower, upper, this.currentColor);
                    } else {
                        this.colormap.setColorInterpolated(index, lower, upper, this.currentColor);
                    }
                    this.repaint();
                    break;
                }
                for (int i = 0; i < 2; ++i) {
                    int pos = this.margin + width * this.bounds[i] / 255;
                    if (Math.abs(x - pos) >= 4) continue;
                    this.dragGraphics = this.getGraphics();
                    this.dragGraphics.setXORMode(this.getBackground());
                    this.dragKnot = i;
                    this.dragX = x;
                    this.dragDX = 0;
                    this.arrowIcon.paintIcon(this, this.dragGraphics, this.dragX - this.dragDX - 3, 19);
                    this.enableEvents(48L);
                    break block0;
                }
                break;
            }
            case 502: {
                this.enableEvents(16L);
                if (this.dragKnot != -1) {
                    this.arrowIcon.paintIcon(this, this.dragGraphics, this.dragX - this.dragDX - 3, 19);
                    this.dragGraphics.dispose();
                    this.dragGraphics = null;
                    this.bounds[this.dragKnot] = ImageMath.clamp(255 * ((x -= this.dragDX) - this.margin) / width, 0, 255);
                    this.repaint();
                    this.fireStateChanged();
                }
                this.dragKnot = -1;
            }
        }
        super.processMouseEvent(e);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        int id = e.getID();
        int x = e.getX();
        int y = e.getY();
        switch (id) {
            case 506: {
                if (this.dragKnot == -1) break;
                this.arrowIcon.paintIcon(this, this.dragGraphics, this.dragX - this.dragDX - 3, 19);
                this.dragX = ImageMath.clamp(x, this.margin, this.getSize().width - this.margin);
                this.arrowIcon.paintIcon(this, this.dragGraphics, this.dragX - this.dragDX - 3, 19);
            }
        }
        super.processMouseMotionEvent(e);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addElement(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeElement(l);
    }

    protected void fireStateChanged() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object value;
        if ("color".equals(event.getPropertyName()) && (value = event.getNewValue()) instanceof Color) {
            this.currentColor = ((Color)value).getRGB();
        }
    }
}

