/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.ie.tool;

import com.jhlabs.ie.tool.DrawShapeTool;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RoundRectangleTool
extends DrawShapeTool {
    private float radius = 16.0f;

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public Shape makeShape() {
        Rectangle r = this.getRectangle();
        return new RoundRectangle2D.Float(r.x, r.y, r.width, r.height, this.radius, this.radius);
    }

    public String getToolTipText() {
        return "Round Rectangle Tool";
    }

    public String getHelpText() {
        return "Round Rectangle Tool: Meta key picks color, Shift key fills";
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new Customizer();
    }

    class Customizer
    extends DrawShapeTool.DrawShapeToolCustomizer
    implements ChangeListener {
        private JSpinner radiusField;

        public Customizer() {
            this.add(new JLabel("Radius:", 4));
            Float value = new Float(RoundRectangleTool.this.radius);
            Float min = new Float(0.0f);
            Float max = new Float(100.0f);
            Float step = new Float(1.0f);
            SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
            this.radiusField = new JSpinner(model);
            this.radiusField.addChangeListener(this);
            this.add(this.radiusField);
        }

        public void setObject(Object o) {
            this.radiusField.setValue(new Float(RoundRectangleTool.this.getRadius()));
            super.setObject(o);
        }

        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (source == this.radiusField) {
                RoundRectangleTool.this.setRadius(((SpinnerNumberModel)this.radiusField.getModel()).getNumber().floatValue());
            }
            super.stateChanged(e);
        }
    }
}

